/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.I_C_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListLine;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.erpya.lve.model.X_LVE_ListLine;
import org.erpya.lve.util.WHConceptSettingOrder;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public class OrderISLR
extends AbstractWithholdingSetting {
    private MOrder order;
    private MBPartner businessPartner;
    private String bpartnerPersonType = null;
    private HashMap<MLVEList, WHConceptSettingOrder> conceptsToApply = new HashMap();
    BigDecimal tributeUnitAmount = Env.ZERO;
    private static BigDecimal FACTOR = new BigDecimal(83.3334);
    int curPrecision = 0;
    private boolean isManual = false;

    public OrderISLR(MWHSetting setting) {
        super(setting);
    }

    public boolean isValid() {
        MDocType documentType;
        MLVEWithholdingTax currentWHTax;
        boolean isValid = true;
        if (this.getDocument().get_Table_ID() != I_C_Order.Table_ID) {
            this.addLog("@C_Order_ID@ @NotFound@");
            return false;
        }
        this.order = (MOrder)this.getDocument();
        if (this.order != null) {
            MCurrency currency = (MCurrency)this.order.getC_Currency();
            this.curPrecision = currency.getStdPrecision();
        }
        if ((currentWHTax = MLVEWithholdingTax.getFromClient(this.getContext(), this.getDocument().getAD_Org_ID(), "IS")) == null) {
            this.addLog("@LVE_WithholdingTax_ID@ @NotFound@");
            isValid = false;
        }
        if (currentWHTax != null && currentWHTax.isClientExcluded()) {
            this.addLog("@IsClientExcluded@ " + currentWHTax.getName());
            isValid = false;
        }
        if (!this.order.getDocStatus().equals("CO")) {
            this.addLog("@Invalid@ @C_Order_ID@ @DocStatus@");
            isValid = false;
        }
        if ((documentType = MDocType.get((Properties)this.getContext(), (int)this.order.getC_DocTypeTarget_ID())) == null) {
            this.addLog("@C_DocType_ID@ @NotFound@");
            isValid = false;
        }
        this.businessPartner = (MBPartner)this.order.getC_BPartner();
        Optional.ofNullable(this.order).ifPresent(order -> {
            this.setReturnValue("SourceOrder_ID", order.getC_Order_ID());
            this.setReturnValue("AD_Org_ID", order.getAD_Org_ID());
            if (order.isSOTrx()) {
                this.isManual = true;
                Optional.ofNullable(MOrgInfo.get((Properties)this.getContext(), (int)order.getAD_Org_ID(), (String)order.get_TrxName())).ifPresent(orgInfo -> {
                    this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)orgInfo.get_ValueAsInt("WH_BPartner_ID"));
                });
            } else {
                this.isManual = false;
            }
        });
        if (this.businessPartner == null) {
            this.addLog("@C_BPartner_ID@ @NotFound@");
            isValid = false;
        } else {
            String errorMessage;
            this.bpartnerPersonType = this.businessPartner.get_ValueAsString("PersonType");
            if (Util.isEmpty((String)this.bpartnerPersonType)) {
                this.addLog("@PersonType@ @NotFound@ @C_BPartner_ID@ " + this.businessPartner.getValue() + " - " + this.businessPartner.getName());
                isValid = false;
            }
            if (this.businessPartner.get_ValueAsBoolean("IsWithholdingRentalExempt")) {
                isValid = false;
                this.addLog("@C_BPartner_ID@ @IsWithholdingRentalExempt@");
            }
            this.setConcepts();
            if (this.conceptsToApply.size() == 0) {
                isValid = false;
                this.addLog("@NotFound@ @WithholdingRentalConcept_ID@");
            }
            if (currentWHTax != null) {
                this.tributeUnitAmount = currentWHTax.getValidTributeUnitAmount(this.order.getDateAcct());
            }
            if (this.tributeUnitAmount.equals(Env.ZERO)) {
                this.addLog("@TributeUnit@ (@Rate@ @NotFound@)");
                isValid = false;
            }
            if ((errorMessage = this.setRates()) != null && !errorMessage.isEmpty()) {
                if (!this.conceptsToApply.entrySet().stream().anyMatch(rateToApply -> ((WHConceptSettingOrder)rateToApply.getValue()).isGenerateDocument())) {
                    isValid = false;
                }
                this.addLog(errorMessage);
            }
            if (this.isGenerated()) {
                isValid = false;
            }
        }
        return isValid;
    }

    public String run() {
        this.conceptsToApply.entrySet().stream().filter(rateToApply -> ((WHConceptSettingOrder)rateToApply.getValue()).isGenerateDocument()).forEach(rateToApply -> {
            WHConceptSettingOrder conceptSetting = (WHConceptSettingOrder)rateToApply.getValue();
            BigDecimal rate = conceptSetting.getRate();
            this.setReturnValue("WithholdingRentalRate_ID", conceptSetting.getRateToApply().getLVE_ListVersion_ID());
            if (conceptSetting.isVarRate()) {
                this.setReturnValue("WithholdingVariableRate_ID", conceptSetting.getVarRateToApply().getLVE_ListLine_ID());
            }
            if (rate == null) {
                rate = Env.ZERO;
            }
            if (rate.compareTo(Env.ZERO) != 0) {
                this.setWithholdingRate(rate);
                rate = this.getWithholdingRate(true);
                this.addBaseAmount(conceptSetting.getAmtBase());
                if (conceptSetting.isValid()) {
                    this.addWithholdingAmount(conceptSetting.getAmtBase().multiply(rate, MathContext.DECIMAL128).setScale(this.curPrecision, 4).subtract(conceptSetting.getAmtSubtract()));
                } else {
                    this.addWithholdingAmount(Env.ZERO);
                }
                this.addDescription(((MLVEList)rateToApply.getKey()).getName());
                this.setReturnValue("Subtrahend", conceptSetting.getAmtSubtract());
                this.setReturnValue("IsCumulativeWithholding", conceptSetting.isCumulative());
                this.setReturnValue("IsSimulation", !conceptSetting.isValid());
                this.setReturnValue("IsManual", this.isManual);
                int WHThirdParty_ID = this.order.get_ValueAsInt("WHThirdParty_ID");
                if (WHThirdParty_ID != 0) {
                    this.setReturnValue("WHThirdParty_ID", WHThirdParty_ID);
                }
                this.setReturnValue("IsSimulation", true);
                this.saveResult();
            }
        });
        this.conceptsToApply.clear();
        this.curPrecision = 0;
        return null;
    }

    private void setConcepts() {
        if (this.order != null) {
            MOrderLine[] oLines;
            if (this.order.get_ValueAsInt("WithholdingRentalConcept_ID") != 0) {
                this.conceptsToApply.put(MLVEList.get(this.getContext(), this.order.get_ValueAsInt("WithholdingRentalConcept_ID")), new WHConceptSettingOrder(this.order.getTotalLines()));
                return;
            }
            for (MOrderLine line : oLines = this.order.getLines()) {
                MCharge charge;
                MProduct product;
                MLVEList list = null;
                if (line.getM_Product_ID() != 0 && (product = (MProduct)line.getM_Product()).get_ValueAsInt("WithholdingRentalConcept_ID") != 0) {
                    list = MLVEList.get(this.getContext(), product.get_ValueAsInt("WithholdingRentalConcept_ID"));
                }
                if (line.getC_Charge_ID() != 0 && (charge = (MCharge)line.getC_Charge()).get_ValueAsInt("WithholdingRentalConcept_ID") != 0) {
                    list = MLVEList.get(this.getContext(), charge.get_ValueAsInt("WithholdingRentalConcept_ID"));
                }
                if (list == null) continue;
                this.conceptsToApply.compute(list, (concept, rateToApply) -> rateToApply == null ? new WHConceptSettingOrder(line.getLineNetAmt()) : rateToApply.addAmtBase(line.getLineNetAmt()));
            }
        }
    }

    private String setRates() {
        AtomicReference<String> resultMessage = new AtomicReference<String>();
        resultMessage.set("");
        this.conceptsToApply.forEach((whConcept, whConceptSetting) -> {
            MLVEListVersion rateToApply = whConcept.getValidVersionInstance(this.order.getDateOrdered(), "PersonType", this.bpartnerPersonType);
            MLVEListLine varRateToApply = null;
            BigDecimal subtractAmt = Env.ZERO;
            if (rateToApply != null) {
                if (rateToApply.get_ValueAsBoolean("IsVariableRate")) {
                    List<MLVEListLine> varRate = rateToApply.getListLine();
                    if (varRate != null) {
                        varRateToApply = varRate.stream().filter(listLine -> whConceptSetting.getAmtBase().compareTo(listLine.getMinValue().multiply(this.tributeUnitAmount)) >= 0 && (whConceptSetting.getAmtBase().compareTo(listLine.getMaxValue().multiply(this.tributeUnitAmount)) <= 0 || listLine.getMaxValue().compareTo(Env.ZERO) == 0)).sorted(Comparator.comparing(X_LVE_ListLine::getSeqNo)).findFirst().orElse(null);
                        if (varRateToApply == null) {
                            varRate.stream().filter(listLine -> whConceptSetting.getAmtBase().compareTo(listLine.getMinValue().multiply(this.tributeUnitAmount)) < 0 || whConceptSetting.getAmtBase().compareTo(listLine.getMaxValue().multiply(this.tributeUnitAmount)) > 0 && listLine.getMaxValue().compareTo(Env.ZERO) != 0).sorted(Comparator.comparing(X_LVE_ListLine::getSeqNo)).forEach(listLine -> {
                                String minValue = NumberFormat.getInstance().format(listLine.getMinValue().multiply(this.tributeUnitAmount, MathContext.DECIMAL128));
                                String maxValue = NumberFormat.getInstance().format(listLine.getMaxValue().multiply(this.tributeUnitAmount, MathContext.DECIMAL128));
                                String baseAmt = NumberFormat.getInstance().format(whConceptSetting.getAmtBase());
                                resultMessage.set((String)resultMessage.get() + (((String)resultMessage.get()).isEmpty() ? "" : "- ") + "@A_Base_Amount@ < @MinAmt@ @OR@ > @MaxAmt@ (@MinAmt@ = " + minValue + " - @MaxAmt@ = " + maxValue + "  - @A_Base_Amount@ = " + baseAmt + ") \n");
                            });
                        } else {
                            whConceptSetting.setGenerateDocument(true);
                        }
                    }
                } else if (this.bpartnerPersonType.equals("PNR")) {
                    BigDecimal minValue = this.tributeUnitAmount.multiply(FACTOR, MathContext.DECIMAL128).setScale(this.curPrecision, 4);
                    subtractAmt = minValue.multiply(rateToApply.getAmount().divide(Env.ONEHUNDRED, MathContext.DECIMAL128), MathContext.DECIMAL128).setScale(this.curPrecision, 4);
                    if (whConceptSetting.getAmtBase().compareTo(minValue) >= 0) {
                        whConceptSetting.setGenerateDocument(true);
                    } else {
                        if (rateToApply.get_ValueAsBoolean("IsCumulativeWithholding")) {
                            subtractAmt = minValue.multiply(rateToApply.getAmount().divide(Env.ONEHUNDRED, MathContext.DECIMAL128), MathContext.DECIMAL128).setScale(this.curPrecision, 4);
                            whConceptSetting.setGenerateDocument(true);
                            whConceptSetting.setValid(false);
                        }
                        resultMessage.set("@A_Base_Amount@ < @MinimumAmt@ ( @MinimumAmt@ = " + minValue + " @A_Base_Amount@ = " + whConceptSetting.getAmtBase() + ") \n");
                    }
                } else {
                    whConceptSetting.setGenerateDocument(true);
                }
                whConceptSetting.setRateToApply(rateToApply);
                whConceptSetting.setVarRateToApply(varRateToApply);
                whConceptSetting.setAmtSubtract(subtractAmt);
                whConceptSetting.setCumulative(rateToApply.isCumulativeWithholding());
                if (varRateToApply != null) {
                    whConceptSetting.setRate((BigDecimal)varRateToApply.get_Value("Col_1"));
                } else {
                    whConceptSetting.setRate(rateToApply.getAmount());
                }
            } else {
                resultMessage.set((String)resultMessage.get() + "- @NotFound@ @WithholdingRentalRate_ID@");
            }
        });
        return (String)resultMessage.get();
    }

    private boolean isGenerated() {
        if (this.order != null) {
            return new Query(this.getContext(), "WH_Withholding", "SourceOrder_ID = ? AND WH_Definition_ID = ? AND WH_Setting_ID = ? AND Processed = 'Y' AND IsSimulation='Y' AND DocStatus IN (?,?)", this.getTransactionName()).setParameters(new Object[]{this.order.get_ID(), this.getDefinition().get_ID(), this.getSetting().get_ID(), "CO", "CL"}).match();
        }
        return false;
    }
}

