/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.util.Util;

public class LVEUtil {
    public static final String COLUMNNAME_LVE_FiscalCurrency_ID = "LVE_FiscalCurrency_ID";
    public static final String COLUMNNAME_LVE_InvoiceCurrency_ID = "LVE_InvoiceCurrency_ID";
    public static final String COLUMNNAME_IsInvoicedWithOrgCurrency = "IsInvoicedWithOrgCurrency";
    public static final String COLUMNNAME_IsDefinedAsClient = "IsDefinedAsClient";
    public static final String COLUMNNAME_InvoiceToAllocate_ID = "InvoiceToAllocate_ID";
    public static final String COLUMNNAME_IsFiscalDocument = "IsFiscalDocument";
    public static final String COLUMNNAME_IsSetControlNoOnPrint = "IsSetControlNoOnPrint";
    public static final String COLUMNNAME_ControlNo = "ControlNo";
    public static final String COLUMNNAME_ControlNoSequence_ID = "ControlNoSequence_ID";
    public static final String COLUMNNAME_IsHasSpecialTax = "IsHasSpecialTax";
    public static final String COLUMNNAME_IsAllocateInvoice = "IsAllocateInvoice";
    public static final String COLUMNNAME_PersonType = "PersonType";
    public static final String COLUMNNAME_WithholdingTaxRate_ID = "WithholdingTaxRate_ID";
    public static final String COLUMNNAME_IsFBTTTaxExempt = "IsFBTTTaxExempt";
    public static final String COLUMNNAME_IsWithholdingRentalExempt = "IsWithholdingRentalExempt";
    public static final String COLUMNNAME_IsWithholdingTaxExempt = "IsWithholdingTaxExempt";
    public static final String COLUMNNAME_TributeUnitType_ID = "TributeUnitType_ID";
    public static final String COLUMNNAME_IsWithholdingTaxApplied = "IsWithholdingTaxApplied";
    public static final String COLUMNNAME_WithholdingRentalRate_ID = "WithholdingRentalRate_ID";
    public static final String COLUMNNAME_WithholdingRentalConcept_ID = "WithholdingRentalConcept_ID";
    public static final String COLUMNNAME_WithholdingVariableRate_ID = "WithholdingVariableRate_ID";
    public static final String COLUMNNAME_WithholdingMunicipalRate_ID = "WithholdingMunicipalRate_ID";
    public static final String COLUMNNAME_BusinessActivity_ID = "BusinessActivity_ID";
    public static final String COLUMNNAME_IsWithholdingMunicipalExempt = "IsWithholdingMunicipalExempt";
    public static final String COLUMNNAME_IsVariableRate = "IsVariableRate";
    public static final String COLUMNNAME_VariableRate = "Col_1";
    public static final String COLUMNNAME_Subtrahend = "Subtrahend";
    public static final String COLUMNNAME_IsCumulativeWithholding = "IsCumulativeWithholding";
    public static final String COLUMNNAME_IsPrebornLeavePaid = "IsPrebornLeavePaid";
    public static final String COLUMNNAME_WHThirdParty_ID = "WHThirdParty_ID";
    public static final String COLUMNNAME_IsSimulation = "IsSimulation";
    public static final String COLUMNNAME_AffectedDocumentNo = "AffectedDocumentNo";
    public static final String COLUMNNAME_BankClientNo = "BankClientNo";
    public static final String COLUMNNAME_IsTaxpayer = "IsTaxpayer";
    public static final String COLUMNNAME_SICACode = "SICACode";
    public static final String COLUMNNAME_BANAVIHCode = "BANAVIHCode";
    public static final String COLUMNNAME_IsReCalculatePriceOnInvoice = "IsReCalculatePriceOnInvoice";
    public static final String COLUMNNAME_WH_BPartner_ID = "WH_BPartner_ID";
    public static final String ENABLE_CODE_TYPE_VALIDATION = "ENABLE_CODE_TYPE_VALIDATION";
    public static final String ENABLE_MULTI_CLIENT = "ENABLE_MULTI_CLIENT";
    public static final String COLUMNNAME_LVE_CommercialActivityLicense = "LVE_CommercialActivityLicense";
    public static final String COLUMNNAME_LVE_DefaultStatementCharge_ID = "LVE_DefaultStatementCharge_ID";
    public static final String COLUMNNAME_LVE_AutoDebitInvoice_ID = "LVE_AutoDebitInvoice_ID";
    public static final String COLUMNNAME_LVE_AllowOverPayInvoice = "LVE_AllowOverPayInvoice";

    public static String processBusinessPartnerValue(Properties context, int clientId, int organizationId, String value) {
        if (Util.isEmpty((String)value)) {
            value = "";
        }
        value = value.trim();
        boolean isValidationEnabled = MSysConfig.getBooleanValue((String)ENABLE_CODE_TYPE_VALIDATION, (boolean)false, (int)clientId, (int)organizationId);
        if (isValidationEnabled) {
            if (value.length() < 6 || value.length() > 11) {
                throw new AdempiereException("@LVEInvalidBPValue@");
            }
            Matcher matcher = Pattern.compile("[^0-9JVEGjveg]", 34).matcher(value);
            if (matcher.find()) {
                throw new AdempiereException("@LVEInvalidBPValue@");
            }
            Matcher matcherforKey = Pattern.compile("^[JVEGjveg]+$", 34).matcher(value.substring(0, 1));
            if (!matcherforKey.find()) {
                throw new AdempiereException("@LVEInvalidBPValue@");
            }
            if (!value.substring(1, value.length() - 1).matches("[+-]?\\d*(\\.\\d+)?")) {
                throw new AdempiereException("@LVEInvalidBPValue@");
            }
        }
        return Optional.ofNullable(value).orElse("").replaceAll("[^0-9JVEGjveg]", "").toUpperCase();
    }

    public static void setDefaultValuesFromDocumentType(PO entity) {
        int columnIndex = entity.get_ColumnIndex("C_DocTypeTarget_ID");
        if (columnIndex < 0) {
            columnIndex = entity.get_ColumnIndex("C_DocType_ID");
        }
        if (columnIndex < 0) {
            return;
        }
        int documentTypeId = entity.get_ValueAsInt(columnIndex);
        if (documentTypeId <= 0) {
            return;
        }
        if (entity.is_new() || entity.is_ValueChanged(columnIndex)) {
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)documentTypeId);
            entity.set_ValueOfColumn(COLUMNNAME_IsWithholdingTaxExempt, documentType.get_Value(COLUMNNAME_IsWithholdingTaxExempt));
        }
    }
}

