/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrgInfo;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MHREmployee;
import org.spin.model.X_RV_HR_ProcessDetail;
import org.spin.util.AbstractPayrollReportExport;

public class HR_BANAVIH
extends AbstractPayrollReportExport {
    private static CLogger s_log = CLogger.getCLogger(HR_BANAVIH.class);
    private static final int BP_NATIONALITY = 0;
    private static final int BP_TAX_ID = 1;
    private static final int BP_FIRST_NAME_1 = 2;
    private static final int BP_FIRST_NAME_2 = 3;
    private static final int BP_LAST_NAME_1 = 4;
    private static final int BP_LAST_NAME_2 = 5;
    private static final int EM_START_DATE = 6;
    private static final int EM_END_DATE = 7;
    private final String PAYROLL_CONSTANT = "N";
    private final String SEPARATOR = ",";
    private SimpleDateFormat dateFormat = null;
    private BigDecimal currentAmount = null;
    private X_RV_HR_ProcessDetail currentProcessDetail = null;
    private FileWriter fileWriter = null;
    private int lines = 0;
    private String fileName = "Temp";
    private final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("000000000.00");

    public HR_BANAVIH(Properties ctx) {
        super(ctx);
    }

    public boolean exportToFile(File file) {
        this.dateFormat = new SimpleDateFormat("ddMMyyyy");
        int currentBusinessPartnerId = 0;
        if (this.getDetail() == null || this.getDetail().isEmpty()) {
            return false;
        }
        Optional processDetail = this.getDetail().stream().findFirst();
        try {
            StringBuffer pathName = new StringBuffer();
            pathName.append("N").append(MOrgInfo.get((Properties)this.getCtx(), (int)((X_RV_HR_ProcessDetail)processDetail.get()).getAD_Org_ID(), (String)((X_RV_HR_ProcessDetail)processDetail.get()).get_TrxName()).get_ValueAsString("BANAVIHCode")).append(new SimpleDateFormat("MMyyyy").format(((X_RV_HR_ProcessDetail)processDetail.get()).getDateAcct()));
            this.fileName = pathName.toString();
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "Could not delete ", (Throwable)e);
        }
        try {
            Optional.ofNullable(file).ifPresent(fileToDelete -> fileToDelete.deleteOnExit());
            this.fileWriter = new FileWriter(file);
            ++this.lines;
            Map<Integer, List<X_RV_HR_ProcessDetail>> det = this.getDetail().stream().collect(Collectors.groupingBy(X_RV_HR_ProcessDetail::getC_BPartner_ID));
            for (Map.Entry<Integer, List<X_RV_HR_ProcessDetail>> detail : det.entrySet()) {
                if (detail == null || currentBusinessPartnerId == detail.getKey()) continue;
                this.writeLine();
                this.currentProcessDetail = detail.getValue().get(0);
                currentBusinessPartnerId = detail.getKey();
                this.currentAmount = detail.getValue().stream().map(x -> x.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            this.writeLine();
            this.fileWriter.flush();
            this.fileWriter.close();
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "", (Throwable)e);
            return false;
        }
        return true;
    }

    private void writeLine() throws IOException {
        if (this.currentProcessDetail == null) {
            return;
        }
        Map<Integer, String> bpInfo = this.processBPartner(this.currentProcessDetail.getC_BPartner_ID(), this.currentProcessDetail.getDateAcct(), this.currentProcessDetail.get_TrxName());
        if (bpInfo == null) {
            return;
        }
        StringBuffer line = new StringBuffer();
        if (this.currentAmount == null) {
            this.currentAmount = Env.ZERO;
        }
        String currentAmountAsString = this.DECIMAL_FORMAT.format(this.currentAmount);
        if (this.lines > 1) {
            line.append(Env.NL);
        }
        line.append(bpInfo.get(0)).append(",").append(bpInfo.get(1)).append(",").append(bpInfo.get(2)).append(",").append(bpInfo.get(3)).append(",").append(bpInfo.get(4)).append(",").append(bpInfo.get(5)).append(",").append(currentAmountAsString.replace(",", ".").replace(".", "")).append(",").append(bpInfo.get(6)).append(",").append(bpInfo.get(7));
        this.fileWriter.write(line.toString());
        ++this.lines;
    }

    private Map<Integer, String> processBPartner(int businessPartnerId, Timestamp dateAcct, String transactionName) {
        HashMap<Integer, String> bpInfo = new HashMap<Integer, String>();
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)businessPartnerId);
        String name = bpartner.getName();
        String name2 = bpartner.getName2();
        if (Util.isEmpty((String)name)) {
            name = "";
        }
        if (Util.isEmpty((String)name2)) {
            name2 = "";
        }
        List<String> nameList = Arrays.asList(name.split(" "));
        String firstName1 = "";
        String firstName2 = "";
        boolean isName = false;
        for (String firstName : nameList) {
            if (isName) {
                firstName2 = firstName2 + firstName + " ";
            }
            if (firstName.length() < 3 && !isName) {
                firstName1 = firstName1 + firstName + " ";
                continue;
            }
            if (firstName.length() <= 2 || isName) continue;
            firstName1 = firstName1 + firstName;
            isName = true;
        }
        List<String> lastNameList = Arrays.asList(name2.split(" "));
        String lastName1 = "";
        String lastName2 = "";
        isName = false;
        for (String lastName : lastNameList) {
            if (isName) {
                lastName2 = lastName2 + lastName + " ";
            }
            if (lastName.length() < 3 && !isName) {
                lastName1 = lastName1 + lastName + " ";
                continue;
            }
            if (lastName.length() <= 2 || isName) continue;
            lastName1 = lastName1 + lastName;
            isName = true;
        }
        if (firstName1.length() > 25) {
            firstName1 = firstName1.substring(0, 24);
        } else if (firstName1.length() == 0) {
            firstName1 = "";
        }
        if (firstName2.length() > 25) {
            firstName2 = firstName2.substring(0, 24);
        } else if (firstName2.length() == 0) {
            firstName2 = "";
        }
        if (lastName1.length() > 25) {
            lastName1 = lastName1.substring(0, 24);
        } else if (lastName1.length() == 0) {
            lastName1 = "";
        }
        if (lastName2.length() > 25) {
            lastName2 = lastName2.substring(0, 24);
        } else if (lastName2.length() == 0) {
            lastName2 = "";
        }
        MHREmployee employee = this.getByPartnerIdAndStartDate(bpartner.getC_BPartner_ID(), dateAcct, transactionName);
        if (employee == null) {
            return null;
        }
        String startDate = this.dateFormat.format(employee.getStartDate());
        String endDate = "";
        if (employee.getEndDate() != null) {
            endDate = this.dateFormat.format(employee.getEndDate());
        }
        String bPTaxId = bpartner.getValue();
        String personType = bPTaxId.substring(0, 1);
        bPTaxId = bPTaxId.replaceAll("\\D+", "");
        bpInfo.put(0, personType);
        bpInfo.put(1, bPTaxId);
        bpInfo.put(2, this.processValue(firstName1));
        bpInfo.put(3, this.processValue(firstName2));
        bpInfo.put(4, this.processValue(lastName1));
        bpInfo.put(5, this.processValue(lastName2));
        bpInfo.put(6, startDate);
        bpInfo.put(7, endDate);
        return bpInfo;
    }

    private MHREmployee getByPartnerIdAndStartDate(int partnerId, Timestamp dateStart, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_BPartner_ID").append("=? AND ");
        whereClause.append("StartDate").append(" <= ?");
        return (MHREmployee)new Query(Env.getCtx(), "HR_Employee", whereClause.toString(), trxName).setClient_ID().setParameters(new Object[]{partnerId, dateStart}).setOrderBy("StartDate DESC, EndDate DESC").first();
    }

    public String processValue(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$,;*/\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00bf\u00a1]", "").trim();
    }

    public String getFileName() {
        return this.fileName;
    }
}

