/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class AllocationManager {
    private MInvoice document;
    Map<Integer, AllocationValues> documentsToAllocate;
    private Properties context;
    private String transactionName;

    public AllocationManager(MInvoice document) {
        if (document == null) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        this.setDocument(document);
    }

    public Properties getContext() {
        return this.context;
    }

    private void setContext(Properties context) {
        this.context = context;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public AllocationManager setDocument(MInvoice document) {
        this.document = document;
        this.setContext(document.getCtx());
        this.setTransactionName(document.get_TrxName());
        this.documentsToAllocate = new HashMap<Integer, AllocationValues>();
        return this;
    }

    public AllocationManager addAllocateDocument(MInvoice invoiceToAllocate, BigDecimal appliedAmount, BigDecimal discountAmount, BigDecimal writeOffAmount) {
        return this.addAllocateDocument(invoiceToAllocate.getC_Invoice_ID(), appliedAmount, discountAmount, writeOffAmount);
    }

    public AllocationManager addAllocateDocument(MInvoice invoiceToAllocate) {
        return this.addAllocateDocument(invoiceToAllocate.getC_Invoice_ID(), this.getOpenAmt(invoiceToAllocate), Env.ZERO, Env.ZERO);
    }

    public AllocationManager addAllocateDocument(int invoiceToAllocateId, BigDecimal appliedAmount, BigDecimal discountAmount, BigDecimal writeOffAmount) {
        if (invoiceToAllocateId <= 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        AllocationValues value = this.documentsToAllocate.get(invoiceToAllocateId);
        if (value != null) {
            value.addAppliedAmount(appliedAmount);
            value.addDiscountAmount(discountAmount);
            value.addWriteOffAmount(writeOffAmount);
        } else {
            value = new AllocationValues(appliedAmount, discountAmount, writeOffAmount);
        }
        MInvoice invoiceToAllocated = MInvoice.get((Properties)this.getContext(), (int)invoiceToAllocateId);
        if (invoiceToAllocated.isPaid()) {
            return this;
        }
        this.documentsToAllocate.put(invoiceToAllocateId, value);
        return this;
    }

    private BigDecimal getMultiplier(MInvoice invoice) {
        return invoice.isCreditMemo() ? Env.ONE.negate() : Env.ONE;
    }

    private BigDecimal getMultiplierSOTrx(MInvoice invoice) {
        return invoice.isSOTrx() ? Env.ONE.negate() : Env.ONE;
    }

    public void createAllocation() {
        if (this.document == null || this.documentsToAllocate.size() == 0) {
            return;
        }
        String allocationMessage = Msg.parseTranslation((Properties)this.document.getCtx(), (String)("@CreatedFromDocument@ @C_Invoice_ID@: " + this.document.getDocumentNo()));
        MAllocationHdr allocation = new MAllocationHdr(this.document.getCtx(), true, this.document.getDateInvoiced(), this.document.getC_Currency_ID(), allocationMessage, this.document.get_TrxName());
        allocation.setDateAcct(this.document.getDateAcct());
        allocation.setAD_Org_ID(this.document.getAD_Org_ID());
        allocation.saveEx();
        BigDecimal summaryAppliedAmount = Env.ZERO;
        for (Map.Entry<Integer, AllocationValues> allocationSet : this.documentsToAllocate.entrySet()) {
            int invoiceToAllocateId = allocationSet.getKey();
            MInvoice invoiceToAllocate = new MInvoice(this.getContext(), invoiceToAllocateId, this.getTransactionName());
            BigDecimal multiplier = this.getMultiplier(this.document);
            BigDecimal multiplierSO = this.getMultiplierSOTrx(this.document);
            BigDecimal multiplierSOCreditMemo = Env.ONE;
            if (this.document.isCreditMemo() && this.document.isSOTrx()) {
                multiplierSOCreditMemo = multiplierSOCreditMemo.negate();
            }
            BigDecimal openAmount = this.getOpenAmt(invoiceToAllocate);
            openAmount = openAmount.multiply(multiplier).multiply(multiplierSO).multiply(multiplierSOCreditMemo);
            BigDecimal appliedAmount = allocationSet.getValue().getAppliedAmount().multiply(multiplier).multiply(multiplierSO);
            BigDecimal discountAmmount = allocationSet.getValue().getDiscountAmount().multiply(multiplier).multiply(multiplierSO);
            BigDecimal writeOffAmount = allocationSet.getValue().getWriteOffAmount().multiply(multiplier).multiply(multiplierSO);
            BigDecimal overUnderAmount = openAmount.add(appliedAmount).add(discountAmmount).add(writeOffAmount);
            overUnderAmount = !invoiceToAllocate.isSOTrx() ? overUnderAmount.multiply(multiplier).multiply(multiplierSO.negate()) : overUnderAmount.multiply(multiplier).multiply(multiplierSO).multiply(multiplierSOCreditMemo);
            MAllocationLine allocationLine = new MAllocationLine(allocation, appliedAmount, discountAmmount, writeOffAmount, overUnderAmount);
            allocationLine.setDocInfo(invoiceToAllocate.getC_BPartner_ID(), invoiceToAllocate.getC_Order_ID(), invoiceToAllocate.getC_Invoice_ID());
            allocationLine.saveEx();
            summaryAppliedAmount = summaryAppliedAmount.add(appliedAmount);
        }
        BigDecimal openAmount = this.getOpenAmt(this.document);
        openAmount = openAmount.multiply(this.getMultiplierSOTrx(this.document));
        summaryAppliedAmount = summaryAppliedAmount.negate();
        BigDecimal overUnderAmount = openAmount.add(summaryAppliedAmount);
        MAllocationLine allocationLine = new MAllocationLine(allocation, summaryAppliedAmount, Env.ZERO, Env.ZERO, overUnderAmount);
        allocationLine.setDocInfo(this.document.getC_BPartner_ID(), this.document.getC_Order_ID(), this.document.getC_Invoice_ID());
        allocationLine.saveEx();
        if (!allocation.processIt("CO")) {
            throw new AdempiereException("@ProcessFailed@: " + allocation.getProcessMsg());
        }
        allocation.saveEx();
    }

    private BigDecimal getOpenAmt(MInvoice invoice) {
        Optional<MInvoice> maybeInvoice = Optional.ofNullable(invoice);
        AtomicReference<BigDecimal> openAmt = new AtomicReference<BigDecimal>(Env.ZERO);
        maybeInvoice.ifPresent(inv -> {
            if (!inv.isPaid()) {
                openAmt.set(inv.getGrandTotal());
                Optional<BigDecimal> maybeAmt = Optional.ofNullable(inv.getAllocatedAmt(true));
                maybeAmt.ifPresent(allocAmt -> openAmt.set(((BigDecimal)openAmt.get()).subtract((BigDecimal)allocAmt)));
                if (inv.isCreditMemo()) {
                    openAmt.set(((BigDecimal)openAmt.get()).negate());
                }
            }
        });
        return openAmt.get();
    }

    public static void main(String[] args) {
        Adempiere.startup((boolean)true);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)11);
        MInvoice invoice = new MInvoice(Env.getCtx(), 1000005, null);
        AllocationManager allocationManager = new AllocationManager(invoice);
        Arrays.asList(invoice.getLines()).stream().filter(invoiceLine -> invoiceLine.get_ValueAsInt("InvoiceToAllocate_ID") != 0).forEach(invoiceLine -> allocationManager.addAllocateDocument(invoiceLine.get_ValueAsInt("InvoiceToAllocate_ID"), invoiceLine.getLineNetAmt(), Env.ZERO, Env.ZERO));
        allocationManager.createAllocation();
    }

    private class AllocationValues {
        private BigDecimal appliedAmount;
        private BigDecimal discountAmount;
        private BigDecimal writeOffAmount;

        public AllocationValues(BigDecimal appliedAmount, BigDecimal discountAmount, BigDecimal writeOffAmount) {
            this.appliedAmount = appliedAmount;
            this.discountAmount = discountAmount;
            this.writeOffAmount = writeOffAmount;
        }

        public BigDecimal getAppliedAmount() {
            return this.appliedAmount;
        }

        public void addAppliedAmount(BigDecimal appliedAmount) {
            this.appliedAmount = this.appliedAmount.add(appliedAmount);
        }

        public BigDecimal getDiscountAmount() {
            return this.discountAmount;
        }

        public void addDiscountAmount(BigDecimal discountAmount) {
            this.discountAmount = this.discountAmount.add(discountAmount);
        }

        public BigDecimal getWriteOffAmount() {
            return this.writeOffAmount;
        }

        public void addWriteOffAmount(BigDecimal writeOffAmount) {
            this.writeOffAmount = this.writeOffAmount.add(writeOffAmount);
        }
    }
}

