/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public class APInvoiceIVA
extends AbstractWithholdingSetting {
    private MInvoice invoice;
    private MBPartner businessPartner;
    private List<MInvoiceTax> taxes;
    private boolean isManual = false;
    BigDecimal withholdingRate = Env.ZERO;

    public APInvoiceIVA(MWHSetting setting) {
        super(setting);
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this.getDocument().get_Table_ID() != I_C_Invoice.Table_ID) {
            this.addLog("@C_Invoice_ID@ @NotFound@");
            isValid = false;
        }
        this.invoice = (MInvoice)this.getDocument();
        this.businessPartner = (MBPartner)this.invoice.getC_BPartner();
        if (!this.businessPartner.get_ValueAsBoolean("IsTaxpayer") && this.invoice.isSOTrx()) {
            this.addLog("@C_BPartner_ID@ @IsTaxpayer@ @NotFound@");
            isValid = false;
        }
        Optional.ofNullable(this.invoice).ifPresent(invoice -> {
            this.setReturnValue("SourceInvoice_ID", invoice.getC_Invoice_ID());
            this.setReturnValue("AD_Org_ID", invoice.getAD_Org_ID());
            if (invoice.isSOTrx()) {
                this.isManual = true;
                Optional.ofNullable(MOrgInfo.get((Properties)this.getContext(), (int)invoice.getAD_Org_ID(), (String)invoice.get_TrxName())).ifPresent(orgInfo -> {
                    this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)orgInfo.get_ValueAsInt("WH_BPartner_ID"));
                });
            } else {
                this.isManual = false;
            }
        });
        if (this.businessPartner == null) {
            this.addLog("@C_BPartner_ID@ @NotFound@");
            isValid = false;
        } else {
            int withholdingRateId;
            MDocType documentType;
            this.setReturnValue("SourceInvoice_ID", this.invoice.getC_Invoice_ID());
            MLVEWithholdingTax currentWHTax = MLVEWithholdingTax.getFromClient(this.getContext(), this.getDocument().getAD_Org_ID(), "IV");
            if (currentWHTax == null) {
                this.addLog("@LVE_WithholdingTax_ID@ @NotFound@");
                isValid = false;
            }
            if (currentWHTax != null && currentWHTax.isClientExcluded()) {
                this.addLog("@IsClientExcluded@ " + currentWHTax.getName());
                isValid = false;
            }
            if (this.invoice.isReversal()) {
                this.addLog("@C_Invoice_ID@ @Voided@");
                isValid = false;
            }
            if ((documentType = MDocType.get((Properties)this.getContext(), (int)this.invoice.getC_DocTypeTarget_ID())) == null) {
                this.addLog("@C_DocType_ID@ @NotFound@");
                isValid = false;
            }
            if (!(documentType == null || documentType.getDocBaseType().equals("API") || documentType.getDocBaseType().equals("APC") || documentType.getDocBaseType().equals("ARI") || documentType.getDocBaseType().equals("ARC"))) {
                this.addLog("@APDocumentRequired@ / @ARDocumentRequired@");
                isValid = false;
            }
            if (this.invoice.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
                isValid = false;
                this.addLog("@DocumentWithholdingTaxExempt@");
            }
            if (this.businessPartner.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
                isValid = false;
                this.addLog("@BPartnerWithholdingTaxExempt@");
            }
            if ((withholdingRateId = this.businessPartner.get_ValueAsInt("WithholdingTaxRate_ID")) == 0 && currentWHTax != null) {
                withholdingRateId = currentWHTax.getDefaultWithholdingRate_ID();
            }
            if (withholdingRateId == 0) {
                this.addLog("@WithholdingTaxRate_ID@ @NotFound@");
                isValid = false;
            } else {
                this.withholdingRate = MLVEList.get(this.getContext(), withholdingRateId).getListVersionAmount(this.invoice.getDateInvoiced());
                this.setWithholdingRate(this.withholdingRate);
            }
            if (this.getWithholdingRate().equals(Env.ZERO)) {
                this.addLog("@LVE_WithholdingTax_ID@ (@Rate@ @NotFound@)");
                isValid = false;
            }
            BigDecimal tributeUnitAmount = Env.ZERO;
            if (currentWHTax != null) {
                tributeUnitAmount = currentWHTax.getValidTributeUnitAmount(this.invoice.getDateAcct());
            }
            if (tributeUnitAmount.equals(Env.ZERO)) {
                this.addLog("@TributeUnit@ (@Rate@ @NotFound@)");
                isValid = false;
            }
            this.taxes = Arrays.asList(this.invoice.getTaxes(false)).stream().filter(invoiceTax -> MTax.get((Properties)this.getContext(), (int)invoiceTax.getC_Tax_ID()).get_ValueAsBoolean("IsWithholdingTaxApplied") && invoiceTax.getTaxAmt() != null && invoiceTax.getTaxAmt().compareTo(Env.ZERO) > 0).collect(Collectors.toList());
            if (this.taxes.size() == 0) {
                this.addLog("@NoTaxesForWithholding@");
                isValid = false;
            }
            if (this.isGenerated()) {
                isValid = false;
            }
        }
        return isValid;
    }

    public String run() {
        this.taxes.forEach(invoiceTax -> {
            this.setWithholdingRate(this.withholdingRate);
            this.addBaseAmount(invoiceTax.getTaxAmt());
            this.addWithholdingAmount(invoiceTax.getTaxAmt().multiply(this.getWithholdingRate(true)));
            MTax tax = MTax.get((Properties)this.getContext(), (int)invoiceTax.getC_Tax_ID());
            this.addDescription(tax.getName() + " @Processed@");
            this.setReturnValue("IsManual", this.isManual);
            int WHThirdParty_ID = this.invoice.get_ValueAsInt("WHThirdParty_ID");
            if (WHThirdParty_ID != 0) {
                this.setReturnValue("WHThirdParty_ID", WHThirdParty_ID);
            }
            this.setReturnValue("C_Tax_ID", invoiceTax.getC_Tax_ID());
            this.saveResult();
        });
        this.removeReferencesFromPOS();
        return null;
    }

    private void removeReferencesFromPOS() {
        PO paymentReferenceToCreate;
        MTable paymentReferenceDefinition;
        if (this.invoice.isSOTrx() && this.invoice.getC_Order_ID() > 0 && (paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference")) != null && (paymentReferenceToCreate = new Query(this.getContext(), "C_POSPaymentReference", "C_Order_ID = ? AND TenderType = ?", this.getTransactionName()).setParameters(new Object[]{this.invoice.getC_Order_ID(), "M"}).first()) != null && paymentReferenceToCreate.get_ID() > 0) {
            paymentReferenceToCreate.set_ValueOfColumn("Processed", (Object)true);
            paymentReferenceToCreate.saveEx();
        }
    }

    private boolean isGenerated() {
        if (this.invoice != null) {
            return new Query(this.getContext(), "WH_Withholding", "SourceInvoice_ID = ? AND WH_Definition_ID = ? AND WH_Setting_ID = ? AND Processed = 'Y' AND IsSimulation='N' AND DocStatus IN (?,?)", this.getTransactionName()).setParameters(new Object[]{this.invoice.get_ID(), this.getDefinition().get_ID(), this.getSetting().get_ID(), "CO", "CL"}).match();
        }
        return false;
    }
}

