/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrgInfo;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public class APInvoiceIM
extends AbstractWithholdingSetting {
    private MInvoice invoice;
    private MBPartner businessPartner;
    private MLVEList activityToApply = null;
    private MLVEListVersion rateToApply = null;
    int curPrecision = 0;
    private boolean isManual = false;
    private BigDecimal baseAmount = Env.ZERO;

    public APInvoiceIM(MWHSetting setting) {
        super(setting);
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this.getDocument().get_Table_ID() != I_C_Invoice.Table_ID) {
            this.addLog("@C_Invoice_ID@ @NotFound@");
            isValid = false;
        }
        this.invoice = (MInvoice)this.getDocument();
        this.businessPartner = (MBPartner)this.invoice.getC_BPartner();
        Optional.ofNullable(this.invoice).ifPresent(invoice -> {
            this.setReturnValue("SourceInvoice_ID", invoice.getC_Invoice_ID());
            this.setReturnValue("AD_Org_ID", invoice.getAD_Org_ID());
            if (invoice.isSOTrx()) {
                this.isManual = true;
                Optional.ofNullable(MOrgInfo.get((Properties)this.getContext(), (int)invoice.getAD_Org_ID(), (String)invoice.get_TrxName())).ifPresent(orgInfo -> {
                    this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)orgInfo.get_ValueAsInt("WH_BPartner_ID"));
                });
            } else {
                this.isManual = false;
            }
        });
        if (this.businessPartner == null) {
            this.addLog("@C_BPartner_ID@ @NotFound@");
            isValid = false;
        } else {
            MDocType documentType;
            if (this.invoice != null) {
                MCurrency currency = (MCurrency)this.invoice.getC_Currency();
                this.curPrecision = currency.getStdPrecision();
                this.baseAmount = this.invoice.getTotalLines();
            }
            this.setReturnValue("SourceInvoice_ID", this.invoice.getC_Invoice_ID());
            MLVEWithholdingTax currentWHTax = MLVEWithholdingTax.getFromClient(this.getContext(), this.getDocument().getAD_Org_ID(), "IM");
            if (currentWHTax == null) {
                this.addLog("@LVE_WithholdingTax_ID@ @NotFound@");
                isValid = false;
            }
            if (currentWHTax != null && currentWHTax.isClientExcluded()) {
                this.addLog("@IsClientExcluded@ " + currentWHTax.getName());
                isValid = false;
            }
            if (this.invoice.isReversal()) {
                this.addLog("@C_Invoice_ID@ @Voided@");
                isValid = false;
            }
            if ((documentType = MDocType.get((Properties)this.getContext(), (int)this.invoice.getC_DocTypeTarget_ID())) == null) {
                this.addLog("@C_DocType_ID@ @NotFound@");
                isValid = false;
            }
            if (!(documentType == null || documentType.getDocBaseType().equals("API") || documentType.getDocBaseType().equals("APC") || documentType.getDocBaseType().equals("ARI") || documentType.getDocBaseType().equals("ARC"))) {
                this.addLog("@APDocumentRequired@ / @ARDocumentRequired@");
                isValid = false;
            }
            if (this.businessPartner.get_ValueAsBoolean("IsWithholdingMunicipalExempt")) {
                isValid = false;
                this.addLog("@C_BPartner_ID@ @IsWithholdingMunicipalExempt@");
            }
            this.setActivity();
            if (this.activityToApply == null) {
                isValid = false;
                this.addLog("@NotFound@ @BusinessActivity_ID@");
            }
            this.setRate();
            if (this.rateToApply == null) {
                isValid = false;
                this.addLog("@NotFound@ @WithholdingMunicipalRate_ID@");
            }
            if (this.isGenerated()) {
                isValid = false;
            }
        }
        return isValid;
    }

    public String run() {
        if (this.activityToApply != null && this.rateToApply != null) {
            BigDecimal rate = this.rateToApply.getAmount();
            if (rate == null) {
                rate = Env.ZERO;
            }
            if (rate.compareTo(Env.ZERO) != 0) {
                this.setWithholdingRate(rate);
                rate = this.getWithholdingRate(true);
                this.addBaseAmount(this.baseAmount);
                this.addWithholdingAmount(this.baseAmount.multiply(rate, MathContext.DECIMAL128).setScale(this.curPrecision, 4));
                this.addDescription(this.activityToApply.getName());
                this.setReturnValue("IsManual", this.isManual);
                int WHThirdParty_ID = this.invoice.get_ValueAsInt("WHThirdParty_ID");
                if (WHThirdParty_ID != 0) {
                    this.setReturnValue("WHThirdParty_ID", WHThirdParty_ID);
                }
                this.saveResult();
            }
        }
        this.activityToApply = null;
        this.rateToApply = null;
        this.curPrecision = 0;
        this.baseAmount = null;
        return null;
    }

    private void setActivity() {
        if (this.businessPartner != null && this.businessPartner.get_ValueAsInt("BusinessActivity_ID") != 0) {
            this.activityToApply = new MLVEList(this.getContext(), this.businessPartner.get_ValueAsInt("BusinessActivity_ID"), this.businessPartner.get_TrxName());
        }
    }

    private void setRate() {
        if (this.businessPartner != null && this.businessPartner.get_ValueAsInt("WithholdingMunicipalRate_ID") != 0) {
            this.rateToApply = new MLVEListVersion(this.getContext(), this.businessPartner.get_ValueAsInt("WithholdingMunicipalRate_ID"), this.businessPartner.get_TrxName());
        }
    }

    private boolean isGenerated() {
        if (this.invoice != null) {
            return new Query(this.getContext(), "WH_Withholding", "SourceInvoice_ID = ? AND WH_Definition_ID = ? AND WH_Setting_ID = ? AND Processed = 'Y' AND IsSimulation='N' AND DocStatus IN (?,?)", this.getTransactionName()).setParameters(new Object[]{this.invoice.get_ID(), this.getDefinition().get_ID(), this.getSetting().get_ID(), "CO", "CL"}).match();
        }
        return false;
    }
}

