/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.setup;

import java.util.Properties;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MPOS;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.erpya.lve.util.APInvoiceIVA;
import org.erpya.lve.util.POSOrderIVAChange;
import org.erpya.lve.util.POSOrderIVANew;
import org.erpya.lve.util.POSOrderIVAProcess;
import org.erpya.lve.util.POSWihholdingIVAProcess;
import org.spin.model.MWHSetting;
import org.spin.model.MWHType;
import org.spin.util.ISetupDefinition;

public class WithholdingPOSIVASetup
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private Properties context = null;
    private String transactionName = null;

    private Properties getCtx() {
        return this.context;
    }

    private String getTrx_Name() {
        return this.transactionName;
    }

    public String doIt(Properties context, String transactionName) {
        this.context = context;
        this.transactionName = transactionName;
        this.setupWithholding();
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void setupWithholding() {
        String whereClause = "EXISTS (SELECT 1 FROM WH_Setting s WHERE WH_Type.WH_Type_ID = s.WH_Type_ID AND ".concat("WithholdingClassName").concat(" = ?)");
        MWHType withHolgingType = (MWHType)new Query(this.getCtx(), "WH_Type", whereClause, this.getTrx_Name()).setParameters(new Object[]{APInvoiceIVA.class.getName()}).setClient_ID().first();
        if (withHolgingType == null || withHolgingType.getWH_Type_ID() <= 0) {
            return;
        }
        int maxSequence = DB.getSQLValue((String)this.getTrx_Name(), (String)"SELECT MAX(SeqNo) FROM WH_Setting WHERE WH_Type_ID = ?", (int)withHolgingType.getWH_Type_ID());
        maxSequence = maxSequence < 0 ? 10 : (maxSequence += 10);
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIVANew.class.getName(), "TAN", I_C_OrderLine.Table_ID, "IVA-Linea-Orden-Crear", "Retenci\u00f3n I.V.A Despu\u00e9s de Crear Linea de Orden", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIVAChange.class.getName(), "TAC", I_C_OrderLine.Table_ID, "IVA-Linea-Orden-Modificar", "Retenci\u00f3n I.V.A Despu\u00e9s de Modificar Linea de Orden", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIVAChange.class.getName(), "TAD", I_C_OrderLine.Table_ID, "IVA-Linea-Orden-Eliminar", "Retenci\u00f3n I.V.A Despu\u00e9s de Eliminar Linea de Orden", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIVANew.class.getName(), "TAN", I_C_Order.Table_ID, "IVA-Orden-Crear", "Retenci\u00f3n I.V.A Antes de Crear Orden de Venta", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIVAChange.class.getName(), "TAC", I_C_Order.Table_ID, "IVA-Orden-Modificar", "Retenci\u00f3n I.V.A Antes de odificar Orden de Venta", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSOrderIVAProcess.class.getName(), "DACO", I_C_Order.Table_ID, "IVA-Orden-Procesar", "Retenci\u00f3n I.V.A Despu\u00e9s de Procesar Orden de Venta", maxSequence)) {
            maxSequence += 10;
        }
        if (this.createSettingWithEvent(withHolgingType.getWH_Type_ID(), POSWihholdingIVAProcess.class.getName(), "DBCO", I_C_Invoice.Table_ID, "IVA-Comprobante-Procesar", "Retenci\u00f3n I.V.A Antes de Procesar Comprobante de Retenci\u00f3n", maxSequence)) {
            maxSequence += 10;
        }
        this.createPaymentMethod(withHolgingType.getWH_Type_ID());
    }

    private void createPaymentMethod(int withholdingTypeId) {
        PO payPaymentMethod;
        PO paymentMethod = new Query(this.getCtx(), "C_PaymentMethod", "TenderType = 'M' AND Value = ?", this.getTrx_Name()).setParameters(new Object[]{"Retencion-IVA"}).first();
        if (paymentMethod == null || paymentMethod.get_ID() <= 0) {
            paymentMethod = MTable.get((Properties)this.context, (String)"C_PaymentMethod").getPO(0, this.getTrx_Name());
            paymentMethod.setAD_Org_ID(0);
            paymentMethod.set_ValueOfColumn("TenderType", (Object)"M");
            paymentMethod.set_ValueOfColumn("Value", (Object)"Retencion-IVA");
            paymentMethod.set_ValueOfColumn("Name", (Object)"Retencion de I.V.A.");
            paymentMethod.set_ValueOfColumn("Description", (Object)"I.V.A. sobre");
            paymentMethod.set_ValueOfColumn("WH_Type_ID", (Object)withholdingTypeId);
            paymentMethod.saveEx();
        }
        if ((payPaymentMethod = new Query(this.getCtx(), "C_PaymentMethod", "TenderType = 'M' AND Value = ?", this.getTrx_Name()).setParameters(new Object[]{"Pago-IVA"}).first()) == null || payPaymentMethod.get_ID() <= 0) {
            payPaymentMethod = MTable.get((Properties)this.context, (String)"C_PaymentMethod").getPO(0, this.getTrx_Name());
            payPaymentMethod.setAD_Org_ID(0);
            payPaymentMethod.set_ValueOfColumn("TenderType", (Object)"M");
            payPaymentMethod.set_ValueOfColumn("Value", (Object)"Pago-IVA");
            payPaymentMethod.set_ValueOfColumn("Name", (Object)"Pago de I.V.A.");
            payPaymentMethod.set_ValueOfColumn("Description", (Object)"Pago de I.V.A.");
            payPaymentMethod.set_ValueOfColumn("WH_Type_ID", (Object)withholdingTypeId);
            payPaymentMethod.set_ValueOfColumn("IsWithholdingExempt", (Object)true);
            payPaymentMethod.saveEx();
        }
        if (MTable.getTable_ID((String)"C_POSPaymentTypeAllocation") <= 0) {
            return;
        }
        int paymentMethodId = paymentMethod.get_ID();
        int payPaymentMethodId = payPaymentMethod.get_ID();
        new Query(this.getCtx(), "C_POS", null, this.getTrx_Name()).setOnlyActiveRecords(true).setClient_ID().getIDsAsList().forEach(posId -> {
            PO allocatedPayPaymentMethod;
            MPOS pos = MPOS.get((Properties)this.getCtx(), (int)posId);
            PO allocatedPaymentMethod = new Query(this.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ?", this.getTrx_Name()).setParameters(new Object[]{posId, paymentMethodId}).first();
            if (allocatedPaymentMethod == null || allocatedPaymentMethod.get_ID() <= 0) {
                allocatedPaymentMethod = MTable.get((Properties)this.getCtx(), (String)"C_POSPaymentTypeAllocation").getPO(0, this.getTrx_Name());
                allocatedPaymentMethod.setAD_Org_ID(pos.getAD_Org_ID());
                allocatedPaymentMethod.set_ValueOfColumn("C_POS_ID", posId);
                allocatedPaymentMethod.set_ValueOfColumn("C_PaymentMethod_ID", (Object)paymentMethodId);
                allocatedPaymentMethod.set_ValueOfColumn("IsPaymentReference", (Object)true);
                allocatedPaymentMethod.set_ValueOfColumn("IsDisplayedFromCollection", (Object)false);
                allocatedPaymentMethod.set_ValueOfColumn("SeqNo", (Object)999);
                allocatedPaymentMethod.saveEx();
            }
            if ((allocatedPayPaymentMethod = new Query(this.getCtx(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND C_PaymentMethod_ID = ?", this.getTrx_Name()).setParameters(new Object[]{posId, payPaymentMethodId}).first()) == null || allocatedPayPaymentMethod.get_ID() <= 0) {
                allocatedPayPaymentMethod = MTable.get((Properties)this.getCtx(), (String)"C_POSPaymentTypeAllocation").getPO(0, this.getTrx_Name());
                allocatedPayPaymentMethod.setAD_Org_ID(pos.getAD_Org_ID());
                allocatedPayPaymentMethod.set_ValueOfColumn("C_POS_ID", posId);
                allocatedPayPaymentMethod.set_ValueOfColumn("Name", (Object)"Comprobante de I.V.A.");
                allocatedPayPaymentMethod.set_ValueOfColumn("C_PaymentMethod_ID", (Object)payPaymentMethodId);
                allocatedPayPaymentMethod.set_ValueOfColumn("IsPaymentReference", (Object)false);
                allocatedPayPaymentMethod.set_ValueOfColumn("IsDisplayedFromCollection", (Object)true);
                allocatedPayPaymentMethod.set_ValueOfColumn("SeqNo", (Object)999);
                allocatedPayPaymentMethod.saveEx();
            }
        });
    }

    private boolean createSettingWithEvent(int withholdingTypeId, String className, String eventType, int tableId, String value, String name, int sequence) {
        MWHSetting setting = (MWHSetting)new Query(this.getCtx(), "WH_Setting", "EventType = 'E' AND WH_Type_ID = ? AND EventModelValidator = ? AND WithholdingClassName = ? AND AD_Table_ID = ?", this.getTrx_Name()).setParameters(new Object[]{withholdingTypeId, eventType, className, tableId}).first();
        if (setting != null) {
            return false;
        }
        setting = new MWHSetting(this.getCtx(), 0, this.getTrx_Name());
        setting.setWH_Type_ID(withholdingTypeId);
        setting.setValue(value);
        setting.setName(name);
        setting.setSeqNo(sequence);
        setting.setEventType("E");
        setting.setAD_Table_ID(tableId);
        setting.setEventModelValidator(eventType);
        setting.setDescription(DESCRIPTION);
        setting.setWithholdingClassName(className);
        setting.setUUID(UUID);
        setting.setIsDirectLoad(true);
        setting.saveEx();
        return true;
    }
}

