/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Iterator;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.model.MSequence;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.process.ProcessPaymentForFBTTAbstract;

public class ProcessPaymentForFBTT
extends ProcessPaymentForFBTTAbstract {
    private int lines = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() {
        int listId = 0;
        int bankAccountId = 0;
        BigDecimal sourcePayAmt = Env.ZERO;
        MPayment fbttPayment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        int defaultCurrencyId = MClient.get((Properties)this.getCtx()).getC_Currency_ID();
        Iterator iterator = this.getSelectionKeys().iterator();
        while (iterator.hasNext()) {
            MBank bank;
            MBPartner bPartner;
            MPayment fbttRefPayment;
            int key = (Integer)iterator.next();
            MPayment sourcePayment = new MPayment(this.getCtx(), key, this.get_TrxName());
            if (sourcePayment.get_ValueAsInt("FBTT_Payment_ID") != 0 && ((fbttRefPayment = new MPayment(sourcePayment.getCtx(), sourcePayment.get_ValueAsInt("FBTT_Payment_ID"), sourcePayment.get_TrxName())).getDocStatus().equals("CO") || fbttRefPayment.getDocStatus().equals("CL")) || sourcePayment.isReceipt() || (bPartner = MBPartner.get((Properties)this.getCtx(), (int)sourcePayment.getC_BPartner_ID())).get_ValueAsBoolean("IsFBTTTaxExempt")) continue;
            bankAccountId = sourcePayment.getC_BankAccount_ID();
            MBankAccount bankAccount = MBankAccount.get((Properties)this.getCtx(), (int)bankAccountId);
            if (bankAccount.getC_Currency_ID() != defaultCurrencyId || (listId = (bank = MBank.get((Properties)this.getCtx(), (int)bankAccount.getC_Bank_ID())).get_ValueAsInt("LVE_List_ID")) == 0) continue;
            sourcePayAmt = sourcePayAmt.add(sourcePayment.getPayAmt());
            if (this.lines == 0) {
                MDocType docType;
                int chargeId;
                PO.copyValues((PO)sourcePayment, (PO)fbttPayment);
                fbttPayment.setIsPrepayment(false);
                fbttPayment.setC_Order_ID(0);
                fbttPayment.setC_Invoice_ID(0);
                fbttPayment.setIsOverUnderPayment(false);
                fbttPayment.setIsOnline(false);
                fbttPayment.setIsReconciled(false);
                fbttPayment.setPayAmt(Env.ZERO);
                fbttPayment.setC_Currency_ID(defaultCurrencyId);
                fbttPayment.setOverUnderAmt(Env.ZERO);
                fbttPayment.setWriteOffAmt(Env.ZERO);
                fbttPayment.setTaxAmt(Env.ZERO);
                fbttPayment.setChargeAmt(Env.ZERO);
                fbttPayment.setProcessed(false);
                fbttPayment.setDateTrx(this.getDateTrx());
                fbttPayment.setDateAcct(this.getDateTrx());
                fbttPayment.setDocStatus("DR");
                fbttPayment.setCheckNo(null);
                fbttPayment.setRoutingNo(null);
                fbttPayment.setAccountNo(null);
                fbttPayment.setMicr(null);
                fbttPayment.setA_Name(null);
                fbttPayment.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@ @from@ @FBTT@"));
                MClientInfo clientInfo = MClientInfo.get((Properties)this.getCtx());
                if (this.getBPartnerId() == 0) {
                    this.setBPartnerId(clientInfo.get_ValueAsInt("FBTT_BPartner_ID"));
                }
                if (this.getBPartnerId() != 0) {
                    fbttPayment.setC_BPartner_ID(this.getBPartnerId());
                }
                if ((chargeId = clientInfo.get_ValueAsInt("FBTT_Charge_ID")) == 0) {
                    return "@FBTT_Charge_ID@ @NotFound@";
                }
                String sequence = null;
                if (this.getDocTypeTargetId() != 0 && (docType = MDocType.get((Properties)this.getCtx(), (int)this.getDocTypeTargetId())).getDocBaseType().equals("APP")) {
                    fbttPayment.setC_DocType_ID(this.getDocTypeTargetId());
                    sequence = MSequence.getDocumentNo((int)this.getDocTypeTargetId(), (String)this.get_TrxName(), (boolean)true);
                }
                if (sequence == null) {
                    sequence = Msg.parseTranslation((Properties)this.getCtx(), (String)"@FBTT@_") + DisplayType.getDateFormat((int)15).format(this.getDateTrx());
                }
                fbttPayment.setDocumentNo(sequence);
                fbttPayment.setC_Charge_ID(chargeId);
                fbttPayment.saveEx();
            }
            sourcePayment.set_ValueOfColumn("FBTT_Payment_ID", (Object)fbttPayment.getC_Payment_ID());
            sourcePayment.saveEx();
            ++this.lines;
        }
        if (this.lines > 0) {
            MLVEList list = MLVEList.get(Env.getCtx(), listId);
            BigDecimal rateToApply = list.getList(fbttPayment.getDateTrx(), sourcePayAmt, "Col_1");
            if (rateToApply == null || rateToApply.equals(Env.ZERO)) {
                return "OK";
            }
            rateToApply = rateToApply.divide(Env.ONEHUNDRED, MathContext.DECIMAL128);
            BigDecimal payAmt = rateToApply.multiply(sourcePayAmt);
            fbttPayment.setPayAmt(payAmt);
            fbttPayment.saveEx();
            fbttPayment.setDocAction(this.getDocAction());
            fbttPayment.processIt(this.getDocAction());
            fbttPayment.saveEx();
            if (fbttPayment.getDocStatus() != "CO") {
                return fbttPayment.getProcessMsg();
            }
            return "@Created@: " + fbttPayment.getDocumentInfo();
        }
        return "OK";
    }
}

