/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.erpya.lve.model.MLVEAutoDebitNoteSetting;
import org.erpya.lve.process.GenerateDebitsByCurrencyRateAbstract;

public class GenerateDebitsByCurrencyRate
extends GenerateDebitsByCurrencyRateAbstract {
    private static final String COLUMNNAME_DebitAmt = "IWOP_InvoiceAmt";
    Optional<MLVEAutoDebitNoteSetting> maybeSettings = Optional.empty();

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.getSelectionValues().entrySet().forEach(row -> {
            MInvoice invoice = MInvoice.get((Properties)this.getCtx(), (int)((Integer)row.getKey()));
            this.maybeSettings = Optional.ofNullable(MLVEAutoDebitNoteSetting.get(this.getCtx(), invoice.getC_DocTypeTarget_ID()));
            this.maybeSettings.orElseGet(() -> {
                throw new AdempiereException("@NotFound@ @LVE_AutoDebitNoteSetting_ID@");
            });
            BigDecimal debitAmt = (BigDecimal)((LinkedHashMap)row.getValue()).get(COLUMNNAME_DebitAmt);
            Optional<MInvoice> maybeDebitNote = Optional.ofNullable(this.createDebitNoteFromInvoice(invoice, debitAmt));
            maybeDebitNote.ifPresent(debitNote -> {
                Optional<MAllocationHdr> maybeAllocation = Optional.ofNullable(this.allocatedDebitNote((MInvoice)debitNote));
                maybeAllocation.ifPresent(allocation -> {
                    this.addLog("@Created@ @C_Invoice_ID@ " + debitNote.getDocumentNo());
                    this.addLog("@Created@ @C_AllocationHdr_ID@ " + allocation.getDocumentNo());
                });
            });
        });
        return "";
    }

    private MInvoice createDebitNoteFromInvoice(MInvoice invoiceFrom, BigDecimal debitAmt) {
        AtomicReference<Object> documentReturn = new AtomicReference<Object>(null);
        this.maybeSettings.orElseGet(() -> {
            throw new AdempiereException("@NotFound@ @LVE_AutoDebitNoteSetting_ID@");
        });
        this.maybeSettings.ifPresent(settings -> {
            MOrgInfo orgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)invoiceFrom.getAD_Org_ID(), (String)this.get_TrxName());
            MCurrency fiscalCurrency = MCurrency.get((Properties)this.getCtx(), (int)orgInfo.get_ValueAsInt("LVE_FiscalCurrency_ID"));
            MInvoice debitNote = new MInvoice(this.getCtx(), 0, this.get_TrxName());
            MInvoice.copyValues((PO)invoiceFrom, (PO)debitNote);
            Optional<MPriceList> maybePriceList = Optional.ofNullable(MPriceList.get((Properties)this.getCtx(), (int)settings.getM_PriceList_ID(), (String)this.get_TrxName()));
            maybePriceList.orElseGet(() -> {
                throw new AdempiereException("@NotFound@ @IsDefault@ @M_PriceList_ID@");
            });
            maybePriceList.ifPresent(priceList -> {
                debitNote.setM_PriceList_ID(priceList.get_ID());
                debitNote.setC_Currency_ID(priceList.getC_Currency_ID());
            });
            debitNote.setDocumentNo(invoiceFrom.isSOTrx() ? null : this.getDocumentNo());
            debitNote.set_ValueOfColumn("ControlNo", (Object)(invoiceFrom.isSOTrx() ? null : this.getControlNo()));
            debitNote.setDocStatus("DR");
            debitNote.setProcessed(false);
            debitNote.setPosted(false);
            debitNote.setDateAcct(this.getDateAcct());
            debitNote.setDateInvoiced(this.getDateInvoiced());
            debitNote.setC_ConversionType_ID(this.getConversionTypeId());
            debitNote.setC_DocTypeTarget_ID(settings.getLVE_DebitNoteDocType_ID());
            debitNote.setC_DocType_ID(settings.getLVE_DebitNoteDocType_ID());
            debitNote.set_ValueOfColumn("LVE_AutoDebitInvoice_ID", (Object)invoiceFrom.get_ID());
            debitNote.set_ValueOfColumn("InvoiceToAllocate_ID", (Object)invoiceFrom.get_ID());
            debitNote.saveEx();
            boolean detailDebitNote = settings.isLVE_IsCopyLinesFromInvoice();
            int debitChargeId = settings.getLVE_DebitNoteCharge_ID();
            BinaryOperator sumValue = (previous, currentValue) -> previous.add((BigDecimal)currentValue);
            AtomicReference<BigDecimal> amt = new AtomicReference<BigDecimal>(debitAmt);
            if (detailDebitNote) {
                debitNote.copyLinesFrom(invoiceFrom, false, false);
                AtomicReference<BigDecimal> lineAmt = new AtomicReference<BigDecimal>(Env.ZERO);
                BigDecimal totalLines = new BigDecimal(debitNote.getLines().length);
                AtomicReference<BigDecimal> currentLine = new AtomicReference<BigDecimal>(Env.ZERO);
                Arrays.asList(debitNote.getLines()).stream().forEach(debitNoteLine -> {
                    currentLine.accumulateAndGet(Env.ONE, sumValue);
                    BigDecimal lineRate = debitNoteLine.getLineNetAmt().divide(debitNote.getTotalLines(), MathContext.DECIMAL128);
                    lineAmt.set(debitAmt.multiply(lineRate).setScale(fiscalCurrency.getStdPrecision(), RoundingMode.HALF_UP));
                    debitNoteLine.setPrice((BigDecimal)lineAmt.get());
                    amt.accumulateAndGet(((BigDecimal)lineAmt.get()).negate(), sumValue);
                    if (((BigDecimal)currentLine.get()).compareTo(totalLines) == 0 && ((BigDecimal)amt.get()).abs().compareTo(Env.ZERO) != 0) {
                        debitNoteLine.setPrice(((BigDecimal)lineAmt.get()).add((BigDecimal)amt.get()));
                    }
                    debitNoteLine.setQty(Env.ONE);
                    debitNoteLine.saveEx();
                });
            } else {
                MInvoiceLine invoiceLine = new MInvoiceLine(debitNote);
                invoiceLine.setC_Charge_ID(debitChargeId);
                invoiceLine.setQty(BigDecimal.ONE);
                invoiceLine.setPrice(amt.get());
                invoiceLine.saveEx();
            }
            debitNote.processIt("CO");
            debitNote.saveEx();
            documentReturn.set(debitNote);
        });
        return documentReturn.get();
    }

    private MAllocationHdr allocatedDebitNote(MInvoice debitNote) {
        AtomicReference<Object> allocationResult = new AtomicReference<Object>(null);
        this.maybeSettings.ifPresent(settings -> {
            MAllocationHdr allocationHdr = new MAllocationHdr(this.getCtx(), false, debitNote.getDateAcct(), debitNote.getC_Currency_ID(), Msg.translate((Properties)this.getCtx(), (String)"C_Invoice_ID") + ": " + debitNote.getDocumentNo(), this.get_TrxName());
            allocationHdr.setAD_Org_ID(debitNote.getAD_Org_ID());
            allocationHdr.setDateAcct(debitNote.getDateAcct());
            allocationHdr.saveEx(this.get_TrxName());
            MAllocationLine allocationLine = new MAllocationLine(allocationHdr, debitNote.getTotalLines(), Env.ZERO, Env.ZERO, Env.ZERO);
            allocationLine.setDocInfo(debitNote.getC_BPartner_ID(), 0, 0);
            allocationLine.setC_Invoice_ID(debitNote.get_ID());
            allocationLine.saveEx(this.get_TrxName());
            allocationLine = new MAllocationLine(allocationHdr, debitNote.getTotalLines(), Env.ZERO, Env.ZERO, Env.ZERO);
            allocationLine.setDocInfo(debitNote.getC_BPartner_ID(), 0, 0);
            allocationLine.setC_Charge_ID(settings.getLVE_AllocationCharge_ID());
            allocationLine.saveEx(this.get_TrxName());
            if (!allocationHdr.processIt("CO")) {
                throw new AdempiereException(allocationHdr.getProcessMsg());
            }
            allocationHdr.saveEx(this.get_TrxName());
            allocationResult.set(allocationHdr);
        });
        return allocationResult.get();
    }
}

