/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.erpya.lve.model.MLVEList;

public class TaxDiscount
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(TaxDiscount.class);
    private int clientId = -1;
    boolean notProcessed = true;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 7) {
            MInvoice invoice;
            if (po.get_TableName().equals("C_Order")) {
                MOrder order = (MOrder)po;
                this.recalculateTaxForOrder(order);
            } else if (po.get_TableName().equals("C_Invoice") && po.get_ValueAsBoolean("IsSOTrx") && (invoice = (MInvoice)po).getReversal_ID() == 0) {
                this.setListId(invoice);
                int invoiceToAllocateId = invoice.get_ValueAsInt("InvoiceToAllocate_ID");
                if (invoiceToAllocateId <= 0) {
                    MInvoiceLine line;
                    MInvoiceLine[] mInvoiceLineArray = invoice.getLines();
                    int n = mInvoiceLineArray.length;
                    for (int i = 0; i < n && (invoiceToAllocateId = (line = mInvoiceLineArray[i]).get_ValueAsInt("InvoiceToAllocate_ID")) <= 0; ++i) {
                    }
                }
                if (invoiceToAllocateId <= 0) {
                    this.recalculateTaxForInvoice(invoice);
                } else {
                    this.copyTaxFromAffected(invoice, invoiceToAllocateId);
                }
            }
        }
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    private void recalculateTaxForOrder(MOrder order) {
        MOrderLine[] lines;
        int listId = order.get_ValueAsInt("LVE_List_ID");
        if (listId <= 0) {
            return;
        }
        MLVEList list = MLVEList.get(Env.getCtx(), listId);
        if (list == null) {
            return;
        }
        boolean applySpecialTax = false;
        MOrderTax[] orderTaxes = order.getTaxes(true);
        BigDecimal baseAmount = Env.ZERO;
        for (MOrderTax orderTax : orderTaxes) {
            MTax tax;
            if (orderTax.getTaxAmt() == null || orderTax.getTaxAmt().equals(Env.ZERO) || !this.isHasSpecialTax(tax = MTax.get((Properties)Env.getCtx(), (int)orderTax.getC_Tax_ID()))) continue;
            baseAmount = baseAmount.add(orderTax.getTaxBaseAmt());
            if (applySpecialTax) continue;
            applySpecialTax = true;
        }
        if (!applySpecialTax) {
            return;
        }
        BigDecimal taxToApply = list.getList(order.getDateOrdered(), baseAmount, "Col_1");
        for (MOrderLine line : lines = order.getLines(true, null)) {
            MTax tax = MTax.get((Properties)Env.getCtx(), (int)line.getC_Tax_ID());
            if (tax.getRate() == null || tax.getRate().doubleValue() <= 0.0) continue;
            int taxId = 0;
            if (taxToApply != null && taxToApply.doubleValue() > 0.0) {
                taxId = this.getDiscountTaxId(order.get_TrxName(), tax.getC_TaxCategory_ID(), order.getDateOrdered(), taxToApply);
            }
            if (taxId > 0) {
                line.setC_Tax_ID(taxId);
            } else {
                line.setTax();
            }
            line.saveEx();
        }
    }

    private void recalculateTaxForInvoice(MInvoice invoice) {
        MInvoiceLine[] lines;
        int listId = invoice.get_ValueAsInt("LVE_List_ID");
        if (listId <= 0) {
            return;
        }
        MLVEList list = MLVEList.get(Env.getCtx(), listId);
        if (list == null) {
            return;
        }
        boolean applySpecialTax = false;
        MInvoiceTax[] taxes = invoice.getTaxes(true);
        BigDecimal baseAmount = Env.ZERO;
        for (MInvoiceTax invoiceTax : taxes) {
            MTax tax;
            if (invoiceTax.getTaxAmt() == null || invoiceTax.getTaxAmt().equals(Env.ZERO) || !this.isHasSpecialTax(tax = MTax.get((Properties)Env.getCtx(), (int)invoiceTax.getC_Tax_ID()))) continue;
            baseAmount = baseAmount.add(invoiceTax.getTaxBaseAmt());
            if (applySpecialTax) continue;
            applySpecialTax = true;
        }
        if (!applySpecialTax) {
            return;
        }
        BigDecimal taxToApply = list.getList(invoice.getDateInvoiced(), baseAmount, "Col_1");
        for (MInvoiceLine line : lines = invoice.getLines(true)) {
            line.setInvoice(invoice);
            MTax tax = MTax.get((Properties)Env.getCtx(), (int)line.getC_Tax_ID());
            if (tax.getRate() == null || tax.getRate().doubleValue() <= 0.0) continue;
            int taxId = 0;
            if (taxToApply != null && taxToApply.doubleValue() > 0.0) {
                taxId = this.getDiscountTaxId(invoice.get_TrxName(), tax.getC_TaxCategory_ID(), invoice.getDateInvoiced(), taxToApply);
            }
            if (taxId > 0) {
                line.setC_Tax_ID(taxId);
            } else {
                line.setTax();
            }
            line.setTaxAmt();
            line.saveEx();
        }
    }

    private void copyTaxFromAffected(MInvoice invoice, int docAffectedId) {
        MInvoiceLine[] lines;
        MInvoice affected = MInvoice.get((Properties)Env.getCtx(), (int)docAffectedId);
        MInvoiceTax[] taxes = affected.getTaxes(true);
        ArrayList<MTax> sourceTaxList = new ArrayList<MTax>();
        for (MInvoiceTax invoiceTax : taxes) {
            if (invoiceTax.getTaxAmt() == null || invoiceTax.getTaxAmt().equals(Env.ZERO)) continue;
            sourceTaxList.add((MTax)invoiceTax.getC_Tax());
        }
        for (MInvoiceLine line : lines = invoice.getLines(true)) {
            line.setInvoice(invoice);
            MTax tax = MTax.get((Properties)Env.getCtx(), (int)line.getC_Tax_ID());
            if (tax.getRate() == null || tax.getRate().doubleValue() <= 0.0) continue;
            int taxId = 0;
            for (MTax sourceTax : sourceTaxList) {
                if (tax.getC_TaxCategory_ID() != sourceTax.getC_TaxCategory_ID()) continue;
                taxId = sourceTax.getC_Tax_ID();
                break;
            }
            if (taxId == 0 && sourceTaxList.size() > 0) {
                taxId = ((MTax)sourceTaxList.get(0)).getC_Tax_ID();
            }
            if (taxId > 0) {
                line.setC_Tax_ID(taxId);
            } else {
                line.setTax();
            }
            line.setTaxAmt();
            line.saveEx();
        }
    }

    private void setListId(MInvoice invoice) {
        MInvoice docAffected;
        int docAffectedId;
        MOrder order;
        if (invoice.get_ValueAsInt("LVE_List_ID") <= 0 && invoice.getC_Order_ID() != 0 && (order = (MOrder)invoice.getC_Order()) != null && order.get_ValueAsInt("LVE_List_ID") > 0) {
            invoice.set_ValueOfColumn("LVE_List_ID", (Object)order.get_ValueAsInt("LVE_List_ID"));
            invoice.saveEx();
        }
        if ((docAffectedId = invoice.get_ValueAsInt("DocAffected_ID")) <= 0) {
            MInvoiceLine line;
            MInvoiceLine[] lines;
            MInvoiceLine[] mInvoiceLineArray = lines = invoice.getLines(true);
            int n = mInvoiceLineArray.length;
            for (int i = 0; i < n && (docAffectedId = (line = mInvoiceLineArray[i]).get_ValueAsInt("DocAffected_ID")) <= 0; ++i) {
            }
        }
        if (docAffectedId > 0 && (docAffected = MInvoice.get((Properties)Env.getCtx(), (int)docAffectedId)) != null && docAffected.get_ValueAsInt("LVE_List_ID") > 0) {
            invoice.set_ValueOfColumn("LVE_List_ID", (Object)docAffected.get_ValueAsInt("LVE_List_ID"));
            invoice.saveEx();
        }
    }

    private int getDiscountTaxId(String trxName, int taxCategoryId, Timestamp dateDoc, BigDecimal taxToApply) {
        MTax[] allTaxes = MTax.getAll((Properties)Env.getCtx());
        int discountTaxId = 0;
        for (MTax tax : allTaxes) {
            if (tax.getC_TaxCategory_ID() != taxCategoryId || !tax.isActive() || !TimeUtil.isValid((Timestamp)tax.getValidFrom(), null, (Timestamp)dateDoc) || !tax.getRate().setScale(2, 4).equals(taxToApply.setScale(2, 4))) continue;
            discountTaxId = tax.getC_Tax_ID();
            break;
        }
        return discountTaxId;
    }

    private boolean isHasSpecialTax(MTax tax) {
        MTaxCategory taxCategory = (MTaxCategory)tax.getC_TaxCategory();
        return taxCategory.get_ValueAsBoolean("IsHasSpecialTax");
    }
}

