/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.util.Arrays;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.erpya.lve.util.OrganizationRulesUtil;

public class OrganizationRules
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(OrganizationRules.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("C_InvoiceLine")) {
                if (entity.is_new() || entity.is_ValueChanged("C_OrderLine_ID")) {
                    MInvoiceLine invoiceLine2 = (MInvoiceLine)entity;
                    MInvoice invoice = (MInvoice)invoiceLine2.getC_Invoice();
                    MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
                    int invoiceCurrencyId = MOrgInfo.get((Properties)entity.getCtx(), (int)entity.getAD_Org_ID(), (String)entity.get_TrxName()).get_ValueAsInt("LVE_InvoiceCurrency_ID");
                    if (!invoice.isReversal() && documentType.get_ValueAsBoolean("IsInvoicedWithOrgCurrency") && invoiceCurrencyId > 0) {
                        OrganizationRulesUtil.recalculateInvoiceLineRate(invoice, invoiceLine2);
                    }
                }
            } else if (entity.get_TableName().equals("C_Invoice") && (entity.is_new() || entity.is_ValueChanged("M_PriceList_ID"))) {
                MInvoice invoice = (MInvoice)entity;
                MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
                int invoiceCurrencyId = MOrgInfo.get((Properties)entity.getCtx(), (int)entity.getAD_Org_ID(), (String)entity.get_TrxName()).get_ValueAsInt("LVE_InvoiceCurrency_ID");
                if (!invoice.isReversal() && invoice.getM_PriceList_ID() > 0 && documentType.get_ValueAsBoolean("IsInvoicedWithOrgCurrency") && invoiceCurrencyId > 0) {
                    MCurrency newCurrency = MCurrency.get((Properties)invoice.getCtx(), (int)invoiceCurrencyId);
                    MPriceList newPriceList = MPriceList.getDefault((Properties)invoice.getCtx(), (boolean)invoice.isSOTrx(), (String)newCurrency.getISO_Code());
                    if (newPriceList == null) {
                        throw new AdempiereException("@M_PriceList_ID@ @IsMandatory@ @C_Currency_ID@ " + newCurrency.getISO_Code());
                    }
                    invoice.setM_PriceList_ID(newPriceList.getM_PriceList_ID());
                    invoice.setC_Currency_ID(newCurrency.getC_Currency_ID());
                    Arrays.asList(invoice.getLines(true)).forEach(invoiceLine -> {
                        OrganizationRulesUtil.recalculateInvoiceLineRate(invoice, invoiceLine);
                        invoiceLine.saveEx();
                    });
                }
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        return null;
    }
}

