/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MClientInfo;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.X_LVE_WithholdingTax;

public class MLVEWithholdingTax
extends X_LVE_WithholdingTax {
    private static final long serialVersionUID = -7050562622116465459L;
    private static CCache<Integer, MLVEWithholdingTax> withholdingTaxCacheIds = new CCache("LVE_WithholdingTax", 30);
    private static CCache<String, MLVEWithholdingTax> withholdingTaxFromClientCache = new CCache("LVE_WithholdingTax_Client", 30);
    private MLVEList tributeUnitDefinition = null;

    public MLVEWithholdingTax(Properties ctx, int LVE_WithholdingTax_ID, String trxName) {
        super(ctx, LVE_WithholdingTax_ID, trxName);
    }

    public MLVEWithholdingTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MLVEWithholdingTax getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MLVEWithholdingTax withholdingTax = (MLVEWithholdingTax)withholdingTaxCacheIds.get((Object)definitionId);
        if (withholdingTax != null && withholdingTax.get_ID() > 0) {
            return withholdingTax;
        }
        withholdingTax = (MLVEWithholdingTax)new Query(ctx, "LVE_WithholdingTax", "LVE_WithholdingTax_ID=?", trxName).setClient_ID().setParameters(new Object[]{definitionId}).first();
        if (withholdingTax != null && withholdingTax.get_ID() > 0) {
            withholdingTaxCacheIds.put((Object)withholdingTax.get_ID(), (Object)withholdingTax);
        }
        return withholdingTax;
    }

    public static MLVEWithholdingTax getFromClient(Properties ctx, int organizationId, String type) {
        String key = Env.getAD_Client_ID((Properties)ctx) + "|" + organizationId + "|" + type;
        MLVEWithholdingTax withholdingTaxDefinition = (MLVEWithholdingTax)withholdingTaxFromClientCache.get((Object)key);
        if (withholdingTaxDefinition != null) {
            return withholdingTaxDefinition;
        }
        String whereClause = organizationId > 0 ? "AD_Org_ID IN(" + organizationId + ", 0)" : "";
        whereClause = whereClause + (!whereClause.equals("") ? " AND Type = '" + type + "'" : "");
        withholdingTaxDefinition = (MLVEWithholdingTax)new Query(ctx, "LVE_WithholdingTax", whereClause, null).setClient_ID().setOnlyActiveRecords(true).setOrderBy("AD_Org_ID DESC").first();
        withholdingTaxFromClientCache.put((Object)key, (Object)withholdingTaxDefinition);
        return withholdingTaxDefinition;
    }

    public BigDecimal getValidTributeUnitAmount(Timestamp validFrom) {
        MLVEListVersion version = this.getValidTributeUnitInstance(validFrom);
        if (version == null) {
            return Env.ZERO;
        }
        return version.getAmount();
    }

    public MLVEListVersion getValidTributeUnitInstance(Timestamp validFrom) {
        MLVEListVersion tributeUnit = null;
        if (this.tributeUnitDefinition == null) {
            this.tributeUnitDefinition = (MLVEList)new Query(this.getCtx(), "LVE_List", "LVE_ListType_ID = ?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{MClientInfo.get((Properties)this.getCtx()).get_ValueAsInt("TributeUnitType_ID")}).setOnlyActiveRecords(true).first();
        }
        if (this.tributeUnitDefinition != null) {
            tributeUnit = this.tributeUnitDefinition.getValidVersionInstance(validFrom);
        }
        return tributeUnit;
    }

    @Override
    public String toString() {
        return "MLVEWithholdingTax [getLVE_WithholdingTax_ID()=" + this.getLVE_WithholdingTax_ID() + ", getName()=" + this.getName() + ", getUUID()=" + this.getUUID() + "]";
    }
}

