/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEListVersion;
import org.erpya.lve.model.X_LVE_List;

public class MLVEList
extends X_LVE_List {
    private static final long serialVersionUID = -8380361947201510444L;
    private static CCache<Integer, MLVEList> cache = new CCache("LVE_List", 40, 5);
    private CCache<String, MLVEListVersion> listVersionCache = new CCache("LVE_ListVersion_ValidFrom", 40, 5);

    public MLVEList(Properties ctx, int LVE_List_ID, String trxName) {
        super(ctx, LVE_List_ID, trxName);
    }

    public MLVEList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MLVEList get(Properties ctx, int listId) {
        if (listId <= 0) {
            return null;
        }
        Integer key = new Integer(listId);
        MLVEList retValue = (MLVEList)cache.get((Object)key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MLVEList(ctx, listId, null);
        if (retValue.get_ID() != 0) {
            cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public BigDecimal getList(Timestamp from, BigDecimal amount, String columnParam) {
        return MLVEList.getList(this.getAD_Client_ID(), this.getValue(), from, amount, columnParam);
    }

    public static BigDecimal getList(int clientId, String listSearchKey, Timestamp from, BigDecimal amount, String columnParam) {
        BigDecimal value = Env.ZERO;
        ArrayList<Object> params = new ArrayList<Object>();
        String sqlList = "SELECT " + columnParam + " FROM LVE_List l INNER JOIN LVE_ListVersion lv ON (lv.LVE_List_ID=l.LVE_List_ID) INNER JOIN LVE_ListLine ll ON (ll.LVE_ListVersion_ID=lv.LVE_ListVersion_ID) WHERE l.IsActive='Y' AND lv.IsActive='Y' AND ll.IsActive='Y' AND l.Value = ? AND l.AD_Client_ID = ? AND (? BETWEEN lv.ValidFrom AND lv.ValidTo ) AND (? >= ll.MinValue AND ? <= ll.MaxValue)";
        params.add(listSearchKey);
        params.add(clientId);
        params.add(from);
        params.add(amount);
        params.add(amount);
        value = DB.getSQLValueBDEx(null, (String)sqlList, params);
        return value;
    }

    public BigDecimal getListVersionAmount(Timestamp validFrom) {
        MLVEListVersion version = this.getValidVersionInstance(validFrom);
        if (version == null) {
            return Env.ZERO;
        }
        return version.getAmount();
    }

    public MLVEListVersion getValidVersionInstance(Timestamp validFrom) {
        SimpleDateFormat format = (SimpleDateFormat)DateFormat.getInstance();
        format.applyPattern("yyyyMMdd");
        String key = this.getLVE_List_ID() + "|" + format.format(validFrom);
        MLVEListVersion listVersion = (MLVEListVersion)this.listVersionCache.get((Object)key);
        if (listVersion == null) {
            ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
            StringBuffer whereClause = new StringBuffer("LVE_List_ID = ?");
            params.add(Integer.valueOf(this.getLVE_List_ID()));
            whereClause.append(" AND ").append("ValidFrom<=?");
            params.add(validFrom);
            listVersion = (MLVEListVersion)new Query(this.getCtx(), "LVE_ListVersion", whereClause.toString(), null).setParameters(params).setOrderBy("ValidFrom DESC").setClient_ID().setOnlyActiveRecords(true).first();
            if (listVersion != null) {
                this.listVersionCache.put((Object)key, (Object)listVersion);
            }
        }
        return listVersion;
    }

    @Override
    public String toString() {
        return "MLVEList [getLVE_List_ID()=" + this.getLVE_List_ID() + ", getValue()=" + this.getValue() + ", getName()=" + this.getName() + "]";
    }

    public MLVEListVersion getValidVersionInstance(Timestamp validFrom, String columnFilter, String valueFilter) {
        if (columnFilter == null || valueFilter == null) {
            return null;
        }
        SimpleDateFormat format = (SimpleDateFormat)DateFormat.getInstance();
        format.applyPattern("yyyyMMdd");
        String key = this.getLVE_List_ID() + "|" + format.format(validFrom) + "|" + valueFilter;
        MLVEListVersion listVersion = (MLVEListVersion)this.listVersionCache.get((Object)key);
        if (listVersion == null) {
            ArrayList<Object> params = new ArrayList<Object>();
            StringBuffer whereClause = new StringBuffer("LVE_List_ID = ?");
            params.add(this.getLVE_List_ID());
            whereClause.append(" AND ").append("ValidFrom<=?");
            params.add(validFrom);
            whereClause.append(" AND ").append(columnFilter + " = ?");
            params.add(valueFilter);
            listVersion = (MLVEListVersion)new Query(this.getCtx(), "LVE_ListVersion", whereClause.toString(), null).setParameters(params).setOrderBy("ValidFrom DESC").setClient_ID().setOnlyActiveRecords(true).first();
            if (listVersion != null) {
                this.listVersionCache.put((Object)key, (Object)listVersion);
            }
        }
        return listVersion;
    }
}

