/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.util.Properties;
import org.adempiere.model.ImportValidator;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.Query;
import org.compiere.model.X_I_BPartner;
import org.compiere.model.X_I_Invoice;
import org.compiere.process.ImportBPartner;
import org.compiere.process.ImportInvoice;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class LVEImport
implements ImportValidator {
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public void validate(ImportProcess process, Object importModel, Object targetModel, int timing) {
        if (process != null) {
            if (importModel != null) {
                if (process instanceof ImportInvoice) {
                    X_I_Invoice impInvoice;
                    if (targetModel != null && targetModel instanceof MInvoice && timing == 30) {
                        impInvoice = (X_I_Invoice)importModel;
                        MInvoice invoice = (MInvoice)targetModel;
                        invoice.set_ValueOfColumn("ControlNo", (Object)impInvoice.get_ValueAsString("ControlNo"));
                    }
                    if (targetModel != null && targetModel instanceof MInvoiceLine && timing == 30) {
                        impInvoice = (X_I_Invoice)importModel;
                        MInvoiceLine invoiceLine = (MInvoiceLine)targetModel;
                        MInvoice sourceInvoice = (MInvoice)new Query(impInvoice.getCtx(), "C_Invoice", "C_BPartner_ID = ? AND DocumentNo = ?", impInvoice.get_TrxName()).setParameters(new Object[]{impInvoice.getC_BPartner_ID(), impInvoice.get_ValueAsString("AffectedDocumentNo")}).first();
                        if (sourceInvoice != null && sourceInvoice.get_ID() > 0) {
                            invoiceLine.set_ValueOfColumn("InvoiceToAllocate_ID", (Object)sourceInvoice.get_ID());
                        }
                    }
                } else if (process instanceof ImportBPartner) {
                    X_I_BPartner impBPartner = (X_I_BPartner)importModel;
                    if (timing == 40) {
                        if (targetModel != null && targetModel instanceof MBPartner) {
                            MBPartner bPartner = (MBPartner)targetModel;
                            bPartner.set_ValueOfColumn("PersonType", impBPartner.get_Value("PersonType"));
                            bPartner.set_ValueOfColumn("IsWithholdingTaxExempt", (Object)impBPartner.get_ValueAsBoolean("IsWithholdingTaxExempt"));
                            bPartner.set_ValueOfColumn("WithholdingTaxRate_ID", impBPartner.get_Value("WithholdingTaxRate_ID"));
                            bPartner.set_ValueOfColumn("IsWithholdingRentalExempt", (Object)impBPartner.get_ValueAsBoolean("IsWithholdingRentalExempt"));
                            bPartner.set_ValueOfColumn("IsWithholdingMunicipalExempt", (Object)impBPartner.get_ValueAsBoolean("IsWithholdingMunicipalExempt"));
                            bPartner.set_ValueOfColumn("BusinessActivity_ID", impBPartner.get_Value("BusinessActivity_ID"));
                            bPartner.set_ValueOfColumn("WithholdingMunicipalRate_ID", impBPartner.get_Value("WithholdingMunicipalRate_ID"));
                        } else if (targetModel != null && targetModel instanceof MBPartnerLocation) {
                            MBPartnerLocation bPartnerLocation = (MBPartnerLocation)targetModel;
                            bPartnerLocation.set_ValueOfColumn("SICACode", impBPartner.get_Value("SICACode"));
                        }
                    }
                }
            } else if (process instanceof ImportBPartner) {
                int no = 0;
                String clientCheck = ((ImportBPartner)process).getWhereClause();
                if (timing == 10) {
                    StringBuilder sql = new StringBuilder("UPDATE I_BPartner i SET WithholdingTaxRate_ID=(SELECT LVE_List_ID FROM LVE_List l WHERE i.WithholdingTaxValue=l.Value AND l.AD_Client_ID IN (0, i.AD_Client_ID) AND EXISTS(SELECT 1 FROM LVE_WithholdingTax wt WHERE wt.Type = 'IV' AND wt.WithholdingRateType_ID = l.LVE_ListType_ID)) WHERE WithholdingTaxRate_ID IS NULL AND COALESCE(i.IsWithholdingTaxExempt,'N') = 'N' AND I_IsImported<>'Y'").append(clientCheck);
                    no = DB.executeUpdateEx((String)sql.toString(), (String)process.get_TrxName());
                    this.log.fine("Set Withholding Tax=" + no);
                    sql = new StringBuilder("UPDATE I_BPartner i SET BusinessActivity_ID=(SELECT LVE_List_ID FROM LVE_List l WHERE i.BusinessActivityValue=l.Value AND l.AD_Client_ID IN (0, i.AD_Client_ID) AND EXISTS(SELECT 1 FROM LVE_WithholdingTax wt WHERE wt.Type = 'IM' AND wt.WithholdingRateType_ID = l.LVE_ListType_ID)) WHERE BusinessActivity_ID IS NULL AND COALESCE(i.IsWithholdingMunicipalExempt,'N') = 'N' AND I_IsImported<>'Y'").append(clientCheck);
                    no = DB.executeUpdateEx((String)sql.toString(), (String)process.get_TrxName());
                    this.log.fine("Set Withholding Municipal Activity=" + no);
                    sql = new StringBuilder("UPDATE I_BPartner i SET WithholdingMunicipalRate_ID=(SELECT LVE_ListVersion_ID FROM LVE_ListVersion lv WHERE i.WithholdingMunicipalValue=lv.Name AND lv.AD_Client_ID IN (0, i.AD_Client_ID) AND lv.LVE_List_ID = i.BusinessActivity_ID) WHERE WithholdingMunicipalRate_ID IS NULL AND COALESCE(i.IsWithholdingMunicipalExempt,'N') = 'N' AND I_IsImported<>'Y'").append(clientCheck);
                    no = DB.executeUpdateEx((String)sql.toString(), (String)process.get_TrxName());
                    this.log.fine("Set Withholding Municipal Rate=" + no);
                } else if (timing == 20) {
                    StringBuilder sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)process.getCtx(), (String)"@Invalid@ @WithholdingTaxRate_ID@") + ", ' WHERE WithholdingTaxRate_ID IS NULL AND WithholdingTaxValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
                    no = DB.executeUpdateEx((String)sql.toString(), (String)process.get_TrxName());
                    this.log.config("Invalid Withholding Tax Rate=" + no);
                    sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)process.getCtx(), (String)"@Invalid@ @BusinessActivity_ID@") + ", ' WHERE BusinessActivity_ID IS NULL AND BusinessActivityValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
                    no = DB.executeUpdateEx((String)sql.toString(), (String)process.get_TrxName());
                    this.log.config("Invalid Withholding Municipal Activity=" + no);
                    sql = new StringBuilder("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=" + Msg.parseTranslation((Properties)process.getCtx(), (String)"@Invalid@ @WithholdingMunicipalRate_ID@") + ", ' WHERE WithholdingMunicipalRate_ID IS NULL AND WithholdingMunicipalValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
                    no = DB.executeUpdateEx((String)sql.toString(), (String)process.get_TrxName());
                    this.log.config("Invalid Withholding Municipal Rate=" + no);
                }
            }
        }
    }
}

