/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.ImportValidator;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTax;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.erpya.lve.model.LVEImport;
import org.erpya.lve.util.AllocationManager;
import org.erpya.lve.util.DocumentTypeSequence;
import org.erpya.lve.util.LVEUtil;
import org.spin.model.MWHWithholding;

public class LVE
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(LVE.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("M_Movement", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_BPartner", (ModelValidator)this);
        engine.addModelChange("WH_Withholding", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_Payment", (ModelValidator)this);
        LVEImport importValidator = new LVEImport();
        engine.addImportValidate("I_Invoice", (ImportValidator)importValidator);
        engine.addImportValidate("I_BPartner", (ImportValidator)importValidator);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 1) {
            MInvoice invoice2;
            if (po.get_TableName().equals("C_Invoice") && !(invoice2 = (MInvoice)po).isReversal()) {
                Optional.ofNullable((MOrder)invoice2.getC_Order()).ifPresent(salesOrder -> {
                    MDocType orderDocumentType = MDocType.get((Properties)salesOrder.getCtx(), (int)salesOrder.getC_DocTypeTarget_ID());
                    if (orderDocumentType.get_ValueAsBoolean("IsReCalculatePriceOnInvoice")) {
                        Arrays.asList(invoice2.getLines(true)).stream().filter(invoiceLine -> invoiceLine.getM_Product_ID() > 0).forEach(invoiceLine -> {
                            invoiceLine.setPrice(invoice2.getM_PriceList_ID(), invoice2.getC_BPartner_ID());
                            invoiceLine.saveEx();
                        });
                    }
                });
            }
        } else if (timing == 7) {
            if (po.get_TableName().equals("C_Invoice")) {
                MInvoice invoice3 = (MInvoice)po;
                if (invoice3.isReversal()) {
                    invoice3.set_ValueOfColumn("IsFiscalDocument", (Object)false);
                    invoice3.saveEx();
                } else {
                    MDocType documentType = MDocType.get((Properties)invoice3.getCtx(), (int)invoice3.getC_DocTypeTarget_ID());
                    Optional.ofNullable((MOrder)invoice3.getC_Order()).ifPresent(salesOrder -> {
                        MDocType orderDocumentType = MDocType.get((Properties)salesOrder.getCtx(), (int)salesOrder.getC_DocTypeTarget_ID());
                        if (orderDocumentType.get_ValueAsBoolean("IsReCalculatePriceOnInvoice")) {
                            Arrays.asList(invoice3.getLines(true)).stream().filter(invoiceLine -> invoiceLine.getM_Product_ID() > 0).forEach(invoiceLine -> {
                                invoiceLine.setPrice(invoice3.getM_PriceList_ID(), invoice3.getC_BPartner_ID());
                                invoiceLine.saveEx();
                            });
                        }
                    });
                    if (invoice3.get_ValueAsInt("InvoiceToAllocate_ID") == 0 && (documentType.getDocBaseType().equals("APC") || documentType.getDocBaseType().equals("ARC"))) {
                        Optional.ofNullable(invoice3.getC_Order()).ifPresent(returnOrder -> {
                            MDocType returnOrderSubType = MDocType.get((Properties)invoice3.getCtx(), (int)returnOrder.getC_DocType_ID());
                            if (!Util.isEmpty((String)returnOrderSubType.getDocSubTypeSO()) && returnOrderSubType.getDocSubTypeSO().equals("RM")) {
                                HashMap invoiceToAllocate = new HashMap();
                                HashMap invoiceLinesAllocated = new HashMap();
                                List<MInvoiceLine> creditMemoLines = Arrays.asList(invoice3.getLines());
                                if (creditMemoLines.stream().filter(invoiceLine -> invoiceLine.get_ValueAsInt("InvoiceToAllocate_ID") != 0).count() == 0L) {
                                    creditMemoLines.stream().filter(creditMemoLine -> creditMemoLine.getC_OrderLine_ID() != 0).forEach(creditMemoLine -> {
                                        MOrderLine returnOrderLine = (MOrderLine)creditMemoLine.getC_OrderLine();
                                        if (returnOrderLine.get_ValueAsInt("Ref_InvoiceLine_ID") != 0) {
                                            MInvoiceLine sourceInvoiceLine2 = new MInvoiceLine(creditMemoLine.getCtx(), returnOrderLine.get_ValueAsInt("Ref_InvoiceLine_ID"), creditMemoLine.get_TrxName());
                                            invoiceToAllocate.put(sourceInvoiceLine2.getC_Invoice_ID(), creditMemoLine.getC_InvoiceLine_ID());
                                            invoiceLinesAllocated.put(creditMemoLine.getC_InvoiceLine_ID(), sourceInvoiceLine2.getC_Invoice_ID());
                                        } else {
                                            Optional.ofNullable((MInvoiceLine)new Query(creditMemoLine.getCtx(), "C_InvoiceLine", "EXISTS (SELECT 1 FROM C_OrderLine oLine INNER JOIN M_InOutLine iol ON (oLine.Ref_InOutLine_ID = iol.M_InOutLine_ID) WHERE oLine.C_OrderLine_ID = ? AND iol.C_OrderLine_ID = C_InvoiceLine.C_OrderLine_ID ) AND EXISTS(SELECT 1 FROM C_Invoice i WHERE i.C_Invoice_ID = C_InvoiceLine.C_Invoice_ID AND i.DocStatus IN ('CO','CL'))", creditMemoLine.get_TrxName()).setParameters(new Object[]{creditMemoLine.getC_OrderLine_ID()}).first()).ifPresent(sourceInvoiceLine -> {
                                                invoiceToAllocate.put(sourceInvoiceLine.getC_Invoice_ID(), creditMemoLine.getC_InvoiceLine_ID());
                                                invoiceLinesAllocated.put(creditMemoLine.getC_InvoiceLine_ID(), sourceInvoiceLine.getC_Invoice_ID());
                                            });
                                        }
                                    });
                                }
                                if (invoiceToAllocate.size() == 1) {
                                    invoice3.set_ValueOfColumn("InvoiceToAllocate_ID", invoiceToAllocate.keySet().stream().findFirst().get());
                                    invoice3.saveEx();
                                } else if (invoiceToAllocate.size() > 0) {
                                    creditMemoLines.forEach(invoiceLine -> {
                                        int invoiceToAllocateId = (Integer)invoiceLinesAllocated.get(invoiceLine.getC_InvoiceLine_ID());
                                        if (invoiceToAllocateId != 0) {
                                            invoiceLine.set_ValueOfColumn("InvoiceToAllocate_ID", (Object)invoiceToAllocateId);
                                            invoiceLine.saveEx();
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }
        } else if (timing == 9) {
            MDocType documentType;
            MOrder order;
            if (po.get_TableName().equals("C_Order") && (order = (MOrder)po).isReplication()) {
                MInvoice invoice4 = new MInvoice(order.getCtx(), order.getC_Invoice_ID(), order.get_TrxName());
                invoice4.setReplication(true);
                invoice4.setIsPaid(false);
                invoice4.save();
            }
            if (po.get_TableName().equals("C_Invoice")) {
                MInvoice invoice5 = (MInvoice)po;
                if (!invoice5.isReversal()) {
                    documentType = MDocType.get((Properties)invoice5.getCtx(), (int)invoice5.getC_DocTypeTarget_ID());
                    invoice5.set_ValueOfColumn("IsFiscalDocument", (Object)documentType.get_ValueAsBoolean("IsFiscalDocument"));
                    if (!documentType.get_ValueAsBoolean("IsSetControlNoOnPrint") && Util.isEmpty((String)invoice5.get_ValueAsString("ControlNo"))) {
                        DocumentTypeSequence sequence = new DocumentTypeSequence(documentType);
                        invoice5.set_ValueOfColumn("ControlNo", (Object)sequence.getControlNo());
                    }
                    if (new Query(invoice5.getCtx(), "WH_Withholding", "C_Invoice_ID = ? AND IsManual = 'N'", invoice5.get_TrxName()).setParameters(new Object[]{invoice5.getC_Invoice_ID()}).match()) {
                        int docNo = Integer.parseInt(invoice5.getDocumentNo());
                        String format = "yyyyMM";
                        SimpleDateFormat sdf = new SimpleDateFormat(format);
                        String prefix = sdf.format(invoice5.getDateInvoiced().getTime());
                        if (prefix == null) {
                            prefix = "";
                        }
                        invoice5.setDocumentNo(prefix + String.format("%1$8s", docNo).replace(" ", "0"));
                    }
                    if (documentType.get_ValueAsBoolean("IsAllocateInvoice")) {
                        AllocationManager allocationManager = new AllocationManager(invoice5);
                        Arrays.asList(invoice5.getLines()).stream().filter(invoiceLine -> invoiceLine.get_ValueAsInt("InvoiceToAllocate_ID") != 0).forEach(invoiceLine -> Optional.ofNullable(MTax.get((Properties)invoiceLine.getCtx(), (int)invoiceLine.getC_Tax_ID())).ifPresent(tax -> {
                            BigDecimal amountToAllocate = invoiceLine.getLineNetAmt();
                            amountToAllocate = amountToAllocate.add(tax.calculateTax(amountToAllocate, invoiceLine.isTaxIncluded(), invoiceLine.getPrecision()));
                            allocationManager.addAllocateDocument(invoiceLine.get_ValueAsInt("InvoiceToAllocate_ID"), amountToAllocate, Env.ZERO, Env.ZERO);
                        }));
                        allocationManager.createAllocation();
                    }
                    invoice5.saveEx();
                }
            } else if (po.get_TableName().equals("M_InOut")) {
                MInOut shipment = (MInOut)po;
                if (shipment.isReversal()) {
                    shipment.set_ValueOfColumn("IsFiscalDocument", (Object)false);
                } else {
                    documentType = (MDocType)shipment.getC_DocType();
                    shipment.set_ValueOfColumn("IsFiscalDocument", (Object)documentType.get_ValueAsBoolean("IsFiscalDocument"));
                    if (!documentType.get_ValueAsBoolean("IsSetControlNoOnPrint") && Util.isEmpty((String)shipment.get_ValueAsString("ControlNo"))) {
                        DocumentTypeSequence sequence = new DocumentTypeSequence(documentType);
                        shipment.set_ValueOfColumn("ControlNo", (Object)sequence.getControlNo());
                    }
                }
                shipment.saveEx();
            } else if (po.get_TableName().equals("M_Movement")) {
                MMovement movement = (MMovement)po;
                if (movement.isReversal()) {
                    movement.set_ValueOfColumn("IsFiscalDocument", (Object)false);
                } else {
                    documentType = (MDocType)movement.getC_DocType();
                    movement.set_ValueOfColumn("IsFiscalDocument", (Object)documentType.get_ValueAsBoolean("IsFiscalDocument"));
                    if (!documentType.get_ValueAsBoolean("IsSetControlNoOnPrint") && Util.isEmpty((String)movement.get_ValueAsString("ControlNo"))) {
                        DocumentTypeSequence sequence = new DocumentTypeSequence(documentType);
                        movement.set_ValueOfColumn("ControlNo", (Object)sequence.getControlNo());
                    }
                }
                movement.saveEx();
            }
        } else if (timing == 2 || timing == 5 || timing == 6) {
            List orders;
            MInOut shipmentReceipt;
            if (po.get_TableName().equals("C_Order")) {
                MOrder order = (MOrder)po;
                if (order.isSOTrx() && order.getC_POS_ID() <= 0) {
                    List invoices = new Query(order.getCtx(), "C_Invoice", "DocStatus IN('CO', 'CL') AND EXISTS(SELECT 1 FROM C_InvoiceLine il \t\t\tINNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = il.C_OrderLine_ID) \t\t\tWHERE il.C_Invoice_ID = C_Invoice.C_Invoice_ID \t\t\tAND ol.C_Order_ID = ?)", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).setClient_ID().list();
                    if (invoices != null && invoices.size() > 0) {
                        StringBuffer message = new StringBuffer();
                        invoices.forEach(invoice -> {
                            if (message.length() > 0) {
                                message.append(Env.NL);
                            }
                            message.append(invoice.getDocumentNo());
                        });
                        throw new AdempiereException("@SQLErrorReferenced@ @C_Invoice_ID@ " + Env.NL + message);
                    }
                    List deliveries = new Query(order.getCtx(), "M_InOut", "DocStatus IN('CO', 'CL') AND EXISTS(SELECT 1 FROM M_InOutLine il \t\t\tINNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = il.C_OrderLine_ID) \t\t\tWHERE il.M_InOut_ID = M_InOut.M_InOut_ID \t\t\tAND ol.C_Order_ID = ?)", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).setClient_ID().list();
                    if (deliveries != null && deliveries.size() > 0) {
                        StringBuffer message = new StringBuffer();
                        deliveries.forEach(delivery -> {
                            if (message.length() > 0) {
                                message.append(Env.NL);
                            }
                            message.append(delivery.getDocumentNo());
                        });
                        throw new AdempiereException("@SQLErrorReferenced@ @M_InOut_ID@ " + Env.NL + message);
                    }
                }
            } else if (po.get_TableName().equals("M_InOut") && (shipmentReceipt = (MInOut)po).isProcessed() && (orders = new Query(shipmentReceipt.getCtx(), "C_Order", "DocStatus NOT IN ('CO') AND EXISTS(SELECT 1 FROM C_OrderLine ol \t\t\tINNER JOIN M_InOutLine iol ON(iol.C_OrderLine_ID = ol.C_OrderLine_ID) \t\t\tWHERE ol.C_Order_ID = C_Order.C_Order_ID \t\t\tAND iol.M_InOut_ID = ?)", shipmentReceipt.get_TrxName()).setParameters(new Object[]{shipmentReceipt.getM_InOut_ID()}).setClient_ID().list()) != null && orders.size() > 0) {
                StringBuffer message = new StringBuffer();
                orders.forEach(invoice -> {
                    if (message.length() > 0) {
                        message.append(Env.NL);
                    }
                    message.append(invoice.getDocumentNo());
                });
                throw new AdempiereException("@CreateShipment.OrderNotCompleted@: " + Env.NL + message);
            }
        }
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        MInvoice invoice;
        if (type == 1 || type == 2) {
            MWHWithholding withholding;
            MInvoiceLine invoiceLine;
            log.fine(" TYPE_BEFORE_NEW || TYPE_BEFORE_CHANGE");
            if (po.get_TableName().equals("C_Invoice")) {
                int WHThirdParty_ID;
                MInvoice invoice2 = (MInvoice)po;
                if (invoice2.is_ValueChanged("InvoiceToAllocate_ID") && invoice2.get_ValueAsInt("InvoiceToAllocate_ID") != 0) {
                    for (MInvoiceLine line : invoice2.getLines()) {
                        if (line.get_ValueAsInt("InvoiceToAllocate_ID") != 0) continue;
                        line.set_ValueOfColumn("InvoiceToAllocate_ID", invoice2.get_Value("InvoiceToAllocate_ID"));
                        line.saveEx();
                    }
                }
                if (invoice2.get_ValueAsInt("WHThirdParty_ID") == 0 && invoice2.getC_BPartner_ID() > 0 && (WHThirdParty_ID = ((MBPartner)invoice2.getC_BPartner()).get_ValueAsInt("WHThirdParty_ID")) != 0) {
                    invoice2.set_ValueOfColumn("WHThirdParty_ID", (Object)WHThirdParty_ID);
                }
                LVEUtil.setDefaultValuesFromDocumentType((PO)invoice2);
            }
            if (po.get_TableName().equals("C_InvoiceLine")) {
                MInvoiceLine invoiceLine2 = (MInvoiceLine)po;
                MInvoice invoice3 = invoiceLine2.getParent();
                if (invoice3.get_ValueAsInt("InvoiceToAllocate_ID") != 0 && invoiceLine2.get_ValueAsInt("InvoiceToAllocate_ID") == 0) {
                    invoiceLine2.set_ValueOfColumn("InvoiceToAllocate_ID", (Object)invoice3.get_ValueAsInt("InvoiceToAllocate_ID"));
                } else if (invoiceLine2.is_ValueChanged("InvoiceToAllocate_ID") && invoiceLine2.get_ValueAsInt("InvoiceToAllocate_ID") != 0 && invoiceLine2.getParent().get_ValueAsInt("InvoiceToAllocate_ID") != 0 && invoiceLine2.getParent().get_ValueAsInt("InvoiceToAllocate_ID") != invoiceLine2.get_ValueAsInt("InvoiceToAllocate_ID")) {
                    invoice3.set_ValueOfColumn("InvoiceToAllocate_ID", (Object)invoiceLine2.get_ValueAsInt("InvoiceToAllocate_ID"));
                    invoice3.save();
                }
            } else if (po.get_TableName().equals("C_BPartner")) {
                MBPartner businessPartner = (MBPartner)po;
                if (type == 1 || type == 2) {
                    if (businessPartner.is_ValueChanged("Value")) {
                        String value = LVEUtil.processBusinessPartnerValue(businessPartner.getCtx(), businessPartner.getAD_Client_ID(), businessPartner.getAD_Org_ID(), businessPartner.getValue());
                        String taxId = LVEUtil.processBusinessPartnerValue(businessPartner.getCtx(), businessPartner.getAD_Client_ID(), businessPartner.getAD_Org_ID(), businessPartner.getTaxID());
                        businessPartner.setValue(value);
                        if (Util.isEmpty((String)taxId)) {
                            businessPartner.setTaxID(value);
                        }
                    } else if (businessPartner.is_ValueChanged("TaxID")) {
                        String taxId = LVEUtil.processBusinessPartnerValue(businessPartner.getCtx(), businessPartner.getAD_Client_ID(), businessPartner.getAD_Org_ID(), businessPartner.getTaxID());
                        businessPartner.setTaxID(taxId);
                    }
                    if (type == 1) {
                        businessPartner.setAD_Org_ID(0);
                    }
                }
            } else if (po.get_TableName().equals("WH_Withholding") && (invoiceLine = (MInvoiceLine)new Query((withholding = (MWHWithholding)po).getCtx(), "C_InvoiceLine", "C_InvoiceLine_ID = ?", withholding.get_TrxName()).setParameters(new Object[]{withholding.getC_InvoiceLine_ID()}).first()) != null && invoiceLine.get_ID() > 0) {
                invoiceLine.set_ValueOfColumn("InvoiceToAllocate_ID", (Object)withholding.getSourceInvoice_ID());
                invoiceLine.save();
            }
            if (po.get_TableName().equals("C_Order")) {
                LVEUtil.setDefaultValuesFromDocumentType(po);
            }
            if (po.get_TableName().equals("C_Payment")) {
                LVEUtil.setDefaultValuesFromDocumentType(po);
            }
        } else if (type == 5 && po.get_TableName().equals("C_Invoice") && !(invoice = (MInvoice)po).isReplication() && invoice.is_ValueChanged("DocStatus") && invoice.getDocStatus().equals("CO") && invoice.testAllocation()) {
            invoice.save();
        }
        return null;
    }
}

