/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.model.MLVEList;

public class FinancialBigTransactionTax
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(FinancialBigTransactionTax.class);
    private int clientId = -1;
    boolean notProcessed = true;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 9) {
            if (po.get_TableName().equals("C_Payment")) {
                return this.createFBTTForPayment((MPayment)po);
            }
        } else if (timing == 13 || timing == 10) {
            return this.reverseFBTTForPayment((MPayment)po);
        }
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    private String createFBTTForPayment(MPayment sourcePayment) {
        if (sourcePayment.getReversal_ID() == 0 && !sourcePayment.isReceipt() && !this.isFBTT(sourcePayment)) {
            int chargeId;
            MPayment fbttRefPayment;
            if (sourcePayment.get_ValueAsInt("FBTT_Payment_ID") != 0 && ((fbttRefPayment = new MPayment(sourcePayment.getCtx(), sourcePayment.get_ValueAsInt("FBTT_Payment_ID"), sourcePayment.get_TrxName())).getDocStatus().equals("CO") || fbttRefPayment.getDocStatus().equals("CL"))) {
                return null;
            }
            MBPartner bpartner = MBPartner.get((Properties)sourcePayment.getCtx(), (int)sourcePayment.getC_BPartner_ID());
            if (bpartner.get_ValueAsBoolean("IsFBTTTaxExempt")) {
                return null;
            }
            int defaultCurrencyId = MClient.get((Properties)sourcePayment.getCtx()).getC_Currency_ID();
            MBankAccount bankAccount = MBankAccount.get((Properties)sourcePayment.getCtx(), (int)sourcePayment.getC_BankAccount_ID());
            if (bankAccount == null) {
                return null;
            }
            if (bankAccount.getC_Currency_ID() != defaultCurrencyId) {
                return null;
            }
            MBank bank = MBank.get((Properties)sourcePayment.getCtx(), (int)bankAccount.getC_Bank_ID());
            int listId = bank.get_ValueAsInt("LVE_List_ID");
            if (listId == 0 || !Util.isEmpty((String)bank.getBankType()) && bank.getBankType().equals("C")) {
                return null;
            }
            MLVEList list = MLVEList.get(Env.getCtx(), listId);
            if (list == null) {
                return null;
            }
            BigDecimal rateToApply = list.getList(sourcePayment.getDateTrx(), sourcePayment.getPayAmt(), "Col_1");
            if (rateToApply == null || rateToApply.equals(Env.ZERO)) {
                return null;
            }
            MPayment fbttPayment = new MPayment(sourcePayment.getCtx(), 0, sourcePayment.get_TrxName());
            PO.copyValues((PO)sourcePayment, (PO)fbttPayment);
            fbttPayment.setIsPrepayment(false);
            fbttPayment.setC_Order_ID(0);
            fbttPayment.setC_Invoice_ID(0);
            fbttPayment.setIsOverUnderPayment(false);
            fbttPayment.setIsOnline(false);
            fbttPayment.setIsReconciled(false);
            fbttPayment.setPayAmt(Env.ZERO);
            fbttPayment.setC_Currency_ID(defaultCurrencyId);
            fbttPayment.setOverUnderAmt(Env.ZERO);
            fbttPayment.setWriteOffAmt(Env.ZERO);
            fbttPayment.setTaxAmt(Env.ZERO);
            fbttPayment.setChargeAmt(Env.ZERO);
            fbttPayment.setProcessed(false);
            fbttPayment.setDocStatus("DR");
            fbttPayment.setCheckNo(null);
            fbttPayment.setRoutingNo(null);
            fbttPayment.setAccountNo(null);
            fbttPayment.setMicr(null);
            fbttPayment.setA_Name(null);
            fbttPayment.addDescription(Msg.parseTranslation((Properties)sourcePayment.getCtx(), (String)"@Generate@ @from@ @FBTT@"));
            MClientInfo clientInfo = MClientInfo.get((Properties)sourcePayment.getCtx());
            int bPartnerId = clientInfo.get_ValueAsInt("FBTT_BPartner_ID");
            if (bPartnerId != 0) {
                fbttPayment.setC_BPartner_ID(bPartnerId);
            }
            if ((chargeId = clientInfo.get_ValueAsInt("FBTT_Charge_ID")) == 0) {
                return "@FBTT_Charge_ID@ @NotFound@";
            }
            fbttPayment.setC_Charge_ID(chargeId);
            rateToApply = rateToApply.divide(Env.ONEHUNDRED, MathContext.DECIMAL128);
            BigDecimal payAmt = rateToApply.multiply(sourcePayment.getPayAmt());
            fbttPayment.setPayAmt(payAmt);
            fbttPayment.saveEx();
            sourcePayment.set_ValueOfColumn("FBTT_Payment_ID", (Object)fbttPayment.getC_Payment_ID());
            sourcePayment.saveEx();
            fbttPayment.setDocAction("CO");
            fbttPayment.processIt("CO");
            fbttPayment.saveEx();
            if (fbttPayment.getDocStatus() != "CO") {
                return fbttPayment.getProcessMsg();
            }
        }
        return null;
    }

    private String reverseFBTTForPayment(MPayment sourcePayment) {
        if (!sourcePayment.isReceipt() && sourcePayment.get_ValueAsInt("FBTT_Payment_ID") != 0) {
            int igtfPaymentId = sourcePayment.get_ValueAsInt("FBTT_Payment_ID");
            MPayment fbttPayment = new MPayment(sourcePayment.getCtx(), igtfPaymentId, sourcePayment.get_TrxName());
            if (fbttPayment.getDocStatus().equals("CO")) {
                fbttPayment.setDocAction("RC");
                fbttPayment.processIt("RC");
                fbttPayment.saveEx();
                if (fbttPayment.getDocStatus() != "RE") {
                    return fbttPayment.getProcessMsg();
                }
            }
        }
        return null;
    }

    private boolean isFBTT(MPayment payment) {
        int igtfPaymentId = DB.getSQLValue((String)payment.get_TrxName(), (String)"SELECT C_Payment_ID FROM C_Payment WHERE FBTT_Payment_ID = ?", (int)payment.getC_Payment_ID());
        return igtfPaymentId > 0;
    }
}

