/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.X_I_BankStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class DirectDebitBatch
implements BankStatementMatcherInterface {
    @Override
    public BankStatementMatchInfo findMatch(MBankStatementLine bsl, List<Integer> includedPayments, List<Integer> exludedPayments) {
        return null;
    }

    @Override
    public BankStatementMatchInfo findMatch(X_I_BankStatement ibs, List<Integer> includedPayments, List<Integer> exludedPayments) {
        StringBuffer paymentWhereClause = new StringBuffer();
        if (includedPayments != null && includedPayments.size() > 0) {
            paymentWhereClause.append(" AND ").append("p.C_Payment_ID").append(" IN").append(includedPayments.toString().replace('[', '(').replace(']', ')')).append(" ");
        }
        if (exludedPayments != null && exludedPayments.size() > 0) {
            paymentWhereClause.append(" AND ").append("p.C_Payment_ID").append(" NOT IN").append(exludedPayments.toString().replace('[', '(').replace(']', ')')).append(" ");
        }
        BankStatementMatchInfo info = new BankStatementMatchInfo();
        if (ibs.getC_Payment_ID() != 0) {
            return info;
        }
        String ORDERVALUE = " DESC NULLS LAST";
        StringBuffer sql = new StringBuffer("SELECT p.C_Payment_ID FROM C_Payment p WHERE p.AD_Client_ID = ? ");
        if (paymentWhereClause.length() > 0) {
            sql.append(paymentWhereClause);
        }
        StringBuffer where = new StringBuffer();
        StringBuffer orderByClause = new StringBuffer(" ORDER BY ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ibs.getAD_Client_ID());
        if (!Util.isEmpty((String)ibs.getMemo())) {
            where.append("? LIKE '%' || p.CheckNo || '%' ");
            where.append("OR ? LIKE '%' || p.DocumentNo || '%' ");
            where.append("OR p.CheckNo LIKE ? ");
            where.append("OR p.DocumentNo LIKE ?");
            params.add(ibs.getMemo().toUpperCase().replaceAll("[^a-zA-Z0-9- ]", "").trim());
            params.add(ibs.getMemo().toUpperCase().replaceAll("[^a-zA-Z0-9- ]", "").trim());
            params.add(ibs.getMemo().toUpperCase().replaceAll("[^a-zA-Z0-9- ]", "").trim());
            params.add(ibs.getMemo().toUpperCase().replaceAll("[^a-zA-Z0-9- ]", "").trim());
        }
        if (where.length() > 0) {
            where.insert(0, "AND (").append(")");
        }
        where.append(" AND p.DateTrx = ?");
        params.add(ibs.getValutaDate());
        if (!Util.isEmpty((String)ibs.getISO_Code())) {
            where.append(" AND EXISTS(SELECT 1 FROM C_Currency c WHERE c.C_Currency_ID = p.C_Currency_ID AND c.ISO_Code = ?) ");
            params.add(ibs.getISO_Code());
        } else if (ibs.getC_Currency_ID() != 0) {
            where.append(" AND p.C_Currency_ID = ? ");
            params.add(ibs.getC_Currency_ID());
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        boolean isReceipt = ibs.getTrxAmt().compareTo(Env.ZERO) > 0;
        where.append(" p.IsReceipt = ? ");
        params.add(isReceipt);
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append("(p.C_BankAccount_ID = ?)");
        params.add(ibs.getC_BankAccount_ID());
        where.append(" AND p.DocStatus IN('CO', 'CL')");
        where.append(" AND p.IsReconciled = 'N'");
        where.append(" AND NOT EXISTS(SELECT 1 FROM I_BankStatement i WHERE i.C_Payment_ID = p.C_Payment_ID) ");
        orderByClause.append("p.DateTrx ASC");
        orderByClause.append(", p.DocumentNo").append(ORDERVALUE);
        orderByClause.append(", p.CheckNo").append(ORDERVALUE);
        orderByClause.append(", p.Description").append(ORDERVALUE);
        sql.append(where);
        sql.append(orderByClause);
        int paymentId = DB.getSQLValue((String)ibs.get_TrxName(), (String)sql.toString(), params);
        if (paymentId > 0) {
            info.setC_Payment_ID(paymentId);
            MPayment payment = new MPayment(ibs.getCtx(), paymentId, ibs.get_TrxName());
            ibs.setTrxAmt(payment.getPayAmt(false));
            MBankAccount bankAccount = MBankAccount.get((Properties)payment.getCtx(), (int)payment.getC_BankAccount_ID());
            if (bankAccount.get_ValueAsInt("LVE_DefaultStatementCharge_ID") > 0) {
                ibs.setChargeAmt(ibs.getStmtAmt().subtract(payment.getPayAmt(false)));
                ibs.setC_Charge_ID(bankAccount.get_ValueAsInt("LVE_DefaultStatementCharge_ID"));
            } else {
                ibs.setInterestAmt(ibs.getStmtAmt().subtract(payment.getPayAmt(false)));
            }
        }
        return info;
    }
}

