/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.matcher;

import java.util.ArrayList;
import java.util.List;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.X_I_BankStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CurrencyAmountAndTrxDate
implements BankStatementMatcherInterface {
    @Override
    public BankStatementMatchInfo findMatch(MBankStatementLine bsl, List<Integer> includedPayments, List<Integer> exludedPayments) {
        return null;
    }

    @Override
    public BankStatementMatchInfo findMatch(X_I_BankStatement ibs, List<Integer> includedPayments, List<Integer> exludedPayments) {
        StringBuffer paymentWhereClause = new StringBuffer();
        if (includedPayments != null && includedPayments.size() > 0) {
            paymentWhereClause.append(" AND ").append("p.C_Payment_ID").append(" IN").append(includedPayments.toString().replace('[', '(').replace(']', ')')).append(" ");
        }
        if (exludedPayments != null && exludedPayments.size() > 0) {
            paymentWhereClause.append(" AND ").append("p.C_Payment_ID").append(" NOT IN").append(exludedPayments.toString().replace('[', '(').replace(']', ')')).append(" ");
        }
        BankStatementMatchInfo info = new BankStatementMatchInfo();
        if (ibs.getC_Payment_ID() != 0) {
            return info;
        }
        String ORDERVALUE = " DESC NULLS LAST";
        StringBuffer sql = new StringBuffer("SELECT p.C_Payment_ID FROM C_Payment p WHERE p.AD_Client_ID = ? ");
        if (paymentWhereClause.length() > 0) {
            sql.append(paymentWhereClause);
        }
        StringBuffer where = new StringBuffer();
        StringBuffer orderByClause = new StringBuffer(" ORDER BY ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ibs.getAD_Client_ID());
        if (!Util.isEmpty((String)ibs.getISO_Code())) {
            where.append(" AND EXISTS(SELECT 1 FROM C_Currency c WHERE c.C_Currency_ID = p.C_Currency_ID AND c.ISO_Code = ?) ");
            params.add(ibs.getISO_Code());
        } else if (ibs.getC_Currency_ID() != 0) {
            where.append(" AND p.C_Currency_ID = ? ");
            params.add(ibs.getC_Currency_ID());
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        boolean isReceipt = ibs.getTrxAmt().compareTo(Env.ZERO) > 0;
        where.append("(p.PayAmt = ? ");
        params.add(isReceipt ? ibs.getTrxAmt() : ibs.getTrxAmt().negate());
        where.append("AND p.IsReceipt = ? )");
        params.add(isReceipt);
        if (ibs.getEftStatementDate() != null || ibs.getEftStatementLineDate() != null || ibs.getEftValutaDate() != null || ibs.getDateAcct() != null) {
            where.append(" AND (");
            StringBuffer internalTransaction = new StringBuffer();
            if (ibs.getEftStatementDate() != null) {
                internalTransaction.append("p.DateTrx = ?");
                params.add(ibs.getEftStatementDate());
            }
            if (ibs.getEftStatementLineDate() != null) {
                if (internalTransaction.length() > 0) {
                    internalTransaction.append(" OR ");
                }
                internalTransaction.append("p.DateTrx = ?");
                params.add(ibs.getEftStatementLineDate());
            }
            if (ibs.getEftValutaDate() != null) {
                if (internalTransaction.length() > 0) {
                    internalTransaction.append(" OR ");
                }
                internalTransaction.append("p.DateTrx = ?");
                params.add(ibs.getEftValutaDate());
            }
            if (ibs.getDateAcct() != null) {
                if (internalTransaction.length() > 0) {
                    internalTransaction.append(" OR ");
                }
                internalTransaction.append("p.DateTrx = ?");
                params.add(ibs.getDateAcct());
            }
            where.append(internalTransaction);
            where.append(")");
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append("(p.C_BankAccount_ID = ?)");
        params.add(ibs.getC_BankAccount_ID());
        where.append(" AND p.DocStatus IN('CO', 'CL')");
        where.append(" AND p.IsReconciled = 'N'");
        where.append(" AND NOT EXISTS(SELECT 1 FROM I_BankStatement i WHERE i.C_Payment_ID = p.C_Payment_ID) ");
        orderByClause.append("p.DateTrx ASC");
        orderByClause.append(", p.DocumentNo").append(ORDERVALUE);
        orderByClause.append(", p.CheckNo").append(ORDERVALUE);
        orderByClause.append(", p.Description").append(ORDERVALUE);
        sql.append(where);
        sql.append(orderByClause);
        int paymentId = DB.getSQLValue((String)ibs.get_TrxName(), (String)sql.toString(), params);
        if (paymentId > 0) {
            info.setC_Payment_ID(paymentId);
        }
        if (!Util.isEmpty((String)ibs.getEftPayeeAccount())) {
            int businessPartnerId;
            String additionaWhereClause = "";
            String businessPartnerTaxId = ibs.getEftPayeeAccount().trim();
            businessPartnerTaxId = businessPartnerTaxId.replace("-", "").trim();
            String businessPartneType = businessPartnerTaxId.substring(0, 1);
            businessPartnerTaxId = businessPartnerTaxId.replaceAll("\\D+", "");
            businessPartnerTaxId = this.getValidReference(businessPartnerTaxId);
            businessPartnerTaxId = "%" + businessPartnerTaxId + "%";
            ArrayList<Object> businessPartnerParameters = new ArrayList<Object>();
            businessPartnerParameters.add(ibs.getAD_Client_ID());
            businessPartnerParameters.add(businessPartnerTaxId);
            businessPartnerParameters.add(businessPartnerTaxId);
            if (!Util.isEmpty((String)businessPartneType)) {
                businessPartneType = businessPartneType + "%";
                businessPartnerParameters.add(businessPartneType);
                businessPartnerParameters.add(businessPartneType);
                additionaWhereClause = " AND (UPPER(Value) LIKE ? OR UPPER(TaxID) LIKE ?)";
            }
            if ((businessPartnerId = DB.getSQLValue((String)ibs.get_TrxName(), (String)("SELECT C_BPartner_ID FROM C_BPartner WHERE AD_Client_ID = ? AND (Value LIKE ? OR TaxID LIKE ?)" + additionaWhereClause), businessPartnerParameters)) > 0) {
                info.setC_BPartner_ID(businessPartnerId);
            }
        }
        return info;
    }

    private String getValidReference(String reference) {
        if (!Util.isEmpty((String)reference)) {
            reference = reference.trim();
            if ((reference = reference.replace(".", "")).matches("[+-]?\\d*(\\.\\d+)?")) {
                Long longReference = null;
                try {
                    longReference = new Long(reference);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (longReference != null) {
                    reference = String.valueOf(longReference);
                }
            }
        }
        return reference;
    }
}

