/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.imp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class Venezuela_Transaction
extends BankTransactionAbstract {
    public static final String HEAD_REFERENCE_FIRST_LINE_FLAG = "NOCUENTA            FECHA   REFERENCIA   CONCEPTO                      CARGO             ABONO             BALANCE           TMCT";
    public static final String HEAD_BEGIN_BALANCE_FLAG = "SALDO INICIAL                 ";
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_AccountNo = "AccountNo";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_Memo = "Memo";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_Reconciliation_Code = "ReconciliationCode";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    private boolean isTransaction = false;

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty((String)(line = this.processValue(line)))) {
            return;
        }
        if (line.contains(HEAD_REFERENCE_FIRST_LINE_FLAG) || line.contains(HEAD_BEGIN_BALANCE_FLAG)) {
            this.isTransaction = false;
            return;
        }
        int index = 0;
        this.addValue(LINE_TRANSACTION_AccountNo, this.subString(line, index, index += 20));
        this.addValue(LINE_TRANSACTION_Date, this.getDate("ddMMyyyy", this.subString(line, index, index += 8)));
        this.addValue(LINE_TRANSACTION_ReferenceNo, this.subString(line, index, index += 13));
        this.addValue(LINE_TRANSACTION_Memo, this.subString(line, index, index += 30));
        BigDecimal debit = this.getAmountFromString(this.subString(line, index, index += 18));
        BigDecimal credit = this.getAmountFromString(this.subString(line, index, index += 18));
        if (debit != null && debit.doubleValue() != 0.0) {
            this.addValue(LINE_TRANSACTION_Amount, debit.negate());
        } else if (credit != null && credit.doubleValue() != 0.0) {
            this.addValue(LINE_TRANSACTION_Amount, credit);
        }
        this.addValue(LINE_TRANSACTION_Type, this.subString(line, index += 18, index += 2));
        this.addValue(LINE_TRANSACTION_Reconciliation_Code, this.subString(line, index, index += 4));
        this.isTransaction = true;
    }

    private BigDecimal getAmountFromString(String amountAsString) throws ParseException {
        DecimalFormat decimalFormat = new DecimalFormat("##################");
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setParseBigDecimal(true);
        BigDecimal amount = (BigDecimal)decimalFormat.parse(amountAsString);
        if (amount == null) {
            amount = Env.ZERO;
        }
        amount = amount.divide(Env.ONEHUNDRED);
        return amount;
    }

    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    public String getPayeeAccountNo() {
        return null;
    }

    public String getMemo() {
        return this.getString(LINE_TRANSACTION_Memo);
    }

    public String getTrxType() {
        return this.getString(LINE_TRANSACTION_Type);
    }

    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    protected String processValue(String value) {
        return value.replaceAll("[\t+^&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$><]", "");
    }

    public boolean isEndTransactionLine(String line) {
        return true;
    }

    public boolean isCompleteData() {
        return this.isTransaction;
    }

    public String getCurrency() {
        return null;
    }

    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    public String getTrxCode() {
        return this.getString(LINE_TRANSACTION_Reconciliation_Code);
    }

    public String getPayeeName() {
        return null;
    }

    public String getPayeeDescription() {
        return null;
    }
}

