/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.imp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class Tesoro_BankTransaction_v1
extends BankTransactionAbstract {
    public static final String HEAD_REFERENCE_FIRST_LINE_FLAG = "Fecha";
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_Memo = "Memo";
    public static final String LINE_TRANSACTION_Concept = "Concept";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    private static final String START_CHAR_VALUE = "\t";
    public static final String DEBT = "DR";
    public static final String CREDIT = "CR";
    private boolean isTransaction = false;

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty((String)line)) {
            return;
        }
        if (line.startsWith(HEAD_REFERENCE_FIRST_LINE_FLAG)) {
            this.isTransaction = false;
            return;
        }
        if (Util.isEmpty((String)(line = this.processValue(line)))) {
            return;
        }
        line = line.replaceAll("\"", "");
        AtomicInteger counter = new AtomicInteger();
        block7: for (String value : line.split(START_CHAR_VALUE)) {
            int currentPosition = counter.getAndIncrement();
            switch (currentPosition) {
                case 0: {
                    this.addValue(LINE_TRANSACTION_Date, this.getDate("dd/MM/yy", value));
                    continue block7;
                }
                case 1: {
                    this.addValue(LINE_TRANSACTION_Memo, value.replaceAll(",", "").trim());
                    continue block7;
                }
                case 2: {
                    this.addValue(LINE_TRANSACTION_ReferenceNo, this.getNumber('.', "#,###,###,###,###,###.##", value.replaceAll(",", "").trim()));
                    continue block7;
                }
                case 3: {
                    BigDecimal debit = this.getNumber('.', "#,###,###,###,###,###.##", value.trim());
                    if (debit == null || debit.compareTo(Env.ZERO) <= 0) continue block7;
                    this.addValue(LINE_TRANSACTION_Amount, debit.negate());
                    this.addValue(LINE_TRANSACTION_Type, DEBT);
                    continue block7;
                }
                case 4: {
                    BigDecimal credit = this.getNumber('.', "#,###,###,###,###,###.##", value.trim());
                    if (credit == null || credit.compareTo(Env.ZERO) <= 0) continue block7;
                    this.addValue(LINE_TRANSACTION_Amount, credit);
                    this.addValue(LINE_TRANSACTION_Type, CREDIT);
                    continue block7;
                }
            }
        }
        this.isTransaction = true;
    }

    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    public String getPayeeAccountNo() {
        return null;
    }

    public String getMemo() {
        return this.getString(LINE_TRANSACTION_Memo);
    }

    public String getTrxType() {
        return this.getString(LINE_TRANSACTION_Type);
    }

    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    protected String processValue(String value) {
        return value;
    }

    public boolean isEndTransactionLine(String line) {
        return true;
    }

    public boolean isCompleteData() {
        return this.isTransaction;
    }

    public String getCurrency() {
        return null;
    }

    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    public String getTrxCode() {
        return null;
    }

    public String getPayeeName() {
        return null;
    }

    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_Concept);
    }
}

