/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.imp;

import java.math.BigDecimal;
import java.text.ParseException;
import org.compiere.util.Util;
import org.spin.util.impexp.MT940BankTransaction;

public class Provincial_MT940_Transaction
extends MT940BankTransaction {
    private static final String LINE_TRANSACTION_VENDOR_PAYMENT_REF = "PNCASH-PAGO A PROV";
    private static final String LINE_TRANSACTION_PAYEE_CODE = "TPBW ";
    private static final String LINE_TRANSACTION_FBTT_DEBT = "C./A. IGTF MOV.D: ";
    private static final String LINE_TRANSACTION_FBTT_CREDIT = "C./A. IGTF MOV.H: ";
    private static final String LINE_TRANSACTION_PNCPRO = "PNCPRO";

    protected void setValue(String key, String value) throws ParseException {
        if (":20:".equals(key)) {
            this.addValue(":20:", this.getDate("ddMMyy", this.subString(value, 1, 6)));
        } else if (":25:".equals(key)) {
            this.addValue(key, value);
        } else if (":25C:".equals(key)) {
            this.addValue(key, this.getNumber('.', "#####", value));
        } else if (":NS:22".equals(key)) {
            this.addValue(key, this.subString(value, 0, 35));
        } else if (":NS:23".equals(key)) {
            this.addValue(key, this.subString(value, 0, 35));
        } else if (":60F:".equals(key)) {
            int index = 0;
            this.addValue(":60F:T|ype", this.subString(value, index++, index));
            this.addValue(":60F:|Date", this.getDate("yyMMdd", this.subString(value, index, index += 6)));
            this.addValue(":60F:|Currency", this.subString(value, index, index += 3));
            this.addValue(":60F:|Amount", this.getAmountFromString(this.subString(value, index, value.length())));
        } else if (":61:".equals(key)) {
            int index = 0;
            this.addValue(":61:|ValueDate", this.getDate("yyMMdd", this.subString(value, index, index += 6)));
            this.addValue(":61:|BookingDate", this.getDate("MMdd", this.subString(value, index, index += 4)));
            String trxType = this.subString(value, index++, index);
            this.addValue(":61:|Type", trxType);
            BigDecimal amount = this.getAmountFromString(this.subString(value, ++index, index += 15));
            if (!Util.isEmpty((String)trxType) && trxType.equals("D") && amount != null) {
                amount = amount.negate();
            }
            this.addValue(":61:|Amount", amount);
            this.addValue(":86:|TransactionCode", this.subString(value, ++index, index += 3));
            String reference = this.subString(value, index, index += 16);
            reference = this.getValidReference(reference);
            this.addValue(":86:|ReconciliationCode", reference);
            if (Util.isEmpty((String)this.getReferenceNo())) {
                this.addValue(":86:|ReferenceNumber", reference);
            }
        } else if (":NS:19".equals(key)) {
            this.addValue(":NS:19", this.getDate("hhmm", this.subString(value, 0, 4)));
        } else if (":86:".equals(key)) {
            this.addValue(":86:|TransactionTitle", value.trim());
            String reference = null;
            String payeeCode = null;
            if (value.startsWith(LINE_TRANSACTION_VENDOR_PAYMENT_REF)) {
                reference = this.subString(value, value.indexOf(LINE_TRANSACTION_VENDOR_PAYMENT_REF) + LINE_TRANSACTION_VENDOR_PAYMENT_REF.length(), value.length());
            } else if (value.startsWith(LINE_TRANSACTION_FBTT_DEBT)) {
                reference = this.subString(value, value.indexOf(LINE_TRANSACTION_FBTT_DEBT) + LINE_TRANSACTION_FBTT_DEBT.length(), value.length());
            } else if (value.startsWith(LINE_TRANSACTION_FBTT_CREDIT)) {
                reference = this.subString(value, value.indexOf(LINE_TRANSACTION_FBTT_CREDIT) + LINE_TRANSACTION_FBTT_CREDIT.length(), value.length());
            } else if (value.startsWith(LINE_TRANSACTION_PAYEE_CODE)) {
                int index = value.indexOf(LINE_TRANSACTION_PAYEE_CODE) + LINE_TRANSACTION_PAYEE_CODE.length();
                payeeCode = this.subString(value, index, index += 11);
                reference = this.subString(value, index, value.length());
            } else if (value.contains(LINE_TRANSACTION_PNCPRO)) {
                int index = 0;
                payeeCode = this.subString(value, index, index += 10);
                index = value.indexOf(LINE_TRANSACTION_PNCPRO) + LINE_TRANSACTION_PNCPRO.length();
                reference = this.subString(value, index, value.length());
            }
            if (!Util.isEmpty(payeeCode)) {
                payeeCode = payeeCode.trim();
            }
            if (!Util.isEmpty((String)(reference = this.getValidReference(reference)))) {
                this.addValue(":86:|ReferenceNumber", reference);
            }
            this.addValue(":86:|CounterpartyAccount", payeeCode);
        } else if (":62F:".equals(key)) {
            int index = 0;
            this.addValue(":62F:|Type", this.subString(value, index++, index));
            this.addValue(":62F:|Date", this.getDate("yyMMdd", this.subString(value, index, index += 6)));
            this.addValue(":62F:|Currency", this.subString(value, index, index += 3));
            this.addValue(":62F:|Amount", this.getAmountFromString(this.subString(value, index, value.length())));
        } else if (":64:".equals(key)) {
            int index = 0;
            this.addValue(":64:|Type", this.subString(value, index++, index));
            this.addValue(":64:|Date", this.getDate("yyMMdd", this.subString(value, index, index += 6)));
            this.addValue(":64:|Currency", this.subString(value, index, index += 3));
            this.addValue(":64:|Amount", this.getAmountFromString(this.subString(value, index, value.length())));
        } else if (":86:".equals(key)) {
            this.addValue(":86:", this.subString(value, 0, 65));
        }
    }

    private String getValidReference(String reference) {
        if (!Util.isEmpty((String)reference)) {
            reference = reference.trim();
            if ((reference = reference.replace(".", "")).matches("[+-]?\\d*(\\.\\d+)?")) {
                Long longReference = null;
                try {
                    longReference = new Long(reference);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (longReference != null) {
                    reference = String.valueOf(longReference);
                }
            }
        }
        return reference;
    }

    private BigDecimal getAmountFromString(String amountAsString) throws ParseException {
        char separator = '.';
        if (amountAsString.lastIndexOf(46) > 0) {
            separator = ',';
        }
        return this.getNumber(separator, "########.##", amountAsString);
    }

    public String getMemo() {
        return this.getString(":86:|TransactionTitle");
    }

    public String getCheckNo() {
        return this.getString(":86:|ReconciliationCode");
    }

    public String getReferenceNo() {
        return this.getString(":86:|ReferenceNumber");
    }
}

