/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.imp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class Provincial_ISO_4217_Transaction
extends BankTransactionAbstract {
    public static final String VALID_LINE_FLAG = "22,";
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_ValueDate = "ValueDate";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_Memo = "Memo";
    public static final String LINE_TRANSACTION_Concept = "Concept";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    public static final String LINE_TRANSACTION_TrxCode = "TrxCode";
    private static final String START_CHAR_VALUE = ",";
    public static final String DEBT = "1";
    public static final String CREDIT = "2";
    private boolean isTransaction = false;

    public void parseLine(String line) throws Exception {
        if (!line.startsWith(VALID_LINE_FLAG)) {
            this.isTransaction = false;
            return;
        }
        if (Util.isEmpty((String)(line = this.processValue(line)))) {
            this.isTransaction = false;
            return;
        }
        line = line.replaceAll("\"", "");
        AtomicInteger counter = new AtomicInteger();
        block9: for (String value : line.split(START_CHAR_VALUE)) {
            int currentPosition = counter.getAndIncrement();
            switch (currentPosition) {
                case 3: {
                    this.addValue(LINE_TRANSACTION_Date, this.getDate("yyMMdd", value));
                    continue block9;
                }
                case 4: {
                    this.addValue(LINE_TRANSACTION_ValueDate, this.getDate("yyMMdd", value));
                    continue block9;
                }
                case 6: {
                    this.addValue(LINE_TRANSACTION_TrxCode, value);
                    continue block9;
                }
                case 7: {
                    this.addValue(LINE_TRANSACTION_Type, value);
                    continue block9;
                }
                case 8: {
                    BigDecimal amount = this.getAmountFromString(value);
                    if (this.getTrxType().equals(DEBT)) {
                        amount = amount.negate();
                    }
                    this.addValue(LINE_TRANSACTION_Amount, amount);
                    continue block9;
                }
                case 9: {
                    this.addValue(LINE_TRANSACTION_ReferenceNo, value);
                    continue block9;
                }
                case 10: {
                    this.addValue(LINE_TRANSACTION_Memo, value);
                    continue block9;
                }
            }
        }
        this.isTransaction = true;
    }

    private BigDecimal getAmountFromString(String amountAsString) throws ParseException {
        DecimalFormat decimalFormat = new DecimalFormat("##################");
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setParseBigDecimal(true);
        BigDecimal amount = (BigDecimal)decimalFormat.parse(amountAsString);
        if (amount == null) {
            amount = Env.ZERO;
        }
        amount = amount.divide(Env.ONEHUNDRED);
        return amount;
    }

    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    public String getPayeeAccountNo() {
        return null;
    }

    public String getMemo() {
        return this.getString(LINE_TRANSACTION_Memo);
    }

    public String getTrxType() {
        return this.getString(LINE_TRANSACTION_Type);
    }

    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    protected String processValue(String value) {
        return value;
    }

    public boolean isEndTransactionLine(String line) {
        return true;
    }

    public boolean isCompleteData() {
        return this.isTransaction;
    }

    public String getCurrency() {
        return null;
    }

    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_ValueDate);
    }

    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    public String getTrxCode() {
        return null;
    }

    public String getPayeeName() {
        return this.getString(LINE_TRANSACTION_TrxCode);
    }

    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_Concept);
    }
}

