/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.imp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class Banplus_Transaction
extends BankTransactionAbstract {
    public static final String HEAD_REFERENCE_FIRST_LINE_FLAG = "\"Fecha\"\t\"Referencia\"\t\"Descripci";
    public static final String HEAD_BEGIN_BALANCE_FLAG = "\t\t\"Saldo Inicial\"";
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_Memo = "Memo";
    public static final String LINE_TRANSACTION_Concept = "Concept";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    private static final char START_CHAR_VALUE = '\t';
    public static final String DEBT = "DR";
    public static final String CREDIT = "CR";
    private boolean isTransaction = false;

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty((String)line)) {
            return;
        }
        if (line.contains(HEAD_REFERENCE_FIRST_LINE_FLAG) || line.contains(HEAD_BEGIN_BALANCE_FLAG)) {
            this.isTransaction = false;
            return;
        }
        if (Util.isEmpty((String)(line = this.processValue(line)))) {
            return;
        }
        line = line.replaceAll("\"", "");
        this.addValue(LINE_TRANSACTION_Date, this.getDate("dd/MM/yyyy", this.subString(line, 0, 10)));
        int startIndex = 0;
        int endIndex = 0;
        int initPosition = 1;
        String value = null;
        startIndex = line.indexOf(9) + initPosition;
        endIndex = line.substring(startIndex).indexOf(9) + startIndex + initPosition;
        value = this.subString(line, startIndex, endIndex);
        if (!Util.isEmpty((String)value)) {
            this.addValue(LINE_TRANSACTION_ReferenceNo, value.replaceAll("\t", ""));
        }
        if (!Util.isEmpty((String)(value = this.subString(line = line.substring(endIndex), startIndex = 0, endIndex = line.indexOf(9) + initPosition)))) {
            this.addValue(LINE_TRANSACTION_Memo, value.replaceAll("\t", ""));
        }
        if (!Util.isEmpty((String)(value = this.subString(line = line.substring(endIndex), startIndex = 0, endIndex = line.indexOf(9) + initPosition)))) {
            this.addValue(LINE_TRANSACTION_Concept, value.replaceAll("\t", ""));
        }
        line = line.substring(endIndex);
        startIndex = 0;
        endIndex = line.indexOf(9) + initPosition;
        BigDecimal debit = this.getNumber('.', "##################", this.subString(line, startIndex, endIndex));
        line = line.substring(endIndex);
        startIndex = 0;
        endIndex = line.indexOf(9) + initPosition;
        BigDecimal credit = this.getNumber('.', "##################", this.subString(line, startIndex, endIndex));
        if (debit != null && debit.doubleValue() != 0.0) {
            this.addValue(LINE_TRANSACTION_Amount, debit.negate());
            this.addValue(LINE_TRANSACTION_Type, DEBT);
        } else if (credit != null && credit.doubleValue() != 0.0) {
            this.addValue(LINE_TRANSACTION_Amount, credit);
            this.addValue(LINE_TRANSACTION_Type, CREDIT);
        }
        this.isTransaction = true;
    }

    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    public String getPayeeAccountNo() {
        return null;
    }

    public String getMemo() {
        return this.getString(LINE_TRANSACTION_Memo);
    }

    public String getTrxType() {
        return this.getString(LINE_TRANSACTION_Type);
    }

    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    protected String processValue(String value) {
        return value;
    }

    public boolean isEndTransactionLine(String line) {
        return true;
    }

    public boolean isCompleteData() {
        return this.isTransaction;
    }

    public String getCurrency() {
        return null;
    }

    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    public String getTrxCode() {
        return null;
    }

    public String getPayeeName() {
        return null;
    }

    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_Concept);
    }
}

