/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.imp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.Util;
import org.spin.util.impexp.BankTransactionAbstract;

public class BNC_Transaction
extends BankTransactionAbstract {
    public static final String HEAD_REFERENCE_FIRST_LINE_FLAG = "Fecha\tReferencia\t Cod";
    public static final String HEAD_BEGIN_BALANCE_FLAG = "\t\t\t\t Saldo Inicial";
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_Description = "Description";
    public static final String LINE_TRANSACTION_Memo = "Memo";
    public static final String LINE_TRANSACTION_Code = "Code";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_ReferenceNo2 = "ReferenceNo2";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    private static final char START_CHAR_VALUE = '\t';
    private boolean isTransaction = false;

    public void parseLine(String line) throws Exception {
        if (Util.isEmpty((String)line)) {
            return;
        }
        if (line.startsWith(HEAD_REFERENCE_FIRST_LINE_FLAG) || line.contains(HEAD_BEGIN_BALANCE_FLAG)) {
            this.isTransaction = false;
            return;
        }
        if (Util.isEmpty((String)(line = this.processValue(line)))) {
            return;
        }
        line = line.replaceAll("\"", "");
        this.addValue(LINE_TRANSACTION_Date, this.getDate("MM/dd/yyyy", this.subString(line, 0, 10)));
        int startIndex = 0;
        int endIndex = 0;
        int initPosition = 1;
        String value = null;
        startIndex = line.indexOf(9) + initPosition;
        endIndex = line.substring(startIndex).indexOf(9) + startIndex + initPosition;
        value = this.subString(line, startIndex, endIndex);
        if (!Util.isEmpty((String)value)) {
            this.addValue(LINE_TRANSACTION_ReferenceNo, value.replaceAll(";", "").trim());
        }
        if (!Util.isEmpty((String)(value = this.subString(line = line.substring(endIndex), startIndex = 0, endIndex = line.indexOf(9) + initPosition)))) {
            this.addValue(LINE_TRANSACTION_Code, value.replaceAll(";", "").trim());
        }
        if (!Util.isEmpty((String)(value = this.subString(line = line.substring(endIndex), startIndex = 0, endIndex = line.indexOf(9) + initPosition)))) {
            this.addValue(LINE_TRANSACTION_Type, value.replaceAll(";", "").trim());
        }
        if (!Util.isEmpty((String)(value = this.subString(line = line.substring(endIndex), startIndex = 0, endIndex = line.indexOf(9) + initPosition)))) {
            this.addValue(LINE_TRANSACTION_Description, value.replaceAll(";", "").trim());
        }
        if (!Util.isEmpty((String)(value = this.subString(line = line.substring(endIndex), startIndex = 0, endIndex = line.indexOf(9) + initPosition)))) {
            this.addValue(LINE_TRANSACTION_Memo, value.replaceAll(";", "").trim());
        }
        line = line.substring(endIndex);
        startIndex = 0;
        endIndex = line.indexOf(9) + initPosition;
        BigDecimal debit = null;
        value = this.subString(line, startIndex, endIndex);
        if (!Util.isEmpty((String)value.trim())) {
            debit = this.getNumber('.', "#,###,###,###,###,###.##", value);
        }
        line = line.substring(endIndex);
        startIndex = 0;
        endIndex = line.indexOf(9) + initPosition;
        BigDecimal credit = null;
        value = this.subString(line, startIndex, endIndex);
        if (!Util.isEmpty((String)value.trim())) {
            credit = this.getNumber('.', "#,###,###,###,###,###.##", value);
        }
        if (debit != null && debit.doubleValue() != 0.0) {
            this.addValue(LINE_TRANSACTION_Amount, debit.negate());
        } else if (credit != null && credit.doubleValue() != 0.0) {
            this.addValue(LINE_TRANSACTION_Amount, credit);
        }
        line = line.substring(endIndex);
        startIndex = 0;
        endIndex = line.indexOf(9) + initPosition;
        value = this.subString(line, startIndex, endIndex);
        if (!Util.isEmpty((String)value)) {
            this.addValue(LINE_TRANSACTION_ReferenceNo2, value.replaceAll(";", "").trim());
        }
        this.isTransaction = true;
    }

    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    public String getPayeeAccountNo() {
        return null;
    }

    public String getMemo() {
        return this.getString(LINE_TRANSACTION_Memo);
    }

    public String getTrxType() {
        return this.getString(LINE_TRANSACTION_Type);
    }

    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    protected String processValue(String value) {
        return value;
    }

    public boolean isEndTransactionLine(String line) {
        return true;
    }

    public boolean isCompleteData() {
        return this.isTransaction;
    }

    public String getCurrency() {
        return null;
    }

    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    public String getTrxCode() {
        return this.getString(LINE_TRANSACTION_Code);
    }

    public String getPayeeName() {
        return null;
    }

    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_Memo);
    }
}

