/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class Venezuela_v1
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(Venezuela_v1.class);
    private final String SHORT_DATE_FORMAT = "dd/MM/yyyy";
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)bankAccount.getC_Currency_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            MOrg org = MOrg.get((Properties)Env.getCtx(), (int)orgInfo.getAD_Org_ID());
            MClient client = MClient.get((Properties)orgInfo.getCtx(), (int)orgInfo.getAD_Client_ID());
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date now = new Date(System.currentTimeMillis());
            String sequence = this.rightPadding("HEADER", 8, " ");
            String bankClientNo = bankAccount.get_ValueAsString("BankClientNo");
            if (Util.isEmpty((String)bankClientNo)) {
                bankClientNo = bank.get_ValueAsString("BankClientNo");
            }
            if (!Util.isEmpty((String)bankClientNo)) {
                bankClientNo = this.processValue(bankClientNo);
                bankClientNo = this.leftPadding(bankClientNo, 8, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@BankClientNo@ @NotFound@"));
            }
            String paymentRequestNo = this.leftPadding(this.processValue(paySelection.getDocumentNo()), 8, "0", true);
            String orgPersonType = "";
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            if (!Util.isEmpty((String)orgTaxId)) {
                orgPersonType = orgTaxId.substring(0, 1);
                orgTaxId = orgTaxId.replaceAll("\\D+", "");
                orgTaxId = this.leftPadding(orgTaxId, 9, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getName())));
            }
            String clientName = client.getName();
            if (orgInfo.get_ValueAsBoolean("IsDefinedAsClient")) {
                clientName = org.getName();
            }
            clientName = this.processValue(clientName);
            clientName = this.rightPadding(clientName, 35, " ", true);
            String paymentDate = dateFormat.format(paySelection.getPayDate());
            String nowAsString = dateFormat.format(now);
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = this.rightPadding(bankAccountNo, 20, "0", true);
            StringBuffer header = new StringBuffer();
            header.append(sequence).append(paymentRequestNo).append(bankClientNo).append(orgPersonType).append(orgTaxId).append(paymentDate).append(nowAsString);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            for (MPaySelectionCheck paySelectionCheck : checks) {
                MBPartner bpartner = MBPartner.get((Properties)paySelectionCheck.getCtx(), (int)paySelectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo(paySelectionCheck, true);
                if (bpAccount != null) {
                    StringBuffer line = new StringBuffer();
                    String constant = this.rightPadding("DEBITO", 8, " ");
                    String documentNo = this.processValue(paySelectionCheck.getDocumentNo());
                    documentNo = this.leftPadding(documentNo, 8, "0", true);
                    String constant2 = this.leftPadding("", 2, "0");
                    String amountAsString = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(".", ",");
                    if (amountAsString.length() > 18) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    } else {
                        amountAsString = this.leftPadding(amountAsString, 18, "0", true);
                    }
                    String iSOCode = currency.getISO_Code();
                    String constant3 = this.rightPadding("40", 3, "");
                    String constant4 = this.rightPadding("CREDITO", 8, " ");
                    String bPPersonType = "";
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPPersonType = bPTaxId.substring(0, 1);
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 30, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String accountType = this.leftPadding("", 2, "0");
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.rightPadding(bPAccountNo, 20, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    MBank bpBank = MBank.get((Properties)Env.getCtx(), (int)bpAccount.getC_Bank_ID());
                    String paymentType = "10";
                    if (!(Util.isEmpty((String)bank.getSwiftCode()) || Util.isEmpty((String)bpBank.getSwiftCode()) || bank.getSwiftCode().equals(bpBank.getSwiftCode()))) {
                        paymentType = "00";
                    }
                    String bPSwiftCode = bpBank.getSwiftCode();
                    bPSwiftCode = this.rightPadding(bPSwiftCode, 10, " ", true);
                    String constantSpace = this.rightPadding("", 59, " ");
                    line.append(CRLF).append(constant).append(documentNo).append(orgPersonType).append(orgTaxId).append(clientName).append(paymentDate).append(constant2).append(bankAccountNo).append(amountAsString).append(iSOCode).append(constant3).append(CRLF).append(constant4).append(documentNo).append(bPPersonType).append(bPTaxId).append(bPName).append(accountType).append(bPAccountNo).append(amountAsString).append(paymentType).append(bPSwiftCode).append(constantSpace);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                    continue;
                }
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
            }
            String constant = this.rightPadding("TOTAL", 8, " ");
            String constant2 = this.leftPadding(String.valueOf(checks.size()), 5, "0");
            String constant3 = this.leftPadding(String.valueOf(checks.size()), 5, "0");
            String totalAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", ",");
            if (totalAsString.length() > 18) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
            } else {
                totalAsString = this.leftPadding(totalAsString, 18, "0", true);
            }
            StringBuffer footer = new StringBuffer();
            footer.append(CRLF).append(constant).append(constant2).append(constant3).append(totalAsString);
            this.writeLine(footer.toString());
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFileAsVerification(MBankAccount bankAccount, List<MPayment> payments, File file, StringBuffer error) {
        if (payments == null || payments.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, bankAccount, payments, "CS");
            MOrg org = MOrg.get((Properties)bankAccount.getCtx(), (int)bankAccount.getAD_Org_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)bankAccount.getCtx(), (int)bankAccount.getAD_Org_ID(), (String)bankAccount.get_TrxName());
            String constant = "0";
            String organizationType = "";
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            if (!Util.isEmpty((String)orgTaxId)) {
                organizationType = orgTaxId.substring(0, 1);
                orgTaxId = orgTaxId.replaceAll("\\D+", "");
                orgTaxId = this.leftPadding(orgTaxId, 9, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getValue() + " - " + org.getName())));
            }
            String paymentsGenerated = this.leftPadding(String.valueOf(payments.size()), 5, "0", true);
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.replace(" ", "");
            bankAccountNo = this.rightPadding(bankAccountNo, 20, "0", true);
            BigDecimal totalAmount = this.getTotalAmount(payments);
            String totalAsString = String.format("%.2f", totalAmount.abs()).replace(".", "").replace(",", "");
            if (totalAsString.length() > 17) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
            } else {
                totalAsString = this.leftPadding(totalAsString, 17, "0", true);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            StringBuffer header = new StringBuffer();
            header.append(constant).append(organizationType).append(orgTaxId).append(paymentsGenerated).append(bankAccountNo).append(totalAsString);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            for (MPayment payment : payments) {
                MBPBankAccount bpAccount = this.getBPAccountInfo(payment, true);
                MBPartner bpartner = MBPartner.get((Properties)payment.getCtx(), (int)payment.getC_BPartner_ID());
                constant = "1";
                String bPName = this.processValue(bpAccount.getA_Name());
                if (Optional.ofNullable(bPName).isPresent()) {
                    bPName = this.rightPadding(bPName, 60, " ", true);
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                String checkNo = this.processValue(payment.getCheckNo());
                checkNo = checkNo.replaceAll("\\D+", "");
                checkNo = this.leftPadding(checkNo, 8, "0", true);
                String amountAsString = String.format("%.2f", payment.getPayAmt().abs()).replace(".", "").replace(",", "");
                if (amountAsString.length() > 17) {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                } else {
                    amountAsString = this.leftPadding(amountAsString, 17, "0", true);
                }
                String paymentDate = dateFormat.format(payment.getDateTrx());
                String constant2 = "S";
                String constant3 = this.leftPadding("", 80, " ");
                StringBuffer line = new StringBuffer();
                line.append(CRLF).append(constant).append(bankAccountNo).append(bPName).append(checkNo).append(amountAsString).append(paymentDate).append(constant2).append(constant3);
                s_log.fine("Write Line");
                this.writeLine(line.toString());
            }
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private BigDecimal getTotalAmount(List<MPayment> payments) {
        BigDecimal totalAmount = Env.ZERO;
        for (MPayment payment : payments) {
            totalAmount = totalAmount.add(payment.getPayAmt());
        }
        return totalAmount;
    }
}

