/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MOrg;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;
import org.erpya.lve.bank.exp.MercantilNominaFacil;

public class VenezuelaNomina
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(MercantilNominaFacil.class);
    private final String HEADER_SHORT_DATE_FORMAT = "dd/MM/yy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            MOrg org = MOrg.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID());
            String headerBankClientNo = bankAccount.get_ValueAsString("BankClientNo");
            if (Util.isEmpty((String)headerBankClientNo)) {
                headerBankClientNo = bank.get_ValueAsString("BankClientNo");
            }
            if (!Util.isEmpty((String)headerBankClientNo)) {
                headerBankClientNo = this.processValue(headerBankClientNo);
                headerBankClientNo = this.leftPadding(headerBankClientNo, 5, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@BankClientNo@ @NotFound@"));
            }
            String lineBankClientNo = this.leftPadding(headerBankClientNo, 6, "0", true);
            String orgName = org.getName();
            orgName = this.rightPadding(orgName, 41, " ", true);
            String constant = "01";
            String totalAmtAsString = String.format("%.2f", this.getTotalAmount(checks).abs()).replace(".", "").replace(",", "");
            if (totalAmtAsString.length() > 15) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @InValid@"));
            }
            totalAmtAsString = this.leftPadding(totalAmtAsString, 13, "0", true);
            SimpleDateFormat shortFormat = new SimpleDateFormat("dd/MM/yy");
            String payDate = shortFormat.format(paySelection.getPayDate());
            String bankAccountNo = this.processValue(bankAccount.getAccountNo()).trim();
            bankAccountNo = bankAccountNo.replace(" ", "");
            StringBuffer header = new StringBuffer();
            header.append("").append(orgName).append(bankAccountNo).append(constant).append(payDate).append(totalAmtAsString).append(headerBankClientNo);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                if (bpAccount != null) {
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    String constantLine = "1";
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = this.leftPadding(bPTaxId, 10, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 40, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 11) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Valid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    amountAsString = this.leftPadding(amountAsString, 11, "0", true);
                    String accountType = "0";
                    if (!Util.isEmpty((String)bpAccount.getBankAccountType()) && bpAccount.getBankAccountType().equals("S")) {
                        accountType = "1";
                    }
                    String lineConstant = "770";
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(constantLine).append(bPAccountNo).append(amountAsString).append(accountType).append(lineConstant).append(bPName).append(bPTaxId).append(lineBankClientNo);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    @Override
    public String processValue(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$,;*/\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00bf\u00a1]", "");
    }

    private BigDecimal getTotalAmount(List<MPaySelectionCheck> checks) {
        BigDecimal totalAmount = Env.ZERO;
        for (MPaySelectionCheck payment : checks) {
            totalAmount = totalAmount.add(payment.getPayAmt());
        }
        return totalAmount;
    }
}

