/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class Provincial
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(Provincial.class);
    private final String SEPARATOR = " ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                if (bpAccount != null) {
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        String bpTaxIdChar = bPTaxId.substring(0, 1);
                        bPTaxId = bPTaxId.substring(1, bPTaxId.length());
                        bPTaxId = this.leftPadding(bPTaxId, 12, "0", true);
                        bPTaxId = bpTaxIdChar + bPTaxId;
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 35, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 35, " ", true);
                    String documentNo = this.processValue(payselectionCheck.getDocumentNo());
                    documentNo = documentNo.replaceAll("\\D+", "");
                    documentNo = this.leftPadding(documentNo, 8, "0", true);
                    if (Optional.ofNullable(bPAccountNo).isPresent() && Optional.ofNullable(bPName).isPresent()) {
                        String amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                        if (amountAsString.length() > 13) {
                            this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                        } else {
                            amountAsString = this.leftPadding(amountAsString, 13, "0", true);
                        }
                        StringBuffer line = new StringBuffer();
                        line.append(bPTaxId).append(" ").append(bPAccountNo).append(" ").append(amountAsString).append(" ").append(documentNo).append(" ").append(bPName).append(" ").append(bPEmail).append(Env.NL);
                        s_log.fine("Write Line");
                        this.writeLine(line.toString());
                    }
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFileAsVerification(MBankAccount bankAccount, List<MPayment> payments, File file, StringBuffer error) {
        if (payments == null || payments.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, bankAccount, payments, "CS");
            s_log.fine("Iterate Payments");
            payments.stream().forEach(payment -> {
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPayment)payment, true);
                MBPartner bpartner = MBPartner.get((Properties)payment.getCtx(), (int)payment.getC_BPartner_ID());
                MOrg org = MOrg.get((Properties)payment.getCtx(), (int)payment.getAD_Org_ID());
                MOrgInfo orgInfo = MOrgInfo.get((Properties)payment.getCtx(), (int)payment.getAD_Org_ID(), (String)payment.get_TrxName());
                String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
                if (!Util.isEmpty((String)orgTaxId)) {
                    orgTaxId = orgTaxId.replace("-", "").trim();
                    String organizationType = orgTaxId.substring(0, 1);
                    orgTaxId = orgTaxId.replaceAll("\\D+", "");
                    orgTaxId = this.leftPadding(orgTaxId, 15, "0", true);
                    orgTaxId = organizationType + orgTaxId;
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getValue() + " - " + org.getName())));
                }
                String bPTaxId = bpAccount.getA_Ident_SSN();
                if (!Util.isEmpty((String)bPTaxId)) {
                    bPTaxId = bPTaxId.replace("-", "").trim();
                    String bpTaxIdChar = bPTaxId.substring(0, 1);
                    bPTaxId = bPTaxId.substring(1, bPTaxId.length());
                    bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    bPTaxId = bpTaxIdChar + bPTaxId;
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                String bPName = this.processValue(bpAccount.getA_Name());
                if (Optional.ofNullable(bPName).isPresent()) {
                    bPName = this.rightPadding(bPName, 35, " ", true);
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                String checkNo = this.processValue(payment.getCheckNo());
                checkNo = checkNo.replaceAll("\\D+", "");
                checkNo = this.leftPadding(checkNo, 8, "0", true);
                String amountAsString = String.format("%.2f", payment.getPayAmt().abs()).replace(".", "").replace(",", "");
                if (amountAsString.length() > 15) {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                } else {
                    amountAsString = this.leftPadding(amountAsString, 15, "0", true);
                }
                MPaymentBatch paymentBatch = (MPaymentBatch)payment.getC_PaymentBatch();
                if (paymentBatch == null) {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_PaymentBatch_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                String batchDocumentNo = paymentBatch.getDocumentNo();
                batchDocumentNo = this.leftPadding(batchDocumentNo, 8, "0", true);
                StringBuffer line = new StringBuffer();
                line.append(checkNo).append(bPTaxId).append(orgTaxId).append(bPName).append(amountAsString).append(batchDocumentNo).append(Env.NL);
                s_log.fine("Write Line");
                this.writeLine(line.toString());
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }
}

