/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;
import org.erpya.lve.bank.exp.MercantilNomina;

public class MercantilNominaFacil
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(MercantilNomina.class);
    private final String HEADER_SHORT_DATE_FORMAT = "yyyyMMdd";
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            String totalAmtAsString;
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            MOrg org = MOrg.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            String bankSwift = "";
            if (!Util.isEmpty((String)bank.getSwiftCode())) {
                bankSwift = bank.getSwiftCode();
                bankSwift = this.rightPadding(bankSwift, 12, " ", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_Bank_ID@: " + bank.getName() + " @SwiftCode@ @NotFound@")));
            }
            String paymentRequestNo = this.processValue(paySelection.getDocumentNo());
            paymentRequestNo = this.leftPadding(paymentRequestNo, 15, "0", true);
            String identifyRequestNo = this.processValue(paySelection.getDocumentNo());
            identifyRequestNo = this.leftPadding(identifyRequestNo, 8, "0", true);
            String productType = "NOMIN";
            String paymentTypeConstant = this.leftPadding("222", 10, "0");
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            String organizationType = "";
            if (!Util.isEmpty((String)orgTaxId)) {
                orgTaxId = orgTaxId.replace("-", "").trim();
                organizationType = orgTaxId.substring(0, 1).toUpperCase();
                orgTaxId = orgTaxId.replaceAll("\\D+", "");
                orgTaxId = this.leftPadding(orgTaxId, 15, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getValue() + " - " + org.getName())));
            }
            String payGenerated = String.valueOf(checks.size());
            payGenerated = this.leftPadding(payGenerated, 8, "0", true);
            if (payGenerated.length() > 8) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@Qty@ > @InValid@"));
            }
            if ((totalAmtAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", "").replace(",", "")).length() > 17) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @InValid@"));
            }
            totalAmtAsString = this.leftPadding(totalAmtAsString, 17, "0", true);
            SimpleDateFormat shortFormat = new SimpleDateFormat("yyyyMMdd");
            String payDate = shortFormat.format(paySelection.getPayDate());
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.replace(" ", "");
            bankAccountNo = this.rightPadding(bankAccountNo, 20, "0", true);
            StringBuffer header = new StringBuffer();
            header.append("1").append(bankSwift).append(paymentRequestNo).append(productType).append(paymentTypeConstant).append(organizationType).append(orgTaxId).append(payGenerated).append(totalAmtAsString).append(payDate).append(bankAccountNo).append(this.leftPadding("", 7, "0")).append(identifyRequestNo).append(this.leftPadding("", 4, "0")).append(this.leftPadding("", 8, "0")).append(this.leftPadding("", 261, "0")).append(CRLF);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                if (bpAccount != null) {
                    String bPAccountNo;
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    String personType = "";
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        personType = bPTaxId.substring(0, 1).toUpperCase();
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = this.leftPadding(bPTaxId, 15, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    MBank bpBank = MBank.get((Properties)Env.getCtx(), (int)bpAccount.getC_Bank_ID());
                    String paymentType = "1";
                    if (!(Util.isEmpty((String)bank.getSwiftCode()) || Util.isEmpty((String)bpBank.getSwiftCode()) || bank.getSwiftCode().equals(bpBank.getSwiftCode()))) {
                        paymentType = "3";
                    }
                    if (Optional.ofNullable(bPAccountNo = this.processValue(bpAccount.getAccountNo())).isPresent()) {
                        bPAccountNo = this.rightPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPValue = bpartner.getValue();
                    bPValue = bPValue.replace("-", "").trim();
                    bPValue = this.rightPadding(bPValue, 16, " ", true);
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 60, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String paymentDescription = this.processValue(payselectionCheck.getDocumentNo());
                    if (!Util.isEmpty((String)paySelection.getName())) {
                        paymentDescription = paymentDescription + " " + this.processValue(paySelection.getName());
                    }
                    if (!Util.isEmpty((String)paySelection.getDescription())) {
                        paymentDescription = paymentDescription + " " + this.processValue(paySelection.getDescription());
                    }
                    paymentDescription = this.rightPadding(paymentDescription, 80, " ", true);
                    String amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 17) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Valid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    amountAsString = this.leftPadding(amountAsString, 17, "0", true);
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 50, " ", true);
                    StringBuffer line = new StringBuffer();
                    line.append("2").append(personType).append(bPTaxId).append(paymentType).append(this.leftPadding("", 12, "0")).append(this.leftPadding("", 30, " ")).append(bPAccountNo).append(amountAsString).append(bPValue).append(paymentTypeConstant).append(this.leftPadding("", 3, "0")).append(bPName).append(this.leftPadding("", 15, "0")).append(bPEmail).append(this.leftPadding("", 4, "0")).append(this.leftPadding("", 30, " ")).append(paymentDescription).append(this.leftPadding("", 35, "0")).append(CRLF);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFileAsVerification(MBankAccount bankAccount, List<MPayment> payments, File file, StringBuffer error) {
        if (payments == null || payments.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, bankAccount, payments, "CS");
            MPayment firstPayment = payments.get(0);
            MOrg org = MOrg.get((Properties)bankAccount.getCtx(), (int)bankAccount.getAD_Org_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)bankAccount.getCtx(), (int)bankAccount.getAD_Org_ID(), (String)bankAccount.get_TrxName());
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            String constant = "1";
            MPaymentBatch paymentBatch = (MPaymentBatch)firstPayment.getC_PaymentBatch();
            if (paymentBatch == null) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@C_PaymentBatch_ID@ @NotFound@"));
            }
            String batchDocumentNo = paymentBatch.getDocumentNo();
            batchDocumentNo = batchDocumentNo.replaceAll("\\D+", "");
            batchDocumentNo = this.leftPadding(batchDocumentNo, 15, "0", true);
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
            SimpleDateFormat timeFormat = new SimpleDateFormat("hhmmss");
            Timestamp currentDate = new Timestamp(System.currentTimeMillis());
            String processDate = dateFormat.format(currentDate);
            String processTime = timeFormat.format(currentDate);
            String organizationType = "";
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            if (!Util.isEmpty((String)orgTaxId)) {
                organizationType = orgTaxId.substring(0, 1);
                orgTaxId = orgTaxId.replaceAll("\\D+", "");
                orgTaxId = this.leftPadding(orgTaxId, 15, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getValue() + " - " + org.getName())));
            }
            String paymentsGenerated = this.leftPadding(String.valueOf(payments.size()), 7, "0", true);
            BigDecimal totalAmount = this.getTotalAmount(payments);
            String totalAsString = String.format("%.2f", totalAmount.abs()).replace(".", "").replace(",", "");
            if (totalAsString.length() > 15) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
            } else {
                totalAsString = this.leftPadding(totalAsString, 15, "0", true);
            }
            String constant2 = this.leftPadding("", 142, " ");
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.replace(" ", "");
            bankAccountNo = this.rightPadding(bankAccountNo, 20, "0", true);
            int paymentDaysDue = bank.get_ValueAsInt("PaymentDaysDue");
            StringBuffer header = new StringBuffer();
            header.append(constant).append(batchDocumentNo).append(processDate).append(processTime).append(organizationType).append(orgTaxId).append(paymentsGenerated).append(totalAsString).append(constant2);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            for (MPayment payment : payments) {
                String amountAsString;
                MBPBankAccount bpAccount = this.getBPAccountInfo(payment, true);
                MBPartner bpartner = MBPartner.get((Properties)payment.getCtx(), (int)payment.getC_BPartner_ID());
                constant = "2";
                String checkNo = this.processValue(payment.getCheckNo());
                checkNo = checkNo.replaceAll("\\D+", "");
                checkNo = this.leftPadding(checkNo, 11, "0", true);
                String bPName = this.processValue(bpAccount.getA_Name());
                if (Optional.ofNullable(bPName).isPresent()) {
                    bPName = this.rightPadding(bPName, 120, " ", true);
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                int validStatus = 0;
                BigDecimal paymentAmount = payment.getPayAmt();
                if (!payment.getDocStatus().equals("CO") && !payment.getDocStatus().equals("CL")) {
                    validStatus = 1;
                    paymentAmount = Env.ZERO;
                }
                if ((amountAsString = String.format("%.2f", paymentAmount.abs()).replace(".", "").replace(",", "")).length() > 15) {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                } else {
                    amountAsString = this.leftPadding(amountAsString, 15, "0", true);
                }
                String paymentDate = dateFormat.format(payment.getDateTrx());
                String paymentDueDate = dateFormat.format(TimeUtil.addDays((Timestamp)payment.getDateTrx(), (int)paymentDaysDue));
                String bPTaxId = bpAccount.getA_Ident_SSN();
                if (!Util.isEmpty((String)bPTaxId)) {
                    bPTaxId = bPTaxId.replace("-", "").trim();
                    String bpTaxIdChar = bPTaxId.substring(0, 1);
                    bPTaxId = bPTaxId.substring(1, bPTaxId.length());
                    bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    bPTaxId = bpTaxIdChar + bPTaxId;
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                constant2 = this.leftPadding("", 26, " ");
                StringBuffer line = new StringBuffer();
                line.append(CRLF).append(constant).append(bankAccountNo).append(checkNo).append(bPName).append(amountAsString).append(paymentDate).append(paymentDueDate).append(validStatus).append(constant2);
                s_log.fine("Write Line");
                this.writeLine(line.toString());
            }
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private BigDecimal getTotalAmount(List<MPayment> payments) {
        BigDecimal totalAmount = Env.ZERO;
        for (MPayment payment : payments) {
            totalAmount = totalAmount.add(payment.getPayAmt());
        }
        return totalAmount;
    }

    @Override
    public void openFileWriter(File file, List<MPaySelectionCheck> checks) {
        MPaySelectionCheck check = checks.get(0);
        MPaySelection paymentSelection = check.getParent();
        String fileName = this.getFileName(file, "", paymentSelection.getDocumentNo());
        this.openFileWriter(fileName.replaceAll("_", ""));
    }
}

