/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;
import org.erpya.lve.bank.exp.LVEPaymentExportList;
import org.erpya.lve.bank.exp.MercantilNominaFacil;

public class MercantilNomina
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(MercantilNominaFacil.class);
    private final String HEADER_SHORT_DATE_FORMAT = "yyyyMMdd";
    private Map<Integer, MHRProcess> payrollProcessMap = new HashMap<Integer, MHRProcess>();
    private Map<Integer, BigDecimal> payrollAmountMap = new HashMap<Integer, BigDecimal>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            String totalAmtAsString;
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)bankAccount.getC_Currency_ID());
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            MOrg org = MOrg.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            String bankSwift = "";
            if (!Util.isEmpty((String)bank.getSwiftCode())) {
                bankSwift = bank.getSwiftCode();
                bankSwift = this.rightPadding(bankSwift, 12, " ", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_Bank_ID@: " + bank.getName() + " @SwiftCode@ @NotFound@")));
            }
            String bankClientNo = "";
            if (!Util.isEmpty((String)bank.get_ValueAsString("BankClientNo"))) {
                bankClientNo = this.processValue(bank.get_ValueAsString("BankClientNo"));
                bankClientNo = this.leftPadding(bankClientNo, 6, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@BankClientNo@ @NotFound@"));
            }
            String paymentBatchNo = this.processValue(paySelection.getDocumentNo());
            paymentBatchNo = this.leftPadding(paymentBatchNo, 15, "0", true);
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", "")).trim();
            String organizationType = "";
            if (!Util.isEmpty((String)orgTaxId)) {
                orgTaxId = orgTaxId.replace("-", "").trim();
                organizationType = orgTaxId.substring(0, 1);
                orgTaxId = orgTaxId.replaceAll("\\D+", "");
                orgTaxId = this.leftPadding(orgTaxId, 10, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getValue() + " - " + org.getName())));
            }
            String paymentIdentify = "";
            if (!Util.isEmpty((String)paySelection.getName())) {
                paymentIdentify = this.processValue(paySelection.getName()) + " ";
            }
            if (!Util.isEmpty((String)paySelection.getDescription())) {
                paymentIdentify = paymentIdentify + this.processValue(paySelection.getDescription());
            }
            paymentIdentify = this.rightPadding(paymentIdentify, 20, " ", true);
            String payGenerated = String.valueOf(checks.size());
            if ((payGenerated = this.leftPadding(payGenerated, 5, "0", true)).length() > 5) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@Qty@ > @InValid@"));
            }
            if ((totalAmtAsString = String.format("%.2f", this.getTotalAmount(checks).abs()).replace(".", "").replace(",", "")).length() > 15) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @InValid@"));
            }
            totalAmtAsString = this.leftPadding(totalAmtAsString, 15, "0", true);
            SimpleDateFormat shortFormat = new SimpleDateFormat("yyyyMMdd");
            String payDate = shortFormat.format(paySelection.getPayDate());
            String bankAccountNo = this.processValue(bankAccount.getAccountNo()).trim();
            if ((bankAccountNo = bankAccountNo.replace(" ", "")).length() > 10) {
                bankAccountNo = bankAccountNo.substring(10, bankAccountNo.length());
            }
            bankAccountNo = this.rightPadding(bankAccountNo, 10, "0", true);
            StringBuffer header = new StringBuffer();
            header.append("00").append(bankClientNo).append(organizationType).append(orgTaxId).append(paymentIdentify).append(paymentBatchNo).append("105").append(currency.getISO_Code()).append(bankAccountNo).append(totalAmtAsString).append(payGenerated).append(payDate);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                this.addPayrollProcess((MPaySelectionCheck)payselectionCheck);
                if (bpAccount != null) {
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    String personType = "";
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        personType = bPTaxId.substring(0, 1);
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = this.leftPadding(bPTaxId, 10, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.rightPadding(bPAccountNo, 10, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 60, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String documentNo = this.processValue(payselectionCheck.getDocumentNo());
                    documentNo = this.rightPadding(documentNo, 8, " ", true);
                    String amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 15) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Valid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    amountAsString = this.leftPadding(amountAsString, 15, "0", true);
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 50, " ", true);
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append("01").append(personType).append(bPTaxId).append(bPName).append("1").append("105").append(bPAccountNo).append(amountAsString).append(amountAsString);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.writeDetail();
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private void addPayrollProcess(MPaySelectionCheck payselectionCheck) {
        payselectionCheck.getPaySelectionLinesAsList(false).stream().forEach(paySelectionLine -> {
            MHRMovement movement = (MHRMovement)paySelectionLine.getHR_Movement();
            this.payrollProcessMap.put(movement.getHR_Process_ID(), (MHRProcess)movement.getHR_Process());
            BigDecimal amount = this.payrollAmountMap.get(movement.getHR_Process_ID());
            amount = amount != null ? amount.add(movement.getAmount()) : Env.ZERO;
            this.payrollAmountMap.put(movement.getHR_Process_ID(), amount);
        });
    }

    private void writeDetail() {
        this.payrollProcessMap.entrySet().forEach(entry -> {
            String registerType = "02";
            String documentNo = null;
            String description = null;
            BigDecimal documentAmount = Env.ZERO;
            Timestamp documentDate = null;
            MHRProcess payrollProcess = (MHRProcess)entry.getValue();
            documentNo = this.processValue(payrollProcess.getDocumentNo());
            description = this.processValue(payrollProcess.getName());
            documentAmount = this.payrollAmountMap.get(entry.getKey());
            documentDate = payrollProcess.getDateAcct();
            if (documentNo.length() > 12) {
                documentNo = documentNo.substring(0, 12);
            }
            documentNo = this.rightPadding(documentNo, 12, " ");
            if (description.length() > 80) {
                description = description.substring(0, 80);
            }
            description = this.rightPadding(description, 80, " ");
            String documentAmountAsString = String.format("%.2f", documentAmount.abs()).replace(".", "").replace(",", "");
            documentAmountAsString = this.leftPadding(documentAmountAsString, 15, "0", true);
            String documentDateAsString = new SimpleDateFormat("yyyyMMdd").format(documentDate);
            StringBuffer line = new StringBuffer();
            line.append(Env.NL).append(registerType).append(documentNo).append(documentAmountAsString).append(documentDateAsString).append(description);
            s_log.fine("Write Line");
            this.writeLine(line.toString());
        });
    }

    @Override
    public String processValue(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$,;*/\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00bf\u00a1]", "");
    }

    private BigDecimal getTotalAmount(List<MPaySelectionCheck> checks) {
        BigDecimal totalAmount = Env.ZERO;
        for (MPaySelectionCheck payment : checks) {
            totalAmount = totalAmount.add(payment.getPayAmt());
        }
        return totalAmount;
    }
}

