/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.PaymentExportList;
import org.compiere.util.Util;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;

public abstract class LVEPaymentExportList
extends PaymentExportList {
    public int exportToFileAsVerification(MBankAccount bankAccount, List<MPayment> payments, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsEnrollmentRequest(List<MBPartner> bPartnerList, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsEnrollment(MBankAccount bankAccount, List<MBPBankAccount> bPartnerAccountList, boolean isEnroll, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsPayroll(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFileAsAccountPayable(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return 0;
    }

    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        MPaySelectionCheck check = checks.get(0);
        int payselectionlineId = DB.getSQLValue((String)check.get_TrxName(), (String)"SELECT C_PaySelectionLine_ID FROM C_PaySelectionLine WHERE C_PaySelectionCheck_ID = ?", (int)check.getC_PaySelectionCheck_ID());
        if (payselectionlineId > 0) {
            MPaySelectionLine line = new MPaySelectionLine(check.getCtx(), payselectionlineId, check.get_TrxName());
            if (line.getHR_Movement_ID() > 0) {
                return this.exportToFileAsPayroll(checks, file, error);
            }
            return this.exportToFileAsAccountPayable(checks, file, error);
        }
        return this.exportToFileAsAccountPayable(checks, file, error);
    }

    public void openFileWriter(File file, List<MPaySelectionCheck> checks) {
        MPaySelectionCheck check = checks.get(0);
        MPaySelection paymentSelection = check.getParent();
        MBankAccount bankAccount = MBankAccount.get((Properties)Env.getCtx(), (int)paymentSelection.getC_BankAccount_ID());
        MBank bank = MBank.get((Properties)Env.getCtx(), (int)bankAccount.getC_Bank_ID());
        String fileName = this.getFileName(file, bank.getName(), paymentSelection.getDocumentNo());
        this.openFileWriter(fileName);
    }

    public void openFileWriter(File file, MBankAccount bankAccount, List<MPayment> payments, String suffix) {
        if (Util.isEmpty((String)suffix)) {
            suffix = "";
        }
        MPayment firstPayment = payments.get(0);
        MPaymentBatch paymentBatch = (MPaymentBatch)firstPayment.getC_PaymentBatch();
        MBank bank = MBank.get((Properties)Env.getCtx(), (int)bankAccount.getC_Bank_ID());
        String fileName = this.getFileName(file, bank.getName(), paymentBatch.getDocumentNo() + suffix);
        this.openFileWriter(fileName);
    }

    public void openFileWriter(File file, String bankName, String documentNo) {
        String fileName = this.getFileName(file, bankName, documentNo);
        this.openFileWriter(fileName);
    }

    public void openFileWriter(String newName) {
        File newFile = new File(newName);
        this.deleteIfExist(newFile);
        this.openFileWriter(newFile);
    }

    public String getParentFileName(File file) {
        StringBuffer pathName = new StringBuffer();
        if (file.isFile() || !file.exists()) {
            pathName.append(file.getParent());
        } else {
            pathName.append(file.getAbsolutePath());
        }
        return pathName.toString();
    }

    public String getFileName(File file, String bankName, String documentNo) {
        if (file == null) {
            return null;
        }
        String extension = ".txt";
        StringBuffer pathName = new StringBuffer(this.getParentFileName(file));
        pathName.append(File.separator).append(this.processValue(bankName)).append("_").append(this.processValue(documentNo)).append(extension);
        return pathName.toString().replace(" ", "_");
    }

    public boolean isNumeric(String value) {
        if (Util.isEmpty((String)value)) {
            return false;
        }
        return value.matches("[+-]?\\d*(\\.\\d+)?");
    }

    public String getNumericOnly(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("\\D+", "");
    }

    public String getDetail(MPaySelectionCheck check) {
        StringBuffer detail = new StringBuffer();
        for (MPaySelectionLine paySelectionLine : check.getPaySelectionLinesAsList(false)) {
            String documentNo = null;
            MPaySelection paymentSelection = (MPaySelection)paySelectionLine.getC_PaySelection();
            if (paySelectionLine.getC_Invoice_ID() != 0) {
                MInvoice invoice = (MInvoice)paySelectionLine.getC_Invoice();
                documentNo = invoice.getDocumentNo();
            } else if (paySelectionLine.getC_Order_ID() != 0) {
                MOrder order = (MOrder)paySelectionLine.getC_Order();
                documentNo = order.getDocumentNo();
            } else if (paySelectionLine.getHR_Movement_ID() != 0) {
                MHRMovement movement = (MHRMovement)paySelectionLine.getHR_Movement();
                MHRProcess payrollProcess = (MHRProcess)movement.getHR_Process();
                documentNo = payrollProcess.getDocumentNo();
            } else {
                documentNo = "SP-" + paymentSelection.getDocumentNo();
            }
            if (Util.isEmpty((String)documentNo)) continue;
            if (detail.length() > 0) {
                detail.append("-");
            }
            detail.append(documentNo);
        }
        return detail.toString();
    }

    public String processValue(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7,;*./?-]", "").trim();
    }

    public String getValidEMail(String eMail) {
        if (Util.isEmpty((String)eMail)) {
            return eMail;
        }
        return eMail.replaceAll("[+^.+@.+\\..+$]", "").trim();
    }

    public boolean isValidEmail(String eMail) {
        if (Util.isEmpty((String)eMail)) {
            return false;
        }
        try {
            InternetAddress emailAddr = new InternetAddress(eMail);
            emailAddr.validate();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

