/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class Exterior
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(Exterior.class);
    private final String DATE_FORMAT = "ddMMyyyy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
            StringBuffer header = new StringBuffer();
            String personType = "";
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            if (!Util.isEmpty((String)orgTaxId)) {
                orgTaxId = orgTaxId.replace("-", "").trim();
                personType = orgTaxId.substring(0, 1);
                orgTaxId = this.getNumericOnly(orgTaxId);
                orgTaxId = this.rightPadding(orgTaxId, 9, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@TaxID@ @NotFound@"));
            }
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.replace(" ", "");
            bankAccountNo = this.rightPadding(bankAccountNo, 20, "0", true);
            String paymentQty = this.leftPadding(String.valueOf(checks.size()), 4, "0", true);
            String totalAmtAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", "").replace(",", "");
            if (totalAmtAsString.length() > 13) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
            }
            totalAmtAsString = this.leftPadding(totalAmtAsString, 13, "0", true);
            String paymentRequestDate = dateFormat.format(paySelection.getPayDate());
            String serviceCode = "01";
            String constant = this.leftPadding("", 19, " ");
            header = new StringBuffer();
            header.append(personType).append(orgTaxId).append(bankAccountNo).append(paymentQty).append(totalAmtAsString).append(paymentRequestDate).append(serviceCode).append(constant);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                if (bpAccount != null) {
                    MBank bpBank = MBank.get((Properties)Env.getCtx(), (int)bpAccount.getC_Bank_ID());
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 60, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 12) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
                    }
                    amountAsString = this.leftPadding(amountAsString, 12, "0", true);
                    String description = this.getDetail((MPaySelectionCheck)payselectionCheck);
                    description = this.rightPadding(description, 120, " ", true);
                    String bPRoutingNo = "";
                    if (Util.isEmpty((String)bpBank.getRoutingNo())) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@RoutingNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    if ((bPRoutingNo = this.processValue(bpBank.getRoutingNo())).charAt(0) == '0') {
                        bPRoutingNo = bPRoutingNo.substring(1);
                    }
                    bPRoutingNo = this.leftPadding(bPRoutingNo, 3, "0", true);
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 60, " ", true);
                    String debtReferenceNo = this.processValue(paySelection.getDocumentNo());
                    debtReferenceNo = this.getNumericOnly(debtReferenceNo);
                    debtReferenceNo = this.leftPadding(debtReferenceNo, 8, "0", true);
                    String bPPersonType = "";
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPPersonType = bPTaxId.substring(0, 1);
                        bPTaxId = this.getNumericOnly(bPTaxId);
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(bPName).append(amountAsString).append(description).append(bPRoutingNo).append(bPAccountNo).append(bPEmail).append(debtReferenceNo).append(bPPersonType).append(bPTaxId);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }
}

