/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;
import org.erpya.lve.bank.exp.LVEPaymentExportList;
import org.erpya.lve.bank.exp.MercantilNominaFacil;

public class BanplusNomina
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(MercantilNominaFacil.class);
    private Map<Integer, MHRProcess> payrollProcessMap = new HashMap<Integer, MHRProcess>();
    private Map<Integer, BigDecimal> payrollAmountMap = new HashMap<Integer, BigDecimal>();
    private final String HEADER_SHORT_DATE_FORMAT = "dd/MM/yyyy";
    private final String SEPARATOR = ";";
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            MOrg org = MOrg.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            String bankSwift = "";
            if (!Util.isEmpty((String)bank.getSwiftCode())) {
                bankSwift = bank.getSwiftCode();
                bankSwift = this.rightPadding(bankSwift, 12, " ", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_Bank_ID@: " + bank.getName() + " @SwiftCode@ @NotFound@")));
            }
            SimpleDateFormat shortFormat = new SimpleDateFormat("dd/MM/yyyy");
            String payDate = shortFormat.format(paySelection.getPayDate());
            String paymentBatchNo = this.processValue(paySelection.getDocumentNo());
            paymentBatchNo = this.leftPadding(paymentBatchNo, 15, "0", true);
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", "")).trim();
            String organizationType = "";
            if (!Util.isEmpty((String)orgTaxId)) {
                orgTaxId = orgTaxId.replace("-", "").trim();
                organizationType = orgTaxId.substring(0, 1);
                orgTaxId = orgTaxId.replaceAll("\\D+", "");
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@TaxID@ @NotFound@: " + org.getValue() + " - " + org.getName())));
            }
            String totalAmtAsString = String.format("%.2f", this.getTotalAmount(checks).abs()).replace(".", ",");
            if (totalAmtAsString.length() > 18) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @InValid@"));
            }
            String bankAccountNo = this.processValue(bankAccount.getAccountNo()).trim();
            if ((bankAccountNo = bankAccountNo.replace(" ", "")).length() > 20) {
                bankAccountNo = bankAccountNo.substring(20, bankAccountNo.length());
            }
            StringBuffer header = new StringBuffer();
            header.append(organizationType).append(orgTaxId).append(";").append(bankAccountNo).append(";").append(checks.size()).append(";").append(totalAmtAsString).append(";").append(payDate);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                this.addPayrollProcess((MPaySelectionCheck)payselectionCheck);
                if (bpAccount != null) {
                    String amountAsString;
                    String bPName;
                    bPName = bPName.substring(0, (bPName = this.processValue(bpAccount.getA_Name())).length() >= 40 ? 40 : bPName.length());
                    bPName = this.rightPadding(bPName, 40, " ", true);
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    String personType = "";
                    if (!Util.isEmpty((String)bPTaxId)) {
                        personType = (bPTaxId = bPTaxId.replace("-", "").trim()).substring(0, 1);
                        if (personType.equals("V")) {
                            personType = "01";
                        } else if (personType.equals("E")) {
                            personType = "08";
                        }
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = this.leftPadding(bPTaxId, 15, "", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (!Optional.ofNullable(bPAccountNo).isPresent()) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    if ((amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", ",")).length() > 18) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Valid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    amountAsString = this.leftPadding(amountAsString, 18, "", true);
                    StringBuffer line = new StringBuffer();
                    line.append(CRLF).append(personType).append(";").append(bPTaxId).append(";").append(bPName).append(";").append(bPAccountNo).append(";").append(amountAsString);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private void addPayrollProcess(MPaySelectionCheck payselectionCheck) {
        payselectionCheck.getPaySelectionLinesAsList(false).stream().forEach(paySelectionLine -> {
            MHRMovement movement = (MHRMovement)paySelectionLine.getHR_Movement();
            this.payrollProcessMap.put(movement.getHR_Process_ID(), (MHRProcess)movement.getHR_Process());
            BigDecimal amount = this.payrollAmountMap.get(movement.getHR_Process_ID());
            amount = amount != null ? amount.add(movement.getAmount()) : Env.ZERO;
            this.payrollAmountMap.put(movement.getHR_Process_ID(), amount);
        });
    }

    @Override
    public String processValue(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$,;*/\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00bf\u00a1]", "");
    }

    private BigDecimal getTotalAmount(List<MPaySelectionCheck> checks) {
        BigDecimal totalAmount = Env.ZERO;
        for (MPaySelectionCheck payment : checks) {
            totalAmount = totalAmount.add(payment.getPayAmt());
        }
        return totalAmount;
    }
}

