/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class Banplus
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(Banplus.class);
    private final String SEPARATOR = ";";
    private final String HEADER_SHORT_DATE_FORMAT = "yyyyMMdd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            SimpleDateFormat shortFormat = new SimpleDateFormat("yyyyMMdd");
            String paymentRequestNo = this.processValue(paySelection.getDocumentNo());
            paymentRequestNo = paymentRequestNo.substring(0, paymentRequestNo.length() >= 10 ? 10 : paymentRequestNo.length());
            String debtReferenceNo = this.processValue(paySelection.getDocumentNo());
            debtReferenceNo = debtReferenceNo.substring(0, debtReferenceNo.length() >= 8 ? 8 : debtReferenceNo.length());
            debtReferenceNo = debtReferenceNo.replaceAll("\\D+", "");
            debtReferenceNo = this.rightPadding(debtReferenceNo, 30, " ");
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            orgTaxId = orgTaxId.substring(0, orgTaxId.length() >= 12 ? 12 : orgTaxId.length());
            String totalAmtAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", "").replace(",", "");
            if (totalAmtAsString.length() <= 18) {
                totalAmtAsString = totalAmtAsString.substring(0, totalAmtAsString.length() >= 15 ? 15 : totalAmtAsString.length());
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @InValid@"));
            }
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.substring(0, bankAccountNo.length() >= 20 ? 20 : bankAccountNo.length());
            bankAccountNo = bankAccountNo.replace(" ", "");
            String payGenerated = String.valueOf(checks.size());
            if (payGenerated.length() > 3) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@Qty@ > @InValid@"));
            }
            String payDate = shortFormat.format(paySelection.getPayDate());
            StringBuffer header = new StringBuffer();
            header.append(orgTaxId).append(";").append(bankAccountNo).append(";").append(payGenerated).append(";").append(totalAmtAsString).append(";").append(payDate).append(";").append(paymentRequestNo);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                if (bpAccount != null) {
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    String personType = "";
                    if (!Util.isEmpty((String)bPTaxId)) {
                        personType = (bPTaxId = bPTaxId.replace("-", "").trim()).substring(0, 1);
                        personType = personType.equals("V") ? "01" : (personType.equals("E") ? "08" : "04");
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = bPTaxId.substring(0, bPTaxId.length() >= 9 ? 9 : bPTaxId.length());
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = bPName.substring(0, bPName.length() >= 40 ? 40 : bPName.length());
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = bPAccountNo.substring(0, bPAccountNo.length() >= 20 ? 20 : bPAccountNo.length());
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String documentNo = this.processValue(payselectionCheck.getDocumentNo());
                    documentNo = documentNo.substring(0, documentNo.length() >= 8 ? 8 : documentNo.length());
                    String amountAsString = String.format("%.2f", payselectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 15) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Valid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = bPEmail.substring(0, bPEmail.length() >= 70 ? 70 : bPEmail.length());
                    String makePayment = "SI";
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(personType).append(";").append(bPTaxId).append(";").append(bPName).append(";").append(bPAccountNo).append(";").append(amountAsString).append(";").append(documentNo).append(";").append(bPEmail).append(";").append(makePayment);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }
}

