/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class BanescoPagoDetallado
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(BanescoPagoDetallado.class);
    private final String HEADER_DATE_FORMAT = "yyyyMMddHHmmss";
    private final String HEADER_SHORT_DATE_FORMAT = "yyyyMMdd";
    private int paymentQty = 0;
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    @Override
    public int exportToFileAsAccountPayable(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return this.export(checks, file, error, "SCV");
    }

    @Override
    public int exportToFileAsPayroll(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return this.export(checks, file, error, "SAL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int export(List<MPaySelectionCheck> checks, File file, StringBuffer error, String transactionType) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)bankAccount.getC_Currency_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            MClient client = MClient.get((Properties)orgInfo.getCtx(), (int)orgInfo.getAD_Client_ID());
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            String orgTaxIdForLine = orgTaxId = this.rightPadding(orgTaxId, 17, " ").toUpperCase();
            String clientName = client.getName();
            if (orgInfo.get_ValueAsBoolean("IsDefinedAsClient")) {
                clientName = MOrg.get((Properties)orgInfo.getCtx(), (int)orgInfo.getAD_Org_ID()).getName();
            }
            clientName = this.processValue(clientName);
            String clientNameForLine = clientName = this.rightPadding(clientName, 35, " ", true);
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            SimpleDateFormat headerFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat shortFormat = new SimpleDateFormat("yyyyMMdd");
            String registerType = "HDR";
            String commercialAllocated = this.rightPadding("BANESCO", 15, " ");
            String standardEDIFACT = "E";
            String versionStandardEDIFACT = "D  95B";
            String documentType = "PAYMUL";
            String production = "P";
            BigDecimal totalPaymentAmount = this.getTotalPaymentAmount(checks);
            StringBuffer header = new StringBuffer();
            header.append(registerType).append(commercialAllocated).append(standardEDIFACT).append(versionStandardEDIFACT).append(documentType).append(production);
            this.writeLine(header.toString());
            String descriptionCode = this.rightPadding("", 32, " ");
            String paymentRequestCondition = this.rightPadding("9", 3, " ");
            String paymentRequestNo = this.rightPadding(this.processValue(paySelection.getDocumentNo()), 35, " ", true);
            String paymentRequestDate = headerFormat.format(paySelection.getPayDate());
            registerType = "01";
            header = new StringBuffer();
            header.append(CRLF).append(registerType).append(transactionType).append(descriptionCode).append(paymentRequestCondition).append(paymentRequestNo).append(paymentRequestDate);
            this.writeLine(header.toString());
            header = new StringBuffer();
            String debitRegisterType = "02";
            String debtReferenceNo = this.processValue(paySelection.getDocumentNo());
            debtReferenceNo = debtReferenceNo.substring(0, debtReferenceNo.length() >= 8 ? 8 : debtReferenceNo.length());
            debtReferenceNo = debtReferenceNo.replaceAll("\\D+", "");
            debtReferenceNo = this.rightPadding(debtReferenceNo, 30, " ");
            String totalAmtAsString = String.format("%.2f", totalPaymentAmount).replace(".", "").replace(",", "");
            totalAmtAsString = this.leftPadding(totalAmtAsString, 15, "0");
            if (totalAmtAsString.length() <= 15) {
                totalAmtAsString = this.leftPadding(totalAmtAsString, 15, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @Invalid@"));
            }
            String iSOCode = currency.getISO_Code();
            String freeField = this.rightPadding("", 1, " ");
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.replace(" ", "");
            String bankAccountNoForLine = bankAccountNo = this.rightPadding(bankAccountNo, 34, " ", true);
            String bankCodeOrder = this.rightPadding("BANESCO", 11, " ");
            String payDate = shortFormat.format(paySelection.getPayDate());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)paySelectionCheck.getCtx(), (int)paySelectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)paySelectionCheck, true);
                if (bpAccount != null) {
                    MUser bpContact = null;
                    if (bpAccount.getAD_User_ID() != 0) {
                        bpContact = MUser.get((Properties)Env.getCtx(), (int)bpAccount.getAD_User_ID());
                    }
                    MBank bpBank = MBank.get((Properties)Env.getCtx(), (int)bpAccount.getC_Bank_ID());
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    String bPRoutingNo = this.rightPadding(this.processValue(bpBank.getRoutingNo()), 11, " ");
                    if (Util.isEmpty((String)bPRoutingNo)) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@RoutingNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String agencyCode = this.rightPadding("", 3, " ");
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPTaxId = this.rightPadding(bPTaxId, 17, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 70, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 70, " ", true);
                    String bPPhone = "";
                    String bPTaxIdContact = "";
                    String bPContactName = "";
                    if (Optional.ofNullable(bpContact).isPresent()) {
                        if (!Util.isEmpty((String)bpContact.getPhone())) {
                            bPPhone = this.processValue(bpContact.getPhone());
                        }
                        if (!Util.isEmpty((String)bpContact.getValue())) {
                            bPTaxIdContact = this.processValue(bpContact.getValue());
                        }
                        if (!Util.isEmpty((String)bpContact.getName())) {
                            bPContactName = this.processValue(bpContact.getName());
                        }
                    }
                    bPPhone = this.rightPadding(bPPhone, 25, " ", true);
                    bPTaxIdContact = this.rightPadding(this.processValue(bPTaxIdContact), 17, " ", true);
                    bPContactName = this.rightPadding(this.processValue(bPContactName), 35, " ", true);
                    String settlorQualifier = this.rightPadding("", 1, " ", true);
                    String cardEmployee = this.rightPadding("", 30, " ", true);
                    String payrollType = this.rightPadding("", 2, " ", true);
                    String contactLocation = this.rightPadding("", 21, " ", true);
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                        bPAccountNo = this.rightPadding(bPAccountNo, 30, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String lineRegisterType = "03";
                    String documentNo = this.processValue(paySelectionCheck.getDocumentNo());
                    documentNo = documentNo.substring(0, documentNo.length() >= 30 ? 30 : documentNo.length());
                    documentNo = documentNo.replaceAll("\\D+", "");
                    documentNo = this.leftPadding(documentNo, 30, "0");
                    documentNo = this.rightPadding(documentNo, 30, " ");
                    String amountAsString = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() <= 15) {
                        amountAsString = this.leftPadding(amountAsString, 15, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String paymentTerm = "425";
                    if (!Util.isEmpty((String)bank.getSwiftCode()) && !Util.isEmpty((String)bpBank.getSwiftCode()) && bank.getSwiftCode().equals(bpBank.getSwiftCode())) {
                        paymentTerm = this.rightPadding("42", 3, " ");
                    }
                    StringBuffer line = new StringBuffer();
                    line.append(CRLF).append(debitRegisterType).append(documentNo).append(orgTaxIdForLine).append(clientNameForLine).append(amountAsString).append(iSOCode).append(freeField).append(bankAccountNoForLine).append(bankCodeOrder).append(payDate);
                    this.writeLine(line.toString());
                    line = new StringBuffer();
                    line.append(CRLF).append(lineRegisterType).append(documentNo).append(amountAsString).append(iSOCode).append(bPAccountNo).append(bPRoutingNo).append(agencyCode).append(bPTaxId).append(bPName).append(bPEmail).append(bPPhone).append(bPTaxIdContact).append(bPContactName).append(settlorQualifier).append(cardEmployee).append(payrollType).append(contactLocation).append(paymentTerm);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                this.addPaymentToCounter();
            });
            registerType = "06";
            String countDebit = this.leftPadding("" + this.getPaymentQty(), 15, "0");
            String countCredit = this.leftPadding("" + this.getPaymentQty(), 15, "0");
            StringBuffer footer = new StringBuffer();
            footer.append(CRLF).append(registerType).append(countDebit).append(countCredit).append(totalAmtAsString);
            this.writeLine(footer.toString());
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private int getPaymentQty() {
        return this.paymentQty;
    }

    private void addPaymentToCounter() {
        ++this.paymentQty;
    }

    @Override
    public int exportToFileAsEnrollment(MBankAccount bankAccount, List<MBPBankAccount> bPartnerAccountList, boolean isEnroll, File file, StringBuffer error) {
        MOrgInfo orgInfo = MOrgInfo.get((Properties)bankAccount.getCtx(), (int)bankAccount.getAD_Org_ID(), (String)bankAccount.get_TrxName());
        MClient client = MClient.get((Properties)orgInfo.getCtx(), (int)orgInfo.getAD_Client_ID());
        MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
        String clientName = this.processValue(client.getName());
        clientName = this.rightPadding(clientName, 35, " ", true);
        String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", "")).trim();
        orgTaxId = this.rightPadding(orgTaxId, 17, " ").toUpperCase();
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String documentNo = "AFIL" + shortFormat.format(new Time(System.currentTimeMillis()));
        documentNo = this.rightPadding(documentNo, 30, " ", true);
        StringBuffer header = new StringBuffer();
        header.append(clientName).append(orgTaxId).append(documentNo);
        this.writeLine(header.toString());
        s_log.fine("Iterate Payments");
        bPartnerAccountList.stream().filter(bPartnerAccount -> bPartnerAccount != null).forEach(bPartnerAccount -> {
            MBPartner bpartner = MBPartner.get((Properties)bPartnerAccount.getCtx(), (int)bPartnerAccount.getC_BPartner_ID());
            MBank bpBank = MBank.get((Properties)Env.getCtx(), (int)bPartnerAccount.getC_Bank_ID());
            boolean isSameBank = false;
            if (!Util.isEmpty((String)bank.getSwiftCode()) && !Util.isEmpty((String)bpBank.getSwiftCode()) && bank.getSwiftCode().equals(bpBank.getSwiftCode())) {
                isSameBank = true;
            }
            String transactionType = "";
            transactionType = isEnroll ? (isSameBank ? "051" : "052") : (isSameBank ? "071" : "072");
            String referenceNo = this.rightPadding("", 30, " ", true);
            String bPTaxId = bPartnerAccount.getA_Ident_SSN();
            String personType = "";
            String firstChar = "";
            if (!Util.isEmpty((String)bPTaxId)) {
                bPTaxId = bPTaxId.replace("-", "").trim();
                firstChar = bPTaxId.substring(0, 1);
                bPTaxId = bPTaxId.replaceAll("\\D+", "");
                bPTaxId = this.leftPadding(bPTaxId, 11, "0", true);
                bPTaxId = firstChar + bPTaxId;
                bPTaxId = this.rightPadding(bPTaxId, 12, "0", true);
                if (this.isNumeric(firstChar)) {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PersonType@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())) + " - " + bPartnerAccount.getA_Ident_SSN());
                } else {
                    personType = firstChar.equals("V") || firstChar.equals("E") ? "N" : "J";
                }
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
            }
            String bPAccountNo = this.processValue(bPartnerAccount.getAccountNo());
            bPAccountNo = this.rightPadding(bPAccountNo, 20, "0", true);
            String bPName = this.processValue(bPartnerAccount.getA_Name());
            if (Optional.ofNullable(bPName).isPresent()) {
                bPName = this.rightPadding(bPName, 35, " ", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
            }
            String transactionStatus = "000";
            StringBuffer line = new StringBuffer();
            line.append(CRLF).append(transactionType).append(referenceNo).append(personType).append(bPTaxId).append(bPAccountNo).append(bPName).append(transactionStatus);
            s_log.fine("Write Line");
            this.writeLine(line.toString());
        });
        return this.getExportedPayments();
    }

    private BigDecimal getTotalPaymentAmount(List<MPaySelectionCheck> checks) {
        BigDecimal totalPaymentamount = Env.ZERO;
        for (MPaySelectionCheck check : checks) {
            totalPaymentamount = totalPaymentamount.add(check.getPayAmt().abs());
        }
        return totalPaymentamount;
    }
}

