/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MDocType;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class BancaribePagoDetallado_2022
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(BancaribePagoDetallado_2022.class);
    private final String SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            s_log.fine("Iterate Payments");
            MPaySelection paymentSelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MDocType documentType = MDocType.get((Properties)Env.getCtx(), (int)paymentSelection.getC_DocType_ID());
            MBankAccount bankAccount = (MBankAccount)paymentSelection.getC_BankAccount();
            AtomicReference<String> service = new AtomicReference<String>("PAP");
            if (documentType.isPayrollPayment()) {
                service.set("NOM");
            }
            AtomicReference<String> bankAccountNo = new AtomicReference<String>(this.processValue(bankAccount.getAccountNo()));
            bankAccountNo.set(bankAccountNo.get().replace(" ", ""));
            bankAccountNo.set(this.leftPadding(bankAccountNo.get(), 20, "0", true));
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPBankAccount businessPartnerAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                MBPartner businessPartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                if (businessPartnerAccount != null) {
                    String businessPartnerTaxId;
                    String businessPartnerAccountNo = this.processValue(businessPartnerAccount.getAccountNo());
                    MBank businessPartnerBank = MBank.get((Properties)Env.getCtx(), (int)businessPartnerAccount.getC_Bank_ID());
                    String routingNo = businessPartnerBank.getRoutingNo();
                    if (Optional.ofNullable(businessPartnerAccountNo).isPresent()) {
                        businessPartnerAccountNo = this.leftPadding(businessPartnerAccountNo, 20, "", false);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + businessPartner.getValue() + " - " + businessPartner.getName())));
                    }
                    String businessPartnerName = this.processValue(businessPartnerAccount.getA_Name());
                    if (Optional.ofNullable(businessPartnerName).isPresent()) {
                        if ((businessPartnerName = businessPartnerName.trim()).length() > 64) {
                            businessPartnerName = businessPartnerName.substring(0, 64);
                        }
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + businessPartner.getValue() + " - " + businessPartner.getName())));
                    }
                    if (!Util.isEmpty((String)(businessPartnerTaxId = businessPartnerAccount.getA_Ident_SSN()))) {
                        businessPartnerTaxId = businessPartnerTaxId.replace("-", "").trim();
                        String personType = businessPartnerTaxId.substring(0, 1);
                        businessPartnerTaxId = this.getNumericOnly(businessPartnerTaxId);
                        businessPartnerTaxId = personType + this.leftPadding(businessPartnerTaxId, 14, "", false);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + businessPartner.getValue() + " - " + businessPartner.getName())));
                    }
                    String reference = this.processValue(payselectionCheck.getDocumentNo());
                    reference = this.rightPadding(reference, 17, "", false);
                    String businessPartnerEmail = this.rightPadding(businessPartnerAccount.getA_EMail(), 64, "", false);
                    if (!this.isValidEmail(businessPartnerEmail)) {
                        businessPartnerEmail = "";
                    }
                    String businessPartnerPhone = "";
                    String businessPartnerPhone2 = "";
                    if (businessPartnerAccount.getAD_User_ID() > 0) {
                        MUser contact = MUser.get((Properties)Env.getCtx(), (int)businessPartnerAccount.getAD_User_ID());
                        if (!Util.isEmpty((String)contact.getPhone())) {
                            businessPartnerPhone = this.leftPadding(this.getNumericOnly(contact.getPhone()), 64, "", false);
                        }
                        if (!Util.isEmpty((String)contact.getPhone2())) {
                            businessPartnerPhone2 = this.leftPadding(this.getNumericOnly(contact.getPhone2()), 64, "", false);
                        }
                    }
                    if (!this.isValidEmail(businessPartnerEmail)) {
                        businessPartnerEmail = "";
                    }
                    AtomicReference<String> businessPartnerAccountType = new AtomicReference<String>("CTE");
                    Optional<String> maybeBusinessPartnerAccountType = Optional.ofNullable(businessPartnerAccount.getBankAccountType());
                    maybeBusinessPartnerAccountType.ifPresent(accountType -> {
                        if (accountType.equals("S")) {
                            businessPartnerAccountType.set("AHO");
                        }
                    });
                    if (Optional.ofNullable(businessPartnerAccountNo).isPresent() && Optional.ofNullable(businessPartnerName).isPresent()) {
                        String paymentAmount = String.format("%.2f", payselectionCheck.getPayAmt()).replace(",", ".");
                        StringBuffer line = new StringBuffer();
                        line.append((String)service.get()).append("/").append("/").append("/").append(routingNo).append("/").append(businessPartnerAccountNo).append("/").append(businessPartnerAccountType.get()).append("/").append("/").append(paymentAmount).append("/").append(businessPartnerTaxId).append("/").append(businessPartnerName).append("/").append(reference).append("/").append(businessPartnerEmail).append("/").append(businessPartnerPhone).append("/").append(businessPartnerPhone2).append("/").append(Env.NL);
                        s_log.fine("Write Line");
                        this.writeLine(line.toString());
                    }
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + businessPartner.getValue() + " - " + businessPartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    @Override
    public int exportToFileAsEnrollment(MBankAccount bankAccount, List<MBPBankAccount> bPartnerAccountList, boolean isEnroll, File file, StringBuffer error) {
        throw new AdempiereException("Unsupported method");
    }
}

