/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class Bancaribe
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(Bancaribe.class);
    private final String SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(payselectionCheck -> {
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)payselectionCheck, true);
                MBPartner bpartner = MBPartner.get((Properties)payselectionCheck.getCtx(), (int)payselectionCheck.getC_BPartner_ID());
                if (bpAccount != null) {
                    String bpAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bpAccountNo).isPresent()) {
                        bpAccountNo = this.leftPadding(bpAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bpaName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bpaName).isPresent()) {
                        bpaName = this.rightPadding(bpaName, 30, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    if (Optional.ofNullable(bpAccountNo).isPresent() && Optional.ofNullable(bpaName).isPresent()) {
                        BigDecimal amt = payselectionCheck.getPayAmt().abs();
                        String strange = "#,##0.00";
                        DecimalFormat numFormat = DisplayType.getNumberFormat((int)22, (Language)Language.getBaseLanguage(), (String)strange);
                        StringBuffer line = new StringBuffer();
                        line.append(bpAccountNo).append("/").append(numFormat.format(amt)).append("/").append(bpaName).append(Env.NL);
                        s_log.fine("Write Line");
                        this.writeLine(line.toString());
                    }
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFileAsEnrollment(MBankAccount bankAccount, List<MBPBankAccount> bPartnerAccountList, boolean isEnroll, File file, StringBuffer error) {
        if (bPartnerAccountList == null || bPartnerAccountList.size() == 0) {
            return 0;
        }
        try {
            File enrollmentFile;
            s_log.fine("Delete file if exist");
            MBank bank = MBank.get((Properties)Env.getCtx(), (int)bankAccount.getC_Bank_ID());
            String enrollmentPath = this.getFileName(file, bank.getName(), isEnroll, true);
            if (!Util.isEmpty((String)enrollmentPath)) {
                enrollmentFile = new File(enrollmentPath);
                this.deleteIfExist(enrollmentFile);
                s_log.fine("Open File Writer");
                this.openFileWriter(enrollmentFile);
                s_log.fine("Iterate Payments");
                bPartnerAccountList.stream().filter(bpAccount -> bpAccount.getC_Bank_ID() == bankAccount.getC_Bank_ID()).forEach(bpAccount -> {
                    MBPartner bPartner = MBPartner.get((Properties)Env.getCtx(), (int)bpAccount.getC_BPartner_ID());
                    String bpAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bpAccountNo).isPresent()) {
                        bpAccountNo = this.leftPadding(bpAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bPartner.getValue() + " - " + bPartner.getName())));
                    }
                    String bpaName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bpaName).isPresent()) {
                        bpaName = bpaName.substring(0, bpaName.length() >= 30 ? 30 : bpaName.length());
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bPartner.getValue() + " - " + bPartner.getName())));
                    }
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        String bpTaxIdChar = bPTaxId.substring(0, 1);
                        bPTaxId = bPTaxId.substring(1, bPTaxId.length());
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                        bPTaxId = bpTaxIdChar + bPTaxId;
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bPartner.getValue() + " - " + bPartner.getName())));
                    }
                    StringBuffer line = new StringBuffer();
                    line.append(bpAccountNo).append("/").append(bpaName).append("/").append(bPTaxId).append(Env.NL);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                });
                this.closeFileWriter();
                this.deleteIfExist(enrollmentFile);
            }
            if (!Util.isEmpty((String)(enrollmentPath = this.getFileName(file, bank.getName(), isEnroll, false)))) {
                enrollmentFile = new File(enrollmentPath);
                s_log.fine("Open File Writer");
                this.openFileWriter(enrollmentFile);
                s_log.fine("Iterate Payments");
                bPartnerAccountList.stream().filter(bpAccount -> bpAccount.getC_Bank_ID() != bankAccount.getC_Bank_ID()).forEach(bpAccount -> {
                    String constant = "3";
                    MBPartner bPartner = MBPartner.get((Properties)Env.getCtx(), (int)bpAccount.getC_BPartner_ID());
                    String bpAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bpAccountNo).isPresent()) {
                        bpAccountNo = this.leftPadding(bpAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bPartner.getValue() + " - " + bPartner.getName())));
                    }
                    String bpaName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bpaName).isPresent()) {
                        bpaName = bpaName.substring(0, bpaName.length() >= 30 ? 30 : bpaName.length());
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bPartner.getValue() + " - " + bPartner.getName())));
                    }
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        String bpTaxIdChar = bPTaxId.substring(0, 1);
                        bPTaxId = bPTaxId.substring(1, bPTaxId.length());
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                        bPTaxId = bpTaxIdChar + bPTaxId;
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bPartner.getValue() + " - " + bPartner.getName())));
                    }
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 40, " ", true);
                    MUser bpContact = null;
                    if (bpAccount.getAD_User_ID() != 0) {
                        bpContact = MUser.get((Properties)Env.getCtx(), (int)bpAccount.getAD_User_ID());
                    }
                    String bPPhone = "";
                    if (Optional.ofNullable(bpContact).isPresent() && !Util.isEmpty((String)bpContact.getPhone())) {
                        bPPhone = this.processValue(bpContact.getPhone());
                    }
                    bPPhone = this.rightPadding(bPPhone, 20, " ", true);
                    StringBuffer line = new StringBuffer();
                    line.append(constant).append("/").append(bpaName).append("/").append(bPTaxId).append("/").append(bpAccountNo).append("/").append(bPPhone).append("/").append(bPEmail).append(Env.NL);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                });
                this.closeFileWriter();
            }
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private String getFileName(File file, String bankName, boolean isEnroll, boolean isSameBank) {
        if (file == null) {
            return null;
        }
        String sameBankMessage = "MB";
        String otherBankMessage = "OB";
        String enrollMessage = "AFI";
        String noEnrollMessage = "DES";
        String dateAsString = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String extension = ".txt";
        StringBuffer pathName = new StringBuffer();
        if (file.isFile() || !file.exists()) {
            pathName.append(file.getParent());
        } else {
            pathName.append(file.getAbsolutePath());
        }
        pathName.append(File.separator).append(isEnroll ? enrollMessage : noEnrollMessage).append("_").append(bankName).append("_").append(isSameBank ? sameBankMessage : otherBankMessage).append("_").append(dateAsString).append(extension);
        return pathName.toString().replace(" ", "_");
    }
}

