/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class BOD
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(BOD.class);
    private final String DATE_FORMAT = "yyyyMMdd";
    private final String REFERENCE_DATE_FORMAT = "yyyy/MM/dd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MCurrency currency = MCurrency.get((Properties)Env.getCtx(), (int)bankAccount.getC_Currency_ID());
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            StringBuffer header = new StringBuffer();
            String registerType = "01";
            String transactionType = this.rightPadding("PROVEEDORES", 20, " ");
            String personType = "";
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            if (!Util.isEmpty((String)orgTaxId)) {
                orgTaxId = orgTaxId.replace("-", "").trim();
                personType = orgTaxId.substring(0, 1);
                orgTaxId = this.getNumericOnly(orgTaxId);
                orgTaxId = this.leftPadding(orgTaxId, 9, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@TaxID@ @NotFound@"));
            }
            String bankClientNo = bankAccount.get_ValueAsString("BankClientNo");
            if (!Util.isEmpty((String)bankClientNo)) {
                bankClientNo = bank.get_ValueAsString("BankClientNo");
            }
            if (!Util.isEmpty((String)bankClientNo)) {
                bankClientNo = this.processValue(bankClientNo);
                bankClientNo = this.leftPadding(bankClientNo, 17, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@BankClientNo@ @NotFound@"));
            }
            String paymentRequestNo = this.processValue(paySelection.getDocumentNo());
            paymentRequestNo = this.getNumericOnly(paymentRequestNo);
            paymentRequestNo = this.leftPadding(paymentRequestNo, 9, "0", true);
            String paymentRequestDate = dateFormat.format(paySelection.getPayDate());
            String paymentQty = this.leftPadding(String.valueOf(checks.size()), 6, "0");
            String totalAmtAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", "").replace(",", "");
            if (totalAmtAsString.length() > 17) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
            }
            totalAmtAsString = this.leftPadding(totalAmtAsString, 17, "0", true);
            String iSOCode = currency.getISO_Code();
            String constant = this.leftPadding("", 158, " ");
            header = new StringBuffer();
            header.append(registerType).append(transactionType).append(personType).append(orgTaxId).append(bankClientNo).append(paymentRequestNo).append(paymentRequestDate).append(paymentQty).append(totalAmtAsString).append(iSOCode).append(constant);
            this.writeLine(header.toString());
            String payDate = dateFormat.format(paySelection.getPayDate());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)paySelectionCheck.getCtx(), (int)paySelectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)paySelectionCheck, true);
                if (bpAccount != null) {
                    String bPAccountNo;
                    MUser bpContact = null;
                    if (bpAccount.getAD_User_ID() != 0) {
                        bpContact = MUser.get((Properties)Env.getCtx(), (int)bpAccount.getAD_User_ID());
                    }
                    MBank bpBank = MBank.get((Properties)Env.getCtx(), (int)bpAccount.getC_Bank_ID());
                    String lineRegisterType = "02";
                    String bPPersonType = "";
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPPersonType = bPTaxId.substring(0, 1);
                        bPTaxId = this.getNumericOnly(bPTaxId);
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 60, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String documentNo = this.processValue(paySelectionCheck.getDocumentNo());
                    documentNo = this.getNumericOnly(documentNo);
                    documentNo = this.leftPadding(documentNo, 9, "0", true);
                    String lineDescription = this.processValue(this.getDetail((MPaySelectionCheck)paySelectionCheck));
                    lineDescription = this.rightPadding(lineDescription, 30, " ", true);
                    String paymentType = "CTA";
                    if (!(Util.isEmpty((String)bank.getSwiftCode()) || Util.isEmpty((String)bpBank.getSwiftCode()) || bank.getSwiftCode().equals(bpBank.getSwiftCode()))) {
                        paymentType = "BAN";
                    }
                    if (Optional.ofNullable(bPAccountNo = this.processValue(bpAccount.getAccountNo())).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPRoutingNo = "";
                    if (Util.isEmpty((String)bpBank.getRoutingNo())) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@RoutingNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    bPRoutingNo = this.processValue(bpBank.getRoutingNo());
                    bPRoutingNo = this.leftPadding(bPRoutingNo, 4, "0", true);
                    String amountAsString = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 17) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
                    }
                    amountAsString = amountAsString.substring(0, amountAsString.length() >= 17 ? 17 : amountAsString.length());
                    amountAsString = this.leftPadding(amountAsString, 15, "0");
                    String withholdingTaxAsString = String.format("%.2f", Env.ZERO).replace(".", "").replace(",", "");
                    withholdingTaxAsString = this.leftPadding(withholdingTaxAsString, 15, "0", true);
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 40, " ", true);
                    String bPPhone = "";
                    if (Optional.ofNullable(bpContact).isPresent() && !Util.isEmpty((String)bpContact.getPhone())) {
                        bPPhone = this.processValue(bpContact.getPhone());
                    }
                    bPPhone = this.rightPadding(bPPhone, 11, " ", true);
                    String constantLine = this.rightPadding("", 20, " ", true);
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(lineRegisterType).append(bPPersonType).append(bPTaxId).append(bPName).append(documentNo).append(lineDescription).append(paymentType).append(bPAccountNo).append(bPRoutingNo).append(payDate).append(amountAsString).append(iSOCode).append(withholdingTaxAsString).append(bPEmail).append(bPPhone).append(constantLine);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                    this.writeDetail((MPaySelectionCheck)paySelectionCheck);
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private void writeDetail(MPaySelectionCheck check) {
        check.getPaySelectionLinesAsList(false).stream().forEach(paySelectionLine -> {
            MCurrency currency;
            String registerType = "03";
            String documentNo = null;
            BigDecimal documentAmount = Env.ZERO;
            String iSOCode = null;
            Timestamp documentDate = null;
            BigDecimal withholdingTax = Env.ZERO;
            MPaySelection paymentSelection = (MPaySelection)paySelectionLine.getC_PaySelection();
            MCurrency defaultCurrency = null;
            if (paymentSelection.getC_Currency_ID() != 0) {
                defaultCurrency = MCurrency.get((Properties)Env.getCtx(), (int)paymentSelection.getC_Currency_ID());
            }
            if (paySelectionLine.getC_Invoice_ID() != 0) {
                MInvoice invoice = (MInvoice)paySelectionLine.getC_Invoice();
                documentNo = invoice.getDocumentNo();
                documentAmount = invoice.getGrandTotal();
                if (invoice.getC_Currency_ID() != 0) {
                    currency = MCurrency.get((Properties)Env.getCtx(), (int)invoice.getC_Currency_ID());
                    iSOCode = currency.getISO_Code();
                }
                documentDate = invoice.getDateInvoiced();
            } else if (paySelectionLine.getC_Order_ID() != 0) {
                MOrder order = (MOrder)paySelectionLine.getC_Order();
                documentNo = order.getDocumentNo();
                documentAmount = order.getGrandTotal();
                if (order.getC_Currency_ID() != 0) {
                    currency = MCurrency.get((Properties)Env.getCtx(), (int)order.getC_Currency_ID());
                    iSOCode = currency.getISO_Code();
                }
                documentDate = order.getDateOrdered();
            } else if (paySelectionLine.getHR_Movement_ID() != 0) {
                MHRMovement movement = (MHRMovement)paySelectionLine.getHR_Movement();
                MHRProcess payrollProcess = (MHRProcess)movement.getHR_Process();
                documentNo = payrollProcess.getDocumentNo();
                documentAmount = movement.getAmount();
                documentDate = payrollProcess.getDateAcct();
            } else {
                documentNo = "SP-" + paymentSelection.getDocumentInfo();
                documentAmount = check.getPayAmt();
                documentDate = paymentSelection.getDateDoc();
            }
            if (Util.isEmpty(iSOCode)) {
                if (defaultCurrency == null) {
                    this.addError("@C_Currency_ID@ @NotFound@: " + documentNo);
                } else {
                    iSOCode = defaultCurrency.getISO_Code();
                }
            }
            documentNo = this.rightPadding(documentNo, 20, " ");
            String documentAmountAsString = String.format("%.2f", documentAmount.abs()).replace(".", "").replace(",", "");
            documentAmountAsString = this.leftPadding(documentAmountAsString, 15, "0", true);
            String documentDateAsString = new SimpleDateFormat("yyyy/MM/dd").format(documentDate);
            String withholdingTaxAsString = String.format("%.2f", withholdingTax).replace(".", "").replace(",", "");
            withholdingTaxAsString = this.leftPadding(withholdingTaxAsString, 15, "0", true);
            String constant = this.leftPadding("", 187, " ");
            StringBuffer line = new StringBuffer();
            line.append(Env.NL).append(registerType).append(documentNo).append(documentAmountAsString).append(iSOCode).append(documentDateAsString).append(withholdingTaxAsString).append(constant);
            s_log.fine("Write Line");
            this.writeLine(line.toString());
        });
    }
}

