/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.X_C_PaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class BNC_v1
extends LVEPaymentExportList {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";
    private static CLogger s_log = CLogger.getCLogger(BNC_v1.class);
    private final String DATE_FORMAT = "ddMMyyyy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
            StringBuffer header = new StringBuffer();
            String registerType = "C";
            String paymentRequestNo = this.processValue(paySelection.getDocumentNo());
            paymentRequestNo = this.getNumericOnly(paymentRequestNo);
            paymentRequestNo = this.leftPadding(paymentRequestNo, 10, "0", true);
            AtomicReference<String> debitAccount = new AtomicReference<String>(bankAccount.getAccountNo());
            if (!Util.isEmpty((String)debitAccount.get())) {
                debitAccount.set(this.leftPadding(debitAccount.get(), 20, "0", true));
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@AccountNo@ @IsMandatory@"));
            }
            String paymentQty = this.leftPadding(String.valueOf(checks.size()), 5, "0");
            String totalAmtAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", "").replace(",", "");
            if (totalAmtAsString.length() > 15) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
            }
            totalAmtAsString = this.leftPadding(totalAmtAsString, 15, "0", true);
            header = new StringBuffer();
            header.append(registerType).append(paymentQty).append(totalAmtAsString).append(paymentRequestNo).append("S").append("S").append("S").append("00");
            this.writeLine(header.toString());
            String payDate = dateFormat.format(paySelection.getPayDate());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)paySelectionCheck.getCtx(), (int)paySelectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)paySelectionCheck, true);
                if (bpAccount != null) {
                    String lineRegisterType = "D";
                    String bPPersonType = "";
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPPersonType = bPTaxId.substring(0, 1);
                        bPTaxId = this.getNumericOnly(bPTaxId);
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 80, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String lineDescription = this.processValue(this.getDetail((MPaySelectionCheck)paySelectionCheck));
                    lineDescription = this.rightPadding(lineDescription, 30, " ", true);
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String amountAsString = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 15) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ @Invalid@"));
                    }
                    amountAsString = this.leftPadding(amountAsString, 15, "0", true);
                    String comment = this.getDetail((MPaySelectionCheck)paySelectionCheck);
                    if (Util.isEmpty((String)comment)) {
                        comment = "";
                    }
                    comment = this.rightPadding(comment, 60, " ", true);
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 100, " ", true);
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(lineRegisterType).append(payDate).append((String)debitAccount.get()).append(bPAccountNo).append(amountAsString).append(comment).append(bPPersonType).append(bPTaxId).append(bPName).append(bPEmail).append(bPPersonType).append(bPTaxId);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            Map<Integer, List<MPaySelectionCheck>> vendors = checks.stream().collect(Collectors.groupingBy(X_C_PaySelectionCheck::getC_BPartner_ID));
            vendors.entrySet().forEach(vendorCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)((Integer)vendorCheck.getKey()));
                MPaySelectionCheck check = (MPaySelectionCheck)((List)vendorCheck.getValue()).get(0);
                MBPBankAccount bpAccount = this.getBPAccountInfo(check, true);
                if (bpAccount != null) {
                    String bPPersonType = "";
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        bPPersonType = bPTaxId.substring(0, 1);
                        bPTaxId = this.getNumericOnly(bPTaxId);
                        bPTaxId = this.leftPadding(bPTaxId, 9, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 80, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String lineDescription = this.processValue(this.getDetail(check));
                    lineDescription = this.rightPadding(lineDescription, 30, " ", true);
                    String bPAccountNo = this.processValue(bpAccount.getAccountNo());
                    if (Optional.ofNullable(bPAccountNo).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String maximumAmountAsString = this.leftPadding("", 15, "0", true);
                    String comment = this.getDetail(check);
                    if (Util.isEmpty((String)comment)) {
                        comment = "";
                    }
                    comment = this.rightPadding(comment, 60, " ", true);
                    String bPEmail = "";
                    if (!Util.isEmpty((String)bpAccount.getA_EMail())) {
                        bPEmail = bpAccount.getA_EMail();
                    }
                    bPEmail = this.rightPadding(bPEmail, 100, " ", true);
                    String maximumOperations = "00";
                    String operationsFrequency = "00";
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(bPAccountNo).append(bPName).append(bPPersonType).append(bPTaxId).append(bPPersonType).append(bPTaxId).append(maximumAmountAsString).append(bPEmail).append(maximumOperations).append(operationsFrequency);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
            });
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    @Override
    public String processValue(String value) {
        if (Util.isEmpty((String)value)) {
            return value;
        }
        return value.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$,;*/\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00bf\u00a1.-]", "");
    }
}

