/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.bank.exp;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.bank.exp.LVEPaymentExportList;

public class BFC
extends LVEPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(BFC.class);
    private final String SHORT_DATE_FORMAT = "yyyyMMdd";
    private final String TIME_FORMAT = "HHmmss";
    private int paymentQty = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            MBankAccount bankAccount = (MBankAccount)paySelection.getC_BankAccount();
            MOrgInfo orgInfo = MOrgInfo.get((Properties)paySelection.getCtx(), (int)paySelection.getAD_Org_ID(), (String)paySelection.get_TrxName());
            MClient client = MClient.get((Properties)orgInfo.getCtx(), (int)orgInfo.getAD_Client_ID());
            MBank bank = MBank.get((Properties)bankAccount.getCtx(), (int)bankAccount.getC_Bank_ID());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");
            String sequence = this.leftPadding("", 6, "0");
            String sequence2 = this.leftPadding("", 14, "0");
            Date now = new Date(System.currentTimeMillis());
            String bankClientNo = "";
            if (!Util.isEmpty((String)bank.get_ValueAsString("BankClientNo"))) {
                bankClientNo = this.processValue(bank.get_ValueAsString("BankClientNo"));
                bankClientNo = this.leftPadding(bankClientNo, 6, "0", true);
            } else {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@BankClientNo@ @NotFound@"));
            }
            String serviceCode = this.leftPadding("77", 6, "0");
            String sequence3 = this.leftPadding("", 1, " ");
            String accountType = "CC";
            if (bankAccount.getBankAccountType().equals("S")) {
                accountType = "CA";
            }
            String bankAccountNo = this.processValue(bankAccount.getAccountNo());
            bankAccountNo = bankAccountNo.replace(" ", "");
            bankAccountNo = this.leftPadding(bankAccountNo, 22, "0", true);
            String sequence4 = this.leftPadding("", 3, " ");
            String sequence5 = this.leftPadding("", 34, "0");
            String orgTaxId = this.processValue(orgInfo.getTaxID().replace("-", ""));
            orgTaxId = this.leftPadding(orgTaxId, 10, " ", true);
            String sequence6 = this.leftPadding("", 48, "0");
            StringBuffer header = new StringBuffer();
            header.append(sequence).append(dateFormat.format(now)).append(timeFormat.format(now)).append(dateFormat.format(paySelection.getPayDate())).append(timeFormat.format(paySelection.getPayDate())).append(sequence2).append(bankClientNo).append(serviceCode).append(sequence3).append(accountType).append(bankAccountNo).append(sequence4).append(sequence5).append(orgTaxId).append(sequence6);
            this.writeLine(header.toString());
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
                MBPartner bpartner = MBPartner.get((Properties)paySelectionCheck.getCtx(), (int)paySelectionCheck.getC_BPartner_ID());
                MBPBankAccount bpAccount = this.getBPAccountInfo((MPaySelectionCheck)paySelectionCheck, true);
                if (bpAccount != null) {
                    String bPAccountNo;
                    String lineNo = this.leftPadding(String.valueOf(this.getPaymentQty()), 6, "0");
                    String constant = this.leftPadding("", 1, " ");
                    String vendorAccountType = "CC";
                    if (!Util.isEmpty((String)bpAccount.getBankAccountType()) && bpAccount.getBankAccountType().equals("S")) {
                        vendorAccountType = "CA";
                    }
                    if (Optional.ofNullable(bPAccountNo = this.processValue(bpAccount.getAccountNo())).isPresent()) {
                        bPAccountNo = this.leftPadding(bPAccountNo, 20, "0", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@AccountNo@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String personType = "";
                    String bPTaxId = bpAccount.getA_Ident_SSN();
                    if (!Util.isEmpty((String)bPTaxId)) {
                        bPTaxId = bPTaxId.replace("-", "").trim();
                        personType = bPTaxId.substring(0, 1);
                        bPTaxId = bPTaxId.replaceAll("\\D+", "");
                        bPTaxId = this.leftPadding(bPTaxId, 10, "0", true);
                        if (this.isNumeric(personType)) {
                            personType = "V";
                        }
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@BPTaxID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String constant2 = this.leftPadding("", 20, "0");
                    String amountAsString = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(".", "").replace(",", "");
                    if (amountAsString.length() > 15) {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@PayAmt@ > @Invalid@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    } else {
                        amountAsString = this.leftPadding(amountAsString, 15, "0", true);
                    }
                    String constant3 = "C";
                    String constant4 = this.leftPadding("", 1, "0");
                    String bPName = this.processValue(bpAccount.getA_Name());
                    if (Optional.ofNullable(bPName).isPresent()) {
                        bPName = this.rightPadding(bPName, 40, " ", true);
                    } else {
                        this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@A_Name@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                    }
                    String constant5 = this.leftPadding("", 4, "0");
                    String constant6 = this.leftPadding("", 40, " ");
                    String constant7 = this.leftPadding("", 9, "0");
                    StringBuffer line = new StringBuffer();
                    line.append(Env.NL).append(lineNo).append(constant).append(vendorAccountType).append(bPAccountNo).append(personType).append(bPTaxId).append(constant2).append(amountAsString).append(constant3).append(constant4).append(bPName).append(constant5).append(constant6).append(constant7);
                    s_log.fine("Write Line");
                    this.writeLine(line.toString());
                } else {
                    this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)("@C_BP_BankAccount_ID@ @NotFound@: " + bpartner.getValue() + " - " + bpartner.getName())));
                }
                this.addPaymentToCounter();
            });
            String constant = this.leftPadding("", 6, "9", true);
            String clientName = this.processValue(client.getName());
            clientName = clientName.substring(0, clientName.length() >= 40 ? 40 : clientName.length());
            clientName = this.rightPadding(clientName, 40, " ");
            String recordsNo = this.leftPadding("" + checks.size(), 6, "0");
            String totalAmtAsString = String.format("%.2f", paySelection.getTotalAmt().abs()).replace(".", "").replace(",", "");
            if (totalAmtAsString.length() > 15) {
                this.addError(Msg.parseTranslation((Properties)Env.getCtx(), (String)"@PayAmt@ > @Valid@"));
            } else {
                totalAmtAsString = this.leftPadding(totalAmtAsString, 15, "0", true);
            }
            String countDebts = this.leftPadding("" + checks.size(), 6, "0");
            String countCredits = this.leftPadding("" + checks.size(), 6, "0");
            String constant2 = this.leftPadding("", 76, "0");
            StringBuffer footer = new StringBuffer();
            footer.append(Env.NL).append(constant).append(clientName).append(recordsNo).append(totalAmtAsString).append(totalAmtAsString).append(countDebts).append(countCredits).append(constant2);
            this.writeLine(footer.toString());
            this.closeFileWriter();
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private int getPaymentQty() {
        return this.paymentQty;
    }

    private void addPaymentToCounter() {
        ++this.paymentQty;
    }
}

