/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.text;

public abstract class DataUtils {
    public static String leftPadding(String text, int length, String padd) {
        return DataUtils.addPadding(text, length, padd, true);
    }

    public static String rightPadding(String text, int length, String padd) {
        return DataUtils.addPadding(text, length, padd, false);
    }

    public static String addPadding(String text, int length, String padd, boolean left) {
        if (text == null || padd == null) {
            return text;
        }
        String format = "%1$";
        if (!left) {
            format = "%1$-";
        }
        return String.format(format + length + "s", text).replace(" ", padd);
    }

    public static String processValue(String value) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        return value.replaceAll("[+^:,&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()]", "");
    }

    public static String getOnlyAlphanumeric(String value) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        return value.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static String getOnlyValueAndName(String value) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        return value.replaceAll("[^a-zA-Z0-9 -]", "");
    }

    public static String leftPadding(String text, int length, String padding, boolean isFixedLength) {
        return DataUtils.addPadding(text, length, padding, isFixedLength, true);
    }

    public static String rightPadding(String text, int length, String padding, boolean isFixedLength) {
        return DataUtils.addPadding(text, length, padding, isFixedLength, false);
    }

    public static String cutString(String text, int length) {
        if (text == null) {
            return text;
        }
        return text.substring(0, text.length() >= length ? length : text.length());
    }

    public static String addPadding(String text, int length, String padding, boolean isFixedLength, boolean isLeft) {
        if (text == null || text.trim().length() == 0) {
            text = "";
        }
        String processedText = text;
        if (isFixedLength) {
            processedText = DataUtils.cutString(processedText, length);
        }
        processedText = isLeft ? DataUtils.leftPadding(processedText, length, padding) : DataUtils.rightPadding(processedText, length, padding);
        return processedText;
    }

    public boolean isNumeric(String value) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        return value.matches("[+-]?\\d*(\\.\\d+)?");
    }

    public static String getNumericOnly(String value) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        return value.replaceAll("\\D+", "");
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

