/*
 * Decompiled with CFR 0.152.
 */
package org.spin.net.grpc.util;

import java.util.Arrays;
import java.util.Optional;
import org.spin.grpc.util.Document;
import org.spin.net.grpc.util.FiscalPrintSender;
import org.spin.util.event.PrinterEvent;
import org.spin.util.event.PrinterEventListener;

public class TestSender
implements PrinterEventListener {
    private FiscalPrintSender service;

    public TestSender(FiscalPrintSender service) {
        this.service = service;
        this.service.addListener(this);
        this.service.start();
        for (int i = 1; i <= 10; ++i) {
            this.service.printDocument(Document.newBuilder().setDocumentType(Document.DocumentType.INVOICE).setPrinterName(this.service.getPrinterName()).build());
        }
    }

    public static void main(String[] args) throws Exception {
        Optional<String> parameter;
        if (args == null) {
            throw new Exception("Arguments Not Found");
        }
        if (args.length < 3) {
            throw new Exception("Arguments Must Be: [Host, Port, PrinterName]");
        }
        int port = 50043;
        if (args != null && (parameter = Arrays.asList(args).stream().filter(arg -> arg != null && arg.trim().length() > 0).filter(arg -> arg.matches("[+-]?\\d*(\\.\\d+)?")).findFirst()).isPresent()) {
            port = Integer.parseInt(parameter.get());
        }
        new TestSender(new FiscalPrintSender(args[0], port, 0L, args[2]));
    }

    @Override
    public void messageReceived(PrinterEvent ev) {
        System.err.println(ev);
    }
}

