/*
 * Decompiled with CFR 0.152.
 */
package org.spin.net.grpc.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.spin.base.setup.SetupLoader;
import org.spin.grpc.util.PrinterResponse;
import org.spin.net.grpc.util.FiscalPrintReceiver;
import org.spin.util.event.PrinterEvent;
import org.spin.util.event.PrinterEventListener;

public class TestReceiver
implements PrinterEventListener {
    private FiscalPrintReceiver client;
    private AtomicInteger counter = new AtomicInteger(1);

    public TestReceiver(FiscalPrintReceiver client) {
        this.client = client;
        this.client.addListener(this);
        this.client.start();
    }

    public static void main(String[] args) throws Exception {
        if (args == null) {
            throw new Exception("Arguments Not Found");
        }
        if (args == null || args.length == 0) {
            throw new Exception("Arguments Must Be: [property file name]");
        }
        String setupFileName = args[0];
        if (setupFileName == null || setupFileName.trim().length() == 0) {
            throw new Exception("Setup File not found");
        }
        SetupLoader.loadSetup(setupFileName);
        SetupLoader.getInstance().validateLoad();
        new TestReceiver(new FiscalPrintReceiver());
    }

    @Override
    public void messageReceived(PrinterEvent ev) {
        this.client.sendPrinterResponse(PrinterResponse.newBuilder().setIsError(false).setLastInvoiceNo("" + this.counter.getAndAdd(1)).setDocumentUuid(ev.getDocument().getDocumentUuid()).setPrinterName(this.client.getPrinterName()).build());
    }
}

