/*
 * Decompiled with CFR 0.152.
 */
package org.spin.net.grpc.util;

import java.io.File;
import org.spin.net.grpc.util.Constants;

public class Folder
implements Constants {
    private String homeFolder;

    public Folder(String homeFolder) {
        this.homeFolder = homeFolder;
    }

    public String getHomeFolder() {
        return this.getValidPath(this.homeFolder);
    }

    private String getValidPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return path;
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getLogFolder() {
        return this.getMainFolder() + File.separator + "log";
    }

    public String getBackupFolder() {
        return this.getMainFolder() + File.separator + "backup";
    }

    public String getDatabaseFolder() {
        return this.getMainFolder() + File.separator + "database";
    }

    public String getMainFolder() {
        return this.getHomeFolder() + File.separator + "PrintService";
    }

    public void createMainFolder() {
        this.createFolder(this.getMainFolder());
    }

    public void createBackupFolder() {
        this.createFolder(this.getBackupFolder());
    }

    public void createLogFolder() {
        this.createFolder(this.getLogFolder());
    }

    public void createDatabaseFolder() {
        this.createFolder(this.getDatabaseFolder());
    }

    private void createFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

