/*
 * Decompiled with CFR 0.152.
 */
package org.spin.net.grpc.util;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.base.printer.SenderListener;
import org.spin.grpc.util.Document;
import org.spin.grpc.util.FiscalPrintServiceGrpc;
import org.spin.grpc.util.PrinterResponse;
import org.spin.grpc.util.ResponseStatus;
import org.spin.grpc.util.Subscription;
import org.spin.util.event.PrinterEvent;
import org.spin.util.event.PrinterEventListener;

public class FiscalPrintSender
implements Runnable {
    private static final Logger logger = Logger.getLogger(FiscalPrintSender.class.getName());
    private final ManagedChannel channel;
    private final FiscalPrintServiceGrpc.FiscalPrintServiceStub stub;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private String printerName;
    private long timeout = 0L;
    private final long DEFAULT_TIMEOUT = 60000L;
    private Thread worker;
    StringBuffer lastSpoolerLog;
    private Logger log = Logger.getLogger(FiscalPrintSender.class.getName());
    private List<PrinterEventListener> listeners = new ArrayList<PrinterEventListener>();

    public FiscalPrintSender(String host, int port, long timeout, String printerName) {
        this.printerName = printerName;
        this.timeout = timeout;
        if (timeout <= 0L) {
            this.timeout = 60000L;
        }
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.stub = FiscalPrintServiceGrpc.newStub((Channel)this.channel);
    }

    public synchronized void addListener(PrinterEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(PrinterEventListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void actionResponse(PrinterResponse respnse) {
        PrinterEvent event = new PrinterEvent(this, respnse);
        Iterator<PrinterEventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().messageReceived(event);
        }
    }

    public void printDocumentNoWait(Document document) throws Exception {
        SenderListener listener = new SenderListener(this);
        this.stub.printDocument(document, listener);
        Thread.sleep(100L);
        if (Optional.ofNullable(listener.getErrorMessage()).isPresent()) {
            throw new Exception(listener.getErrorMessage());
        }
    }

    public void printDocument(Document document) {
        try {
            StreamObserver<ResponseStatus> listener = new StreamObserver<ResponseStatus>(){

                public void onNext(ResponseStatus status) {
                    logger.info("Response: " + status);
                }

                public void onError(Throwable error) {
                    logger.severe("Error: " + error.getLocalizedMessage());
                    FiscalPrintSender.this.actionResponse(PrinterResponse.newBuilder().setPrinterName(FiscalPrintSender.this.getPrinterName()).setIsError(true).setResult(error.getLocalizedMessage()).build());
                    FiscalPrintSender.this.stop();
                }

                public void onCompleted() {
                    FiscalPrintSender.this.shutdown();
                }
            };
            this.stub.printDocument(document, listener);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e);
            return;
        }
    }

    private void subscribe() throws InterruptedException {
        try {
            StreamObserver<PrinterResponse> listener = new StreamObserver<PrinterResponse>(){

                public void onNext(PrinterResponse response) {
                    logger.info("Response from Printer: " + response);
                    FiscalPrintSender.this.actionResponse(response);
                    FiscalPrintSender.this.stop();
                }

                public void onError(Throwable error) {
                    logger.severe("Error: " + error.getLocalizedMessage());
                    FiscalPrintSender.this.stop();
                }

                public void onCompleted() {
                    FiscalPrintSender.this.stop();
                }
            };
            this.stub.subscribeSender(Subscription.newBuilder().setPrinterName(this.printerName).setType(Subscription.Type.SENDER).build(), listener);
            long end = System.currentTimeMillis() + this.timeout;
            while (this.running.get()) {
                if (System.currentTimeMillis() < end) continue;
                logger.info("Timeout");
                this.actionResponse(PrinterResponse.newBuilder().setPrinterName(this.getPrinterName()).setIsError(true).setResult("@Timeout@").build());
                break;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e);
            return;
        }
    }

    public void start() {
        this.log.info("Thread created");
        this.worker = new Thread(this);
        this.worker.start();
    }

    public void shutdown() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public void stop() {
        this.running.set(false);
        this.shutdown();
    }

    @Override
    public void run() {
        this.running.set(true);
        try {
            this.log.info("Reading...");
            this.subscribe();
            this.log.info("Sleeping...");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.severe("Thread was interrupted, Failed to complete operation");
        }
        catch (Exception e) {
            this.shutdown();
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public String getPrinterName() {
        return this.printerName;
    }
}

