/*
 * Decompiled with CFR 0.152.
 */
package org.spin.net.grpc.util;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.spin.base.setup.SetupLoader;
import org.spin.grpc.util.Document;
import org.spin.grpc.util.FiscalPrintServiceGrpc;
import org.spin.grpc.util.PrinterResponse;
import org.spin.grpc.util.ResponseStatus;
import org.spin.grpc.util.Subscription;
import org.spin.net.grpc.util.Folder;
import org.spin.util.event.PrinterEvent;
import org.spin.util.event.PrinterEventListener;

public class FiscalPrintReceiver
implements Runnable {
    private static final Logger logger = Logger.getLogger(FiscalPrintReceiver.class.getName());
    private ManagedChannel channel;
    private FiscalPrintServiceGrpc.FiscalPrintServiceStub stub;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Folder folderUtil;
    private Thread worker;
    StringBuffer lastSpoolerLog;
    private List<PrinterEventListener> listeners = new ArrayList<PrinterEventListener>();
    private Logger log = Logger.getLogger(FiscalPrintReceiver.class.getName());
    private final long DEFAULT_RECONNECTION_INTERVAL = 10000L;

    public FiscalPrintReceiver() {
        this.folderUtil = new Folder(SetupLoader.getInstance().getPrinter().getFolder());
        this.connect();
        this.folderUtil.createMainFolder();
        this.saveLog();
    }

    private void connect() {
        this.channel = ManagedChannelBuilder.forAddress((String)SetupLoader.getInstance().getServer().getHost(), (int)SetupLoader.getInstance().getServer().getPort()).usePlaintext().build();
        this.stub = FiscalPrintServiceGrpc.newStub((Channel)this.channel);
    }

    public void sendPrinterResponse(PrinterResponse response) {
        try {
            StreamObserver<ResponseStatus> listener = new StreamObserver<ResponseStatus>(){

                public void onNext(ResponseStatus response) {
                    logger.info("Result: " + response);
                }

                public void onError(Throwable error) {
                    logger.severe("Error: " + error.getLocalizedMessage());
                    FiscalPrintReceiver.this.validateError(error);
                }

                public void onCompleted() {
                    logger.severe("Completed");
                    FiscalPrintReceiver.this.stop();
                }
            };
            this.stub.sendPrintResponse(response, listener);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e);
            return;
        }
    }

    protected String backupFile(Document document) {
        if (document.getDocumentUuid() == null) {
            this.log.severe("File name Not Found");
            return null;
        }
        String fileName = this.getDateName() + "_" + document.getDocumentUuid();
        try {
            this.folderUtil.createBackupFolder();
            FileOutputStream fileOutputStream = new FileOutputStream(this.folderUtil.getBackupFolder() + File.separator + fileName);
            fileOutputStream.close();
            this.log.info("File write: " + fileName);
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        return fileName;
    }

    private String getDateName() {
        return new SimpleDateFormat("yyyyMMdd_hhmmss").format(new Date(System.currentTimeMillis()));
    }

    private void saveLog() {
        try {
            this.folderUtil.createLogFolder();
            FileHandler fileHandler = new FileHandler(this.folderUtil.getLogFolder() + File.separator + this.getDateName() + "_PrintService.log");
            this.log.addHandler(fileHandler);
            fileHandler.setFormatter(new SimpleFormatter());
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public synchronized void addListener(PrinterEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(PrinterEventListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void printDocument(Document document) {
        PrinterEvent event = new PrinterEvent(this, document);
        logger.info("Event Received: " + event);
        Iterator<PrinterEventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().messageReceived(event);
        }
    }

    private void validateError(Throwable error) {
        StatusRuntimeException statusException;
        if (error instanceof StatusRuntimeException && (statusException = (StatusRuntimeException)error).getStatus().getCode().equals((Object)Status.UNAVAILABLE.getCode())) {
            if (SetupLoader.getInstance().getServer().isReconnect()) {
                long interval = SetupLoader.getInstance().getServer().getInterval();
                if (interval <= 0L) {
                    interval = 10000L;
                }
                try {
                    Thread.sleep(interval);
                    this.subscribePrinter();
                }
                catch (InterruptedException e) {
                    logger.severe(e.getLocalizedMessage());
                }
            } else {
                this.stop();
            }
        }
    }

    public void subscribe() throws InterruptedException {
        this.subscribePrinter();
        while (this.running.get()) {
        }
    }

    private void subscribePrinter() {
        try {
            StreamObserver<Document> listener = new StreamObserver<Document>(){

                public void onNext(Document document) {
                    logger.info("To Print: " + document);
                    FiscalPrintReceiver.this.printDocument(document);
                }

                public void onError(Throwable error) {
                    logger.severe("Error: " + error.getLocalizedMessage());
                    FiscalPrintReceiver.this.validateError(error);
                }

                public void onCompleted() {
                    FiscalPrintReceiver.this.stop();
                }
            };
            this.stub.subscribePrinter(Subscription.newBuilder().setPrinterName(SetupLoader.getInstance().getPrinter().getName()).setType(Subscription.Type.PRINTER).build(), listener);
            this.log.info("Reading...");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e);
            return;
        }
    }

    public void start() {
        this.log.info("Thread created");
        this.worker = new Thread(this);
        this.worker.start();
    }

    private void shutdown() {
        try {
            if (this.channel != null) {
                this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public void stop() {
        this.shutdown();
        this.running.set(false);
    }

    @Override
    public void run() {
        this.running.set(true);
        try {
            this.subscribe();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.severe("Thread was interrupted, Failed to complete operation");
        }
        catch (Exception e) {
            this.shutdown();
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public String getPrinterName() {
        return SetupLoader.getInstance().getPrinter().getName();
    }
}

