/*
 * Decompiled with CFR 0.152.
 */
package org.spin.net.grpc.util;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.spin.base.setup.SetupLoader;
import org.spin.grpc.util.FiscalPrintServiceGrpc;
import org.spin.grpc.util.PrinterResponse;
import org.spin.grpc.util.Subscription;
import org.spin.util.event.PrinterEvent;
import org.spin.util.event.PrinterEventListener;

public class FiscalPrintListener
implements Runnable {
    private static final Logger logger = Logger.getLogger(FiscalPrintListener.class.getName());
    private final ManagedChannel channel;
    private final FiscalPrintServiceGrpc.FiscalPrintServiceStub stub;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private String listenerName;
    private Thread worker;
    StringBuffer lastSpoolerLog;
    private Logger log = Logger.getLogger(FiscalPrintListener.class.getName());
    private List<PrinterEventListener> listeners = new ArrayList<PrinterEventListener>();
    private final long DEFAULT_RECONNECTION_INTERVAL = 10000L;

    public FiscalPrintListener(String host, int port, String listenerName) {
        this.listenerName = listenerName;
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.stub = FiscalPrintServiceGrpc.newStub((Channel)this.channel);
    }

    public synchronized void addListener(PrinterEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(PrinterEventListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void actionResponse(PrinterResponse respnse) {
        PrinterEvent event = new PrinterEvent(this, respnse);
        Iterator<PrinterEventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().messageReceived(event);
        }
    }

    private void subscribe() throws InterruptedException {
        this.subscribePrinter();
        while (this.running.get()) {
        }
    }

    private void subscribePrinter() {
        try {
            StreamObserver<PrinterResponse> listener = new StreamObserver<PrinterResponse>(){

                public void onNext(PrinterResponse response) {
                    logger.info("Response from Printer: " + response);
                    FiscalPrintListener.this.actionResponse(response);
                }

                public void onError(Throwable error) {
                    logger.severe("Error: " + error.getLocalizedMessage());
                    FiscalPrintListener.this.validateError(error);
                }

                public void onCompleted() {
                    FiscalPrintListener.this.stop();
                }
            };
            this.stub.subscribeListener(Subscription.newBuilder().setListenerName(this.listenerName).setType(Subscription.Type.LISTENER).build(), listener);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "RPC failed: {0}", e);
            return;
        }
    }

    private void validateError(Throwable error) {
        StatusRuntimeException statusException;
        if (error instanceof StatusRuntimeException && (statusException = (StatusRuntimeException)error).getStatus().getCode().equals((Object)Status.UNAVAILABLE.getCode())) {
            if (SetupLoader.getInstance().getServer().isReconnect()) {
                long interval = SetupLoader.getInstance().getServer().getInterval();
                if (interval <= 0L) {
                    interval = 10000L;
                }
                try {
                    Thread.sleep(interval);
                    this.subscribePrinter();
                }
                catch (InterruptedException e) {
                    logger.severe(e.getLocalizedMessage());
                }
            } else {
                this.stop();
            }
        }
    }

    public void start() {
        this.log.info("Thread created");
        this.worker = new Thread(this);
        this.worker.start();
    }

    private void shutdown() {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public void stop() {
        this.running.set(false);
        this.shutdown();
    }

    @Override
    public void run() {
        this.running.set(true);
        try {
            this.log.info("Reading...");
            this.subscribe();
            this.log.info("Sleeping...");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.severe("Thread was interrupted, Failed to complete operation");
        }
        catch (Exception e) {
            this.shutdown();
            this.log.severe(e.getLocalizedMessage());
        }
    }

    public String getPrinterName() {
        return this.listenerName;
    }
}

