/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.setup;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import org.spin.base.setup.Database;
import org.spin.base.setup.Listener;
import org.spin.base.setup.Printer;
import org.spin.base.setup.Server;
import org.spin.base.setup.SetupWrapper;

public class SetupLoader {
    private static SetupLoader instance;
    private SetupWrapper setup;

    private SetupLoader(String filePath) throws JsonParseException, JsonMappingException, IOException {
        File setupFile = new File(filePath);
        ObjectMapper fileMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.setup = (SetupWrapper)fileMapper.readValue(setupFile, SetupWrapper.class);
    }

    public static SetupLoader getInstance() {
        return instance;
    }

    public static void loadSetup(String filePath) throws JsonParseException, JsonMappingException, IOException {
        instance = new SetupLoader(filePath);
    }

    public void validateLoad() throws Exception {
        if (this.setup == null) {
            throw new Exception("Setup not found");
        }
    }

    public final Server getServer() {
        return this.setup.getServer();
    }

    public final Printer getPrinter() {
        return this.setup.getPrinter();
    }

    public final SetupWrapper getSetup() {
        return this.setup;
    }

    public final Database getDatabase() {
        return this.setup.getDatabase();
    }

    public final Listener getListener() {
        return this.setup.getListener();
    }
}

