/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.printer;

import io.grpc.stub.StreamObserver;
import java.util.logging.Logger;
import org.spin.grpc.util.ResponseStatus;
import org.spin.net.grpc.util.FiscalPrintSender;

public class SenderListener
implements StreamObserver<ResponseStatus> {
    private FiscalPrintSender callback;
    private String errorMessage;
    private static final Logger logger = Logger.getLogger(SenderListener.class.getName());

    public SenderListener(FiscalPrintSender callback) {
        this.callback = callback;
    }

    public void onNext(ResponseStatus status) {
        logger.info("Response: " + status);
    }

    public void onError(Throwable error) {
        logger.severe("Error: " + error.getLocalizedMessage());
        this.errorMessage = error.getLocalizedMessage();
        this.callback.shutdown();
    }

    public void onCompleted() {
        this.callback.shutdown();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

