/*
 * Decompiled with CFR 0.152.
 */
package org.spin.base.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.spin.grpc.util.Document;
import org.spin.grpc.util.DocumentLine;
import org.spin.grpc.util.DocumentPayment;
import org.spin.grpc.util.DocumentTax;
import org.spin.grpc.util.PrinterResponse;
import org.spin.net.grpc.util.Folder;

public class DatabaseManager {
    private static DatabaseManager instance;
    private Connection connection = null;
    private final String DATABASE_NAME = "LocalPrinting.db";
    private static final Logger logger;
    private Folder folderUtil;

    public static DatabaseManager getInstance(String homeFolder) {
        if (instance == null) {
            instance = new DatabaseManager(homeFolder);
        }
        return instance;
    }

    public static DatabaseManager getInstance() {
        return instance;
    }

    private DatabaseManager(String homeFolder) {
        this.folderUtil = new Folder(homeFolder);
        this.saveLog();
        this.connect();
    }

    private void connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return;
            }
            this.folderUtil.createDatabaseFolder();
            String url = "jdbc:sqlite:" + this.folderUtil.getDatabaseFolder() + File.separator + "LocalPrinting.db";
            logger.info("Database URL: " + url);
            this.connection = DriverManager.getConnection(url);
            logger.info("Connected to the database");
            DatabaseMetaData databaseMetadata = this.connection.getMetaData();
            logger.info("Driver name: " + databaseMetadata.getDriverName());
            logger.info("Driver version: " + databaseMetadata.getDriverVersion());
            logger.info("Product name: " + databaseMetadata.getDatabaseProductName());
            logger.info("Product version: " + databaseMetadata.getDatabaseProductVersion());
            this.createInitialDefinition();
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException se) {
                logger.severe(se.getLocalizedMessage());
            }
        }
    }

    private void saveLog() {
        try {
            this.folderUtil.createLogFolder();
            FileHandler fileHandler = new FileHandler(this.folderUtil.getLogFolder() + File.separator + this.getDateName() + "_DataBase.log");
            logger.addHandler(fileHandler);
            fileHandler.setFormatter(new SimpleFormatter());
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    private String getDateName() {
        return new SimpleDateFormat("yyyyMMdd_hhmmss").format(new Date(System.currentTimeMillis()));
    }

    private String getFormattedDate(long longDate) {
        if (longDate == 0L) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss").format(new Date(longDate));
    }

    private void createInitialDefinition() {
        try {
            Statement statement = this.connection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS Document (documentId INTEGER PRIMARY KEY AUTOINCREMENT, documentUuid TEXT NOT NULL, documentType INTEGER, setupType INTEGER, businessPartnerName TEXT, businessPartnerTaxId TEXT, address1 TEXT, address2 TEXT, address3 TEXT, address4 TEXT, cityName TEXT, regionName TEXT, countryName TEXT, description TEXT, documentNote TEXT, reversalDocumentNo TEXT, reversalDocumentDate TEXT, reversalFiscalPrinterNo TEXT, poReferenceNo TEXT, soReferenceNo TEXT, salesRepresentativeValue TEXT, salesRepresentativeName TEXT, paymentTerm TEXT, salesRegionValue TEXT, salesRegionName TEXT, totalLines REAL, grandTotal REAL, amountInWords TEXT, documentTypeName TEXT, deliveryAddress TEXT, deliveryPhone TEXT, warehouseName TEXT, documentDate TEXT, documentNo TEXT, businessPartnerDuns TEXT, productsQuantities INTEGER, posName TEXT, discountPrinted TEXT, clientName TEXT, clientId INTEGER, organizationName TEXT, organizationId INTEGER, documentTypeId INTEGER, docbasetype TEXT, businessPartnerValue TEXT, businessPartnerName2 TEXT, sipmentDate TEXT, shipmentDocNo TEXT, subtotal REAL, priceListName TEXT, soDocumentNo TEXT, createdBy TEXT, userName TEXT, userValue TEXT, currencyName TEXT, currencyCode TEXT, isPriceListSo TEXT, isPriceListIncludesTax TEXT )");
            statement.execute("CREATE TABLE IF NOT EXISTS DocumentLine (documentLineId INTEGER PRIMARY KEY AUTOINCREMENT, documentLineUuid TEXT NOT NULL, documentId INTEGER, productValue TEXT, productName TEXT, productDescription TEXT, productBarCode TEXT, quantity REAL, productPrice REAL, taxRate REAL, discount REAL, lineDescription TEXT, productPriceList REAL, discountAmt REAL, taxedAmt REAL, exemptedAmt REAL, notTaxedAmt REAL, productAsi TEXT, uomName TEXT, uomSymbol TEXT)");
            statement.execute("CREATE TABLE IF NOT EXISTS DocumentTax (documentTaxId INTEGER PRIMARY KEY AUTOINCREMENT, documentId INTEGER, taxValue TEXT, taxName TEXT, taxBaseAmount REAL, taxAmount REAL, taxRate REAL)");
            statement.execute("CREATE TABLE IF NOT EXISTS DocumentPayment (documentPaymentId INTEGER PRIMARY KEY AUTOINCREMENT, documentId INTEGER, referenceNo TEXT, tenderType TEXT, tenderTypeName TEXT, description TEXT, amount REAL, convertedAmount REAL, paymentDate TEXT, currencyCode TEXT, currencyName TEXT, bankName TEXT, bankSwiftCode TEXT, bankAccountName TEXT, bankAccountIban TEXT, serNo TEXT, checkNo TEXT)");
            statement.execute("CREATE TABLE IF NOT EXISTS PrinterResponse (printerResponseId INTEGER PRIMARY KEY AUTOINCREMENT, documentId INTEGER, isError TEXT, result TEXT, printerName TEXT, lastInvoiceNo TEXT, lastCreditMemoNo TEXT, fiscalPrinterNo TEXT, printDate TEXT, isSentToServer TEXT, sendDate TEXT)");
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public int saveDocument(Document document) {
        int documentId = -1;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO Document (documentUuid, documentType, setupType, businessPartnerName, businessPartnerTaxId, address1, address2, address3, address4, cityName, regionName, countryName, description, documentNote, reversalDocumentNo, reversalDocumentDate, reversalFiscalPrinterNo, poReferenceNo, soReferenceNo, salesRepresentativeValue, salesRepresentativeName, paymentTerm, salesRegionValue, salesRegionName, totalLines, grandTotal, amountInWords, documentTypeName, deliveryAddress, deliveryPhone, warehouseName, documentDate, documentNo, businessPartnerDuns, productsQuantities, posName, discountPrinted, clientName, clientId, organizationName, organizationId, documentTypeId, docbasetype, businessPartnerValue, businessPartnerName2, sipmentDate, shipmentDocNo, subtotal, priceListName, soDocumentNo, createdBy, userName, userValue, currencyName, currencyCode, isPriceListSo, isPriceListIncludesTax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int index = 1;
            preparedStatement.setString(index++, document.getDocumentUuid());
            preparedStatement.setInt(index++, document.getDocumentTypeValue());
            preparedStatement.setInt(index++, document.getSetupTypeValue());
            preparedStatement.setString(index++, document.getBusinessPartnerName());
            preparedStatement.setString(index++, document.getBusinessPartnerTaxId());
            preparedStatement.setString(index++, document.getAddress1());
            preparedStatement.setString(index++, document.getAddress2());
            preparedStatement.setString(index++, document.getAddress3());
            preparedStatement.setString(index++, document.getAddress4());
            preparedStatement.setString(index++, document.getCityName());
            preparedStatement.setString(index++, document.getRegionName());
            preparedStatement.setString(index++, document.getCountryName());
            preparedStatement.setString(index++, document.getDescription());
            preparedStatement.setString(index++, document.getDocumentNote());
            preparedStatement.setString(index++, document.getReversalDocumentNo());
            preparedStatement.setString(index++, this.getFormattedDate(document.getReversalDocumentDate()));
            preparedStatement.setString(index++, document.getReversalFiscalPrinterNo());
            preparedStatement.setString(index++, document.getPoReferenceNo());
            preparedStatement.setString(index++, document.getSoReferenceNo());
            preparedStatement.setString(index++, document.getSalesRepresentativeValue());
            preparedStatement.setString(index++, document.getSalesRepresentativeName());
            preparedStatement.setString(index++, document.getPaymentTerm());
            preparedStatement.setString(index++, document.getSalesRegionValue());
            preparedStatement.setString(index++, document.getSalesRegionName());
            preparedStatement.setDouble(index++, document.getTotalLines());
            preparedStatement.setDouble(index++, document.getGrandTotal());
            preparedStatement.setString(index++, document.getAmountInWords());
            preparedStatement.setString(index++, document.getDocumentTypeName());
            preparedStatement.setString(index++, document.getDeliveryAddress());
            preparedStatement.setString(index++, document.getDeliveryPhone());
            preparedStatement.setString(index++, document.getWarehouseName());
            preparedStatement.setString(index++, this.getFormattedDate(document.getDocumentDate()));
            preparedStatement.setString(index++, document.getDocumentNo());
            preparedStatement.setString(index++, document.getBusinessPartnerDuns());
            preparedStatement.setInt(index++, document.getProductsQuantities());
            preparedStatement.setString(index++, document.getPosName());
            preparedStatement.setBoolean(index++, document.getDiscountPrinted());
            preparedStatement.setString(index++, document.getClientName());
            preparedStatement.setInt(index++, document.getClientId());
            preparedStatement.setString(index++, document.getOrganizationName());
            preparedStatement.setInt(index++, document.getOrganizationId());
            preparedStatement.setInt(index++, document.getDocumentTypeId());
            preparedStatement.setString(index++, document.getDocbasetype());
            preparedStatement.setString(index++, document.getBusinessPartnerValue());
            preparedStatement.setString(index++, document.getBusinessPartnerName2());
            preparedStatement.setString(index++, this.getFormattedDate(document.getShipmentDate()));
            preparedStatement.setString(index++, document.getShipmentDocNo());
            preparedStatement.setDouble(index++, document.getSubtotal());
            preparedStatement.setString(index++, document.getPriceListName());
            preparedStatement.setString(index++, document.getSoDocumentNo());
            preparedStatement.setString(index++, document.getCreatedBy());
            preparedStatement.setString(index++, document.getUserName());
            preparedStatement.setString(index++, document.getUserValue());
            preparedStatement.setString(index++, document.getCurrencyName());
            preparedStatement.setString(index++, document.getCurrencyCode());
            preparedStatement.setBoolean(index++, document.getIsPriceListSo());
            preparedStatement.setBoolean(index++, document.getIsPriceListIncludesTax());
            int insertedRow = preparedStatement.executeUpdate();
            if (insertedRow > 0) {
                int lastId;
                documentId = lastId = this.getLastId();
                logger.info("Last Document Id for " + document.getDocumentNo() + "(" + document.getDocumentUuid() + "): " + documentId);
                document.getDocumentLinesList().forEach(documentLine -> this.saveDocumentLine((DocumentLine)documentLine, lastId));
                document.getDocumentTaxesList().forEach(documentTax -> this.saveDocumentTax((DocumentTax)documentTax, lastId));
                document.getDocumentPaymentsList().forEach(documentPayment -> this.saveDocumentPayment((DocumentPayment)documentPayment, lastId));
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return documentId;
    }

    private int saveDocumentLine(DocumentLine documentLine, int documentId) {
        int documentLineId = -1;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO DocumentLine (documentLineUuid, documentId, productValue, productName, productDescription, productBarCode, quantity, productPrice, taxRate, discount, lineDescription, productPriceList, discountAmt, taxedAmt, exemptedAmt, notTaxedAmt, productAsi, uomName, uomSymbol) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int index = 1;
            preparedStatement.setString(index++, documentLine.getDocumentLineUuid());
            preparedStatement.setInt(index++, documentId);
            preparedStatement.setString(index++, documentLine.getProductValue());
            preparedStatement.setString(index++, documentLine.getProductName());
            preparedStatement.setString(index++, documentLine.getProductDescription());
            preparedStatement.setString(index++, documentLine.getProductBarCode());
            preparedStatement.setDouble(index++, documentLine.getQuantity());
            preparedStatement.setDouble(index++, documentLine.getProductPrice());
            preparedStatement.setDouble(index++, documentLine.getTaxRate());
            preparedStatement.setDouble(index++, documentLine.getDiscount());
            preparedStatement.setString(index++, documentLine.getLineDescription());
            preparedStatement.setDouble(index++, documentLine.getProductPriceList());
            preparedStatement.setDouble(index++, documentLine.getDiscountAmt());
            preparedStatement.setDouble(index++, documentLine.getTaxedAmt());
            preparedStatement.setDouble(index++, documentLine.getExemptedAmt());
            preparedStatement.setDouble(index++, documentLine.getNotTaxedAmt());
            preparedStatement.setString(index++, documentLine.getProductAsi());
            preparedStatement.setString(index++, documentLine.getUomName());
            preparedStatement.setString(index++, documentLine.getUomSymbol());
            int insertedRow = preparedStatement.executeUpdate();
            if (insertedRow > 0) {
                documentLineId = this.getLastId();
            }
            logger.info("Last Document Line Id for " + documentLine.getProductName() + "(" + documentLine.getDocumentLineUuid() + "): " + documentLineId);
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return documentLineId;
    }

    private int saveDocumentTax(DocumentTax documentTax, int documentId) {
        int documentTaxId = -1;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO DocumentTax (documentId, taxValue, taxName, taxBaseAmount, taxAmount, taxRate) VALUES (?, ?, ?, ?, ?, ?)");
            int index = 1;
            preparedStatement.setInt(index++, documentId);
            preparedStatement.setString(index++, documentTax.getTaxValue());
            preparedStatement.setString(index++, documentTax.getTaxName());
            preparedStatement.setDouble(index++, documentTax.getTaxBaseAmount());
            preparedStatement.setDouble(index++, documentTax.getTaxAmount());
            preparedStatement.setDouble(index++, documentTax.getTaxRate());
            int insertedRow = preparedStatement.executeUpdate();
            if (insertedRow > 0) {
                documentTaxId = this.getLastId();
            }
            logger.info("Last Tax Id for " + documentTax.getTaxName() + ": " + documentTaxId);
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return documentTaxId;
    }

    private int saveDocumentPayment(DocumentPayment documentPayment, int documentId) {
        int documentPaymentId = -1;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO DocumentPayment (documentId, referenceNo, tenderType, tenderTypeName, description, amount, convertedAmount, paymentDate, currencyCode, currencyName, bankName, bankSwiftCode, bankAccountName, bankAccountIban, serNo, checkNo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int index = 1;
            preparedStatement.setInt(index++, documentId);
            preparedStatement.setString(index++, documentPayment.getReferenceNo());
            preparedStatement.setString(index++, documentPayment.getTenderType());
            preparedStatement.setString(index++, documentPayment.getTenderTypeName());
            preparedStatement.setString(index++, documentPayment.getDescription());
            preparedStatement.setDouble(index++, documentPayment.getAmount());
            preparedStatement.setDouble(index++, documentPayment.getConvertedAmount());
            preparedStatement.setString(index++, this.getFormattedDate(documentPayment.getPaymentDate()));
            preparedStatement.setString(index++, documentPayment.getCurrencyCode());
            preparedStatement.setString(index++, documentPayment.getCurrencyName());
            preparedStatement.setString(index++, documentPayment.getBankName());
            preparedStatement.setString(index++, documentPayment.getBankSwiftCode());
            preparedStatement.setString(index++, documentPayment.getBankAccountName());
            preparedStatement.setString(index++, documentPayment.getBankAccountIban());
            preparedStatement.setString(index++, documentPayment.getSerNo());
            preparedStatement.setString(index++, documentPayment.getCheckNo());
            int insertedRow = preparedStatement.executeUpdate();
            if (insertedRow > 0) {
                documentPaymentId = this.getLastId();
            }
            logger.info("Last Payment Id for " + documentPayment.getSerNo() + "-" + documentPayment.getCheckNo() + ": " + documentPaymentId);
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return documentPaymentId;
    }

    public int savePrinterResponse(PrinterResponse printerResponse, int documentId) {
        int printerResponseId = -1;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("INSERT INTO PrinterResponse (documentId, isError, result, printerName, lastInvoiceNo, lastCreditMemoNo, fiscalPrinterNo, printDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            int index = 1;
            preparedStatement.setInt(index++, documentId);
            preparedStatement.setString(index++, printerResponse.getIsError() ? "Y" : "N");
            preparedStatement.setString(index++, printerResponse.getResult());
            preparedStatement.setString(index++, printerResponse.getPrinterName());
            preparedStatement.setString(index++, printerResponse.getLastInvoiceNo());
            preparedStatement.setString(index++, printerResponse.getLastCreditMemoNo());
            preparedStatement.setString(index++, printerResponse.getFiscalPrinterNo());
            preparedStatement.setString(index++, this.getFormattedDate(printerResponse.getPrintDate()));
            int insertedRow = preparedStatement.executeUpdate();
            if (insertedRow > 0) {
                printerResponseId = this.getLastId();
            }
            logger.info("Last Printer Response Id for " + printerResponse.getPrinterName() + ": " + printerResponseId);
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return printerResponseId;
    }

    public void updatePrinterResponse(boolean isSentToServer, long sendDate, int printerResponseId) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE PrinterResponse SET isSentToServer = ?, sendDate = ? WHERE printerResponseId = ?");
            int index = 1;
            preparedStatement.setString(index++, isSentToServer ? "Y" : "N");
            preparedStatement.setString(index++, this.getFormattedDate(sendDate));
            preparedStatement.setInt(index++, printerResponseId);
            preparedStatement.execute();
            logger.info("Printer response updated: " + printerResponseId);
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    private int getLastId() {
        int lastId = -1;
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT last_insert_rowid()");
            if (resultSet.next()) {
                lastId = resultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
        }
        return lastId;
    }

    static {
        logger = Logger.getLogger(DatabaseManager.class.getName());
    }
}

