/*
 * Decompiled with CFR 0.152.
 */
package org.spin.appwrite120.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MUser;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.appwrite120.utils.IAppWriteData;
import org.spin.queue.store.event.ECommerceEventListener;
import org.spin.queue.store.support.IECommerce;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.queue.store.util.FindCriteria;

public class User
implements IAppWriteData {
    private AppWrite api = null;
    private static final String ATTRIBUTE_USERID = "userId";
    private static final String ATTRIBUTE_EMAIL = "email";
    private static final String ATTRIBUTE_PHONE = "phone";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private static final String ATTRIBUTE_PASSWORD_VERSION = "passwordVersion";
    private static final String ATTRIBUTE_PASSWORD_SALT = "passwordSalt";
    private static final String ATTRIBUTE_PASSWORD_CPU = "passwordCpu";
    private static final String ATTRIBUTE_PASSWORD_MEMORY = "passwordMemory";
    private static final String ATTRIBUTE_PASSWORD_PARALLEL = "passwordParallel";
    private static final String ATTRIBUTE_PASSWORD_LENGTH = "passwordLength";
    private static final String ATTRIBUTE_PASSWORD_SALT_SEPARATOR = "passwordSaltSeparator";
    private static final String ATTRIBUTE_PASSWORD_SALT_SINGER_KEY = "passwordSignerKey";
    private static final String ATTRIBUTE_HASH = "hash";
    private static final String ATTRIBUTE_HASH_OPTIONS = "hashOptions";
    private static final String ATTRIBUTE_REGISTRATION = "registration";
    private static final String ATTRIBUTE_STATUS = "status";
    private static final String ATTRIBUTE_PASSWORD_UPDATE = "passwordUpdate";
    private static final String ATTRIBUTE_EMAIL_VERIFICATION = "emailVerification";
    private static final String ATTRIBUTE_PHONE_VERIFICATION = "phoneVerification";
    private static final String ATTRIBUTE_PREF = "prefs";
    private static final String USER_AUTH = "userAuth";
    public static final String USER_AUTH_EMAIL = "email";
    public static final String USER_AUTH_BCRYPT = "bcrypt";
    public static final String USER_AUTH_MD5 = "md5";
    public static final String USER_AUTH_ARGON2 = "argon2";
    public static final String USER_AUTH_SHA = "sha";
    public static final String USER_AUTH_PHPASS = "phpass";
    public static final String USER_AUTH_SCRYPT = "scrypt";
    public static final String USER_AUTH_SCRYPT_MODIFIED = "scrypt-modified";
    private Map<String, Object> userValues = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("$id", "");
            this.put(User.ATTRIBUTE_USERID, "unique()");
            this.put("email", "");
            this.put(User.ATTRIBUTE_PHONE, "");
            this.put(User.USER_AUTH, "email");
            this.put(User.ATTRIBUTE_PASSWORD, "");
            this.put("name", "");
            this.put(User.ATTRIBUTE_PASSWORD_VERSION, "");
            this.put(User.ATTRIBUTE_PASSWORD_SALT, "");
            this.put(User.ATTRIBUTE_PASSWORD_CPU, 0);
            this.put(User.ATTRIBUTE_PASSWORD_MEMORY, 0);
            this.put(User.ATTRIBUTE_PASSWORD_PARALLEL, 0);
            this.put(User.ATTRIBUTE_PASSWORD_LENGTH, 0);
            this.put(User.ATTRIBUTE_PASSWORD_SALT_SEPARATOR, "");
            this.put(User.ATTRIBUTE_PASSWORD_SALT_SINGER_KEY, "");
        }
    };

    public static User newInstance() {
        return new User();
    }

    public User withUser(MUser user) {
        Optional.ofNullable(user).ifPresent(currentUser -> {
            this.setUserId(currentUser.getUUID());
            this.setEmail(currentUser.getEMail());
            this.setPhone(currentUser.getPhone());
            this.setPassword(currentUser.getUserPIN());
            this.setName(currentUser.getName());
        });
        return this;
    }

    public String getUserId() {
        return this.getStringValue(ATTRIBUTE_USERID);
    }

    public String getUserAuthentication() {
        return this.getStringValue(USER_AUTH);
    }

    public String getName() {
        return this.getStringValue("name");
    }

    public String getEmail() {
        return this.getStringValue("email");
    }

    public String getPhone() {
        return this.getStringValue(ATTRIBUTE_PHONE);
    }

    public String getPassword() {
        return this.getStringValue(ATTRIBUTE_PASSWORD);
    }

    public String getPasswordVersion() {
        return this.getStringValue(ATTRIBUTE_PASSWORD_VERSION);
    }

    public String getPasswordSalt() {
        return this.getStringValue(ATTRIBUTE_PASSWORD_SALT);
    }

    public String getPasswordSaltSeparator() {
        return this.getStringValue(ATTRIBUTE_PASSWORD_SALT_SEPARATOR);
    }

    public String getPasswordSaltSingerKey() {
        return this.getStringValue(ATTRIBUTE_PASSWORD_SALT_SINGER_KEY);
    }

    public int getPasswordCpu() {
        return this.getIntValue(ATTRIBUTE_PASSWORD_CPU);
    }

    public int getPasswordMemory() {
        return this.getIntValue(ATTRIBUTE_PASSWORD_MEMORY);
    }

    public int getPasswordParallel() {
        return this.getIntValue(ATTRIBUTE_PASSWORD_PARALLEL);
    }

    public int getPasswordLength() {
        return this.getIntValue(ATTRIBUTE_PASSWORD_LENGTH);
    }

    public int getIntValue(String key) {
        return Integer.valueOf(Optional.ofNullable(String.valueOf(this.userValues.get(key))).orElse("0"));
    }

    public String getStringValue(String key) {
        return String.valueOf(Optional.ofNullable(String.valueOf(this.userValues.get(key))).orElse(""));
    }

    public void setUserId(String userId) {
        this.setValue(ATTRIBUTE_USERID, userId);
    }

    public void setUserAuthentication(String userAuth) {
        this.setValue(USER_AUTH, userAuth);
    }

    public void setName(String name) {
        this.setValue("name", name);
    }

    public void setEmail(String email) {
        this.setValue("email", email);
    }

    public void setPhone(String phone) {
        this.setValue(ATTRIBUTE_PHONE, phone);
    }

    public void setPassword(String password) {
        this.setValue(ATTRIBUTE_PASSWORD, password);
    }

    public void setPasswordVersion(String passwordVersion) {
        this.setValue(ATTRIBUTE_PASSWORD_VERSION, passwordVersion);
    }

    public void setPasswordSalt(String salt) {
        this.setValue(ATTRIBUTE_PASSWORD_SALT, salt);
    }

    public void setPasswordSaltSeparator(String saltSeparator) {
        this.setValue(ATTRIBUTE_PASSWORD_SALT_SEPARATOR, saltSeparator);
    }

    public void setPasswordSaltSingerKey(String saltSingerKey) {
        this.setValue(ATTRIBUTE_PASSWORD_SALT_SINGER_KEY, saltSingerKey);
    }

    public void setPasswordCpu(int passwordCpu) {
        this.setValue(ATTRIBUTE_PASSWORD_CPU, passwordCpu);
    }

    public void setPasswordMemory(int passwordMemory) {
        this.setValue(ATTRIBUTE_PASSWORD_MEMORY, passwordMemory);
    }

    public void setPasswordParallel(int passwordParallel) {
        this.setValue(ATTRIBUTE_PASSWORD_PARALLEL, passwordParallel);
    }

    public void setPasswordLength(int passwordLength) {
        this.setValue(ATTRIBUTE_PASSWORD_LENGTH, passwordLength);
    }

    @Override
    public Map<String, Object> parseOutputData(JSONObject data) {
        Optional<JSONObject> maybeResponseData = Optional.ofNullable(data);
        HashMap<String, Object> parsedData = new HashMap<String, Object>();
        maybeResponseData.ifPresent(responseData -> {
            if (responseData.toMap().get("error") == null) {
                if (this.api.getAction().equals("L")) {
                    Optional<JSONArray> maybeUsers = Optional.ofNullable(responseData.getJSONArray("users"));
                    maybeUsers.ifPresent(usersObj -> usersObj.forEach(userObj -> {
                        JSONObject user = (JSONObject)userObj;
                        parsedData.put(user.getString("$id"), this.parseDataFromJson(user));
                    }));
                } else if (this.api.getAction().equals("G") || this.api.getAction().equals("C") || this.api.getAction().equals("U")) {
                    JSONObject user = responseData;
                    this.setId(user.getString("$id"));
                    parsedData.put(user.getString("$id"), this.parseDataFromJson(user));
                } else if (this.api.getAction().equals("D")) {
                    JSONObject database = responseData;
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("response", database.getString("response"));
                    parsedData.put("response", item);
                }
            }
        });
        this.api.clearPaths();
        return parsedData;
    }

    private HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("$id", data.getString("$id"));
        item.put("$createdAt", data.getString("$createdAt"));
        item.put("$updatedAt", data.getString("$updatedAt"));
        item.put("name", data.getString("name"));
        item.put(ATTRIBUTE_REGISTRATION, data.getString(ATTRIBUTE_REGISTRATION));
        item.put(ATTRIBUTE_STATUS, data.getBoolean(ATTRIBUTE_STATUS));
        item.put(ATTRIBUTE_PASSWORD_UPDATE, data.getString(ATTRIBUTE_PASSWORD_UPDATE));
        item.put("email", data.getString("email"));
        item.put(ATTRIBUTE_PHONE, data.getString(ATTRIBUTE_PHONE));
        item.put(ATTRIBUTE_EMAIL_VERIFICATION, data.getBoolean(ATTRIBUTE_EMAIL_VERIFICATION));
        item.put(ATTRIBUTE_PHONE_VERIFICATION, data.getBoolean(ATTRIBUTE_PHONE_VERIFICATION));
        item.put(ATTRIBUTE_PREF, data.getJSONObject(ATTRIBUTE_PREF));
        return item;
    }

    private Map<String, Object> listUsers() {
        this.api.withPath("users");
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("L");
        return this.parseOutputData(data);
    }

    private Map<String, Object> getUser(String userId) {
        this.api.withPath("users");
        this.api.withPath(userId);
        this.api.withRequestType("GET");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("G");
        return this.parseOutputData(data);
    }

    private Map<String, Object> createUserIfNotExists() {
        AtomicReference<Object> responseParsed = new AtomicReference<Object>(null);
        String userEmail = this.getEmail();
        this.listUsers().entrySet().stream().filter(val -> ((Map)Optional.ofNullable((Map)val.getValue()).orElse(new HashMap())).get("email").toString().equals(userEmail)).forEach(dbase -> {
            HashMap result = new HashMap();
            this.setId((String)dbase.getKey());
            result.put(dbase.getKey(), dbase.getValue());
            responseParsed.set(result);
        });
        return Optional.ofNullable(responseParsed.get()).orElseGet(() -> this.sendUser());
    }

    private Map<String, Object> sendUser() {
        this.api.withPath("users");
        if (!this.getUserAuthentication().equals("email")) {
            this.api.withPath(this.getUserAuthentication());
        }
        this.api.withRequestType("POST");
        this.api.withDataToSend(ATTRIBUTE_USERID, this.getUserId());
        this.api.withDataToSend("email", this.getEmail());
        this.api.withDataToSend("name", this.getName());
        this.api.withDataToSend(ATTRIBUTE_PASSWORD, this.getPassword());
        if (this.getUserAuthentication().equals("email")) {
            this.api.withDataToSend(ATTRIBUTE_PHONE, this.getPhone());
        } else if (this.getUserAuthentication().equals(USER_AUTH_SHA)) {
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_VERSION, this.getPasswordVersion());
        } else if (this.getUserAuthentication().equals(USER_AUTH_SCRYPT)) {
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_SALT, this.getPasswordSalt());
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_CPU, this.getPasswordCpu());
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_MEMORY, this.getPasswordMemory());
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_PARALLEL, this.getPasswordParallel());
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_LENGTH, this.getPasswordLength());
        } else if (this.getUserAuthentication().equals(USER_AUTH_SCRYPT_MODIFIED)) {
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_SALT, this.getPasswordSalt());
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_SALT_SEPARATOR, this.getPasswordSaltSeparator());
            this.api.withDataToSend(ATTRIBUTE_PASSWORD_SALT_SINGER_KEY, this.getPasswordSaltSingerKey());
        }
        JSONObject data = this.api.getOutputData();
        this.api.setAction("C");
        return this.parseOutputData(data);
    }

    private Map<String, Object> update(String databaseid, String databaseName) {
        this.api.withPath("databases");
        this.api.withPath(databaseid);
        this.api.withRequestType("PUT");
        this.api.withDataToSend("name", databaseName);
        JSONObject data = this.api.getOutputData();
        this.api.setAction("U");
        return this.parseOutputData(data);
    }

    private Map<String, Object> delete(String databaseid) {
        this.api.withPath("databases");
        this.api.withPath(databaseid);
        this.api.withRequestType("DELETE");
        JSONObject data = this.api.getOutputData();
        this.api.setAction("D");
        return this.parseOutputData(data);
    }

    public void setId(String id) {
        this.userValues.put("$id", id);
    }

    public String getIdentifier() {
        return this.getStringValue("$id");
    }

    public Object getValue(String key) {
        return this.userValues.get(key);
    }

    public boolean isValid() {
        return false;
    }

    public void setValue(String key, Object value) {
        this.userValues.put(key, value);
    }

    public Map<String, Object> getAllValues() {
        return this.userValues;
    }

    public IECommerceEntity withApi(IECommerce api) {
        return this;
    }

    public IECommerceEntity withListener(ECommerceEventListener listener) {
        return this;
    }

    public IECommerceEntity create() {
        this.sendUser().entrySet().forEach(user -> this.setValue((String)user.getKey(), user.getValue()));
        return this;
    }

    public IECommerceEntity update() {
        this.update(this.getIdentifier(), this.getName());
        return this;
    }

    public IECommerceEntity delete() {
        this.delete(this.getIdentifier());
        return this;
    }

    public IECommerceEntity find(FindCriteria criteria) {
        return null;
    }

    public IECommerceEntity withWebStoreId(int webStoreId) {
        return this;
    }

    @Override
    public IAppWriteData withAppWriteApi(AppWrite api) {
        this.api = api;
        return this;
    }

    public String toString() {
        return this.userValues.toString();
    }

    @Override
    public Map<String, Object> list() {
        return this.listUsers();
    }

    @Override
    public Map<String, Object> get(String key) {
        return this.getUser(key);
    }
}

